/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import toast.deadlyWorld.Properties;
import toast.deadlyWorld.SpawnBuilder;
import toast.deadlyWorld.feature.SpawnerItem;

public class SpawnerItemCreeper
extends SpawnerItem {
    public static final int CHARGED_CHANCE = Math.max(0, Math.min(100, Properties.getInt("_general", "charged_creeper_chance")));
    public static final NBTTagCompound CHARGED_TAG = new NBTTagCompound();

    public SpawnerItemCreeper(NBTTagCompound tag, int wt, boolean rel, boolean brute) {
        super(tag, wt, rel, brute);
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        world.func_147465_d(x, y, z, Blocks.field_150474_ac, 0, 2);
        SpawnBuilder spawner = new SpawnBuilder(world, random, x, y, z);
        if (spawner.isValid) {
            this.copySpawnTag(this.itemTag, spawner.spawnerTag, x, y, z);
            if (random.nextInt(100) < CHARGED_CHANCE) {
                if (spawner.spawnerTag.func_74764_b("SpawnData")) {
                    NBTTagCompound data = spawner.spawnerTag.func_74775_l("SpawnData");
                    for (String name : CHARGED_TAG.func_150296_c()) {
                        data.func_74782_a(name, CHARGED_TAG.func_74781_a(name).func_74737_b());
                    }
                } else {
                    spawner.setSpawnData((NBTTagCompound)CHARGED_TAG.func_74737_b());
                }
            }
            spawner.write();
        }
        world.func_147471_g(x, y, z);
    }

    static {
        CHARGED_TAG.func_74757_a("powered", true);
    }
}

