/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import toast.deadlyWorld.Properties;
import toast.deadlyWorld.SpawnBuilder;
import toast.deadlyWorld.TagBuilder;
import toast.deadlyWorld._DeadlyWorld;
import toast.deadlyWorld.feature.BrutalSpawner;
import toast.deadlyWorld.feature.SpawnerItemCreeper;
import toast.deadlyWorld.feature.SpawnerItemRandom;
import toast.deadlyWorld.feature.WorldFeatureItem;

public class SpawnerItem
implements WorldFeatureItem {
    public final NBTTagCompound itemTag;
    private final int weight;
    public final boolean relative;
    public final boolean brutal;

    public static SpawnerItem[] buildItems(String name) {
        int length = _DeadlyWorld.DUNGEON_MOBS.length;
        if (name != "") {
            if (name == "dungeon") {
                length = _DeadlyWorld.DUNGEON_MOBS.length;
            } else if (name == "spawner_brutal") {
                length = _DeadlyWorld.SPAWNERS.length;
            } else if (name == "spawner_rogue") {
                length = _DeadlyWorld.SPAWNERS.length;
            } else if (name == "spawner_swarm") {
                length = _DeadlyWorld.MOBS.length;
            } else if (name == "spawner_vein") {
                length = _DeadlyWorld.SPAWNERS.length;
            } else if (name == "spawner_trap") {
                length = _DeadlyWorld.SPAWNERS.length;
            } else if (name == "potion") {
                length = _DeadlyWorld.POTIONS.length;
            }
        }
        SpawnerItem[] items = new SpawnerItem[length];
        for (int i = 0; i < length; ++i) {
            items[i] = SpawnerItem.buildSpawner(name, i);
        }
        return items;
    }

    public static SpawnerItem buildSpawner(String name, int index) {
        if (name != "") {
            if (name == "dungeon") {
                return SpawnerItem.buildMobSpawner(name, index, "dungeon_spawners", _DeadlyWorld.DUNGEON_MOBS);
            }
            if (name == "spawner_brutal") {
                return SpawnerItem.buildMobSpawner(name, index, "brutal_spawners", _DeadlyWorld.SPAWNERS);
            }
            if (name == "spawner_rogue") {
                return SpawnerItem.buildMobSpawner(name, index, "spawners", _DeadlyWorld.SPAWNERS);
            }
            if (name == "spawner_swarm") {
                return SpawnerItem.buildMobSpawner(name, index, "swarm_spawners", _DeadlyWorld.MOBS);
            }
            if (name == "spawner_vein") {
                return SpawnerItem.buildMobSpawner(name, index, "spawner_veins", _DeadlyWorld.SPAWNERS);
            }
            if (name == "spawner_trap") {
                NBTTagCompound tag = TagBuilder.createMobSpawnerTrap(_DeadlyWorld.SPAWNERS[index]);
                int weight = Properties.getInt("spawner_traps", _DeadlyWorld.SPAWNERS[index].toLowerCase());
                if (_DeadlyWorld.SPAWNERS[index].equalsIgnoreCase("RANDOM")) {
                    return new SpawnerItemRandom(tag, weight, true, false);
                }
                if (_DeadlyWorld.SPAWNERS[index].equalsIgnoreCase("CREEPER")) {
                    return new SpawnerItemCreeper(tag, weight, true, false);
                }
                return new SpawnerItem(tag, weight, true, false);
            }
            if (name == "potion") {
                return new SpawnerItem(TagBuilder.createPotionSpawner(_DeadlyWorld.POTIONS[index]), Properties.getInt("potion_traps", _DeadlyWorld.POTIONS[index].toLowerCase()), true, false);
            }
            if (name == "tnt") {
                return new SpawnerItem(TagBuilder.createTNTSpawner(), 0, true, false);
            }
            if (name == "fire") {
                return new SpawnerItem(TagBuilder.createFireSpawner(), 0, true, false);
            }
            if (name == "arrow") {
                return new SpawnerItem(TagBuilder.createArrowSpawner(index == 1), 0, true, false);
            }
            if (name == "silver_nest") {
                if (index == 2) {
                    TagBuilder tag = new TagBuilder(TagBuilder.createTNTSpawner());
                    tag.setPlayerRange(3);
                    return new SpawnerItem(tag.spawnerTag, 0, true, false);
                }
                TagBuilder tag = new TagBuilder(new NBTTagCompound());
                tag.setType("Silverfish");
                tag.setMinAndMaxDelay(Properties.getInt("nests", "_min_delay"), Properties.getInt("nests", "_max_delay"));
                tag.setSpawnCount(Properties.getInt("nests", "_spawn_count"));
                tag.setMaxNearbyEntities(Properties.getInt("nests", "_nearby_entity_cap"));
                tag.setSpawnRange(Properties.getInt("nests", "_spawn_range"));
                tag.setPlayerRange(Properties.getInt("nests", "_player_range"));
                if (index == 1) {
                    NBTTagCompound data = new NBTTagCompound();
                    TagBuilder.addPotionEffect(data, Potion.field_76436_u, 0);
                    TagBuilder.addPotionEffect(data, Potion.field_76428_l, 1);
                    TagBuilder.addPotionEffect(data, Potion.field_76420_g, 0);
                    TagBuilder.addPotionEffect(data, Potion.field_76429_m, 2);
                    tag.setSpawnData(data);
                }
                return new SpawnerItem(tag.spawnerTag, 0, false, false);
            }
        }
        return null;
    }

    private static SpawnerItem buildMobSpawner(String name, int index, String category, String[] mobArray) {
        boolean brutal;
        SpawnerItem item = null;
        int weight = Properties.getInt(category, mobArray[index].toLowerCase());
        boolean bl = brutal = name == "spawner_brutal";
        item = mobArray[index].equalsIgnoreCase("RANDOM") ? new SpawnerItemRandom(TagBuilder.createMobSpawnerRandom(name), weight, false, brutal) : (mobArray[index].equalsIgnoreCase("CREEPER") ? new SpawnerItemCreeper(TagBuilder.createMobSpawnerCreeper(name), weight, false, brutal) : new SpawnerItem(TagBuilder.createMobSpawner(name, mobArray[index]), weight, false, brutal));
        TagBuilder tag = new TagBuilder(item.itemTag);
        if (name == "spawner_vein") {
            tag.setPlayerRange(6);
            tag.setSpawnRange(10);
        } else {
            tag.setMinDelay(Properties.getInt(category, "_min_delay"));
            tag.setMaxDelay(Properties.getInt(category, "_max_delay"));
            tag.setSpawnCount(Properties.getInt(category, "_spawn_count"));
            tag.setMaxNearbyEntities(Properties.getInt(category, "_nearby_entity_cap"));
            tag.setSpawnRange(Properties.getInt(category, "_spawn_range"));
            tag.setPlayerRange(Properties.getInt(category, "_player_range"));
        }
        return item;
    }

    public static NBTTagCompound applyBrutalStats(NBTTagCompound tag) {
        for (String name : BrutalSpawner.BASE_TAG.func_150296_c()) {
            tag.func_74782_a(name, BrutalSpawner.BASE_TAG.func_74781_a(name).func_74737_b());
        }
        return tag;
    }

    public SpawnerItem(NBTTagCompound tag, int wt, boolean rel, boolean brute) {
        this.itemTag = (NBTTagCompound)tag.func_74737_b();
        this.weight = wt;
        this.relative = rel;
        this.brutal = brute;
        if (this.brutal) {
            NBTTagCompound data = this.itemTag.func_74775_l("SpawnData");
            if (!this.itemTag.func_74764_b("SpawnData")) {
                this.itemTag.func_74782_a("SpawnData", (NBTBase)data);
                if (this.itemTag.func_74779_i("EntityId") == "Skeleton") {
                    TagBuilder.setEquipment(data, new ItemStack((Item)Items.field_151031_f), null, null, null, null);
                }
            }
            SpawnerItem.applyBrutalStats(data);
            if (this.itemTag.func_74764_b("SpawnPotentials")) {
                int length;
                NBTTagList potentials = this.itemTag.func_150295_c("SpawnPotentials", (int)new NBTTagCompound().func_74732_a());
                int i = length = potentials.func_74745_c();
                while (i-- > 0) {
                    NBTTagCompound tagEntry = potentials.func_150305_b(i);
                    if (!tagEntry.func_74764_b("Properties")) continue;
                    SpawnerItem.applyBrutalStats(tagEntry.func_74775_l("Properties"));
                }
            }
        }
    }

    public void copySpawnTag(NBTTagCompound copyFrom, NBTTagCompound copyTo, int x, int y, int z) {
        if (this.relative) {
            this.copySpawnTagRel(copyFrom, copyTo, x, y, z);
        } else {
            for (String name : copyFrom.func_150296_c()) {
                copyTo.func_74782_a(name, copyFrom.func_74781_a(name));
            }
        }
    }

    private void copySpawnTagRel(NBTTagCompound copyFrom, NBTTagCompound copyTo, int x, int y, int z) {
        for (String name : copyFrom.func_150296_c()) {
            NBTBase tag = copyFrom.func_74781_a(name);
            if (name.equals("SpawnData")) {
                copyTo.func_74782_a(name, (NBTBase)TagBuilder.adjustSpawnData((NBTTagCompound)tag.func_74737_b(), x, y, z));
                continue;
            }
            if (name.equals("SpawnPotentials")) {
                copyTo.func_74782_a(name, (NBTBase)TagBuilder.adjustPotentials((NBTTagList)tag.func_74737_b(), x, y, z));
                continue;
            }
            copyTo.func_74782_a(name, tag.func_74737_b());
        }
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        world.func_147465_d(x, y, z, Blocks.field_150474_ac, 0, 2);
        SpawnBuilder spawner = new SpawnBuilder(world, random, x, y, z);
        if (spawner.isValid) {
            this.copySpawnTag(this.itemTag, spawner.spawnerTag, x, y, z);
            spawner.write();
        }
        world.func_147471_g(x, y, z);
    }

    @Override
    public int getWeight() {
        return this.weight;
    }
}

