/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import toast.deadlyWorld.ChestBuilder;
import toast.deadlyWorld._DeadlyWorld;
import toast.deadlyWorld.feature.Mine;
import toast.deadlyWorld.feature.WorldFeature;
import toast.deadlyWorld.feature.WorldGenerator;

public class RogueChest
implements WorldFeature {
    public static final int[] weights = WorldGenerator.getWeights("chests", _DeadlyWorld.CHESTS);
    public static final int totalWeight = WorldGenerator.getTotalWeight(weights);
    public final double frequency;

    public RogueChest(double freq) {
        this.frequency = freq;
    }

    @Override
    public void generate(World world, Random random, int x, int z) {
        if (this.frequency <= random.nextDouble()) {
            return;
        }
        x += random.nextInt(16);
        z += random.nextInt(16);
        int state = 0;
        for (int y = random.nextInt(50) + 11; y > 5; --y) {
            if (world.func_147445_c(x, y, z, true)) {
                if (state != 0) continue;
                if (this.canBePlaced(world, random, x, y + 1, z)) {
                    this.place(world, random, x, y + 1, z);
                    return;
                }
                state = -1;
                continue;
            }
            state = 0;
        }
    }

    @Override
    public boolean canBePlaced(World world, Random random, int x, int y, int z) {
        return world.func_147437_c(x, y, z) && world.func_147437_c(x, y + 1, z);
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        String type = WorldGenerator.choose(random, totalWeight, _DeadlyWorld.CHESTS, weights);
        if (type == "valuable") {
            ChestBuilder.place(world, random, x, y, z, "DeadlyWorld.chestRogueValuable");
        } else if (type == "trapped") {
            ChestBuilder.placeTrapped(world, random, x, y, z, ChestBuilder.getRogueChestByHeight(y));
            this.trapChest(world, random, x, y, z);
        } else {
            ChestBuilder.place(world, random, x, y, z, ChestBuilder.getRogueChestByHeight(y));
        }
        if (type != "normal") {
            if (type == "mine") {
                if (world.func_147445_c(x, y - 2, z, false)) {
                    Mine.item.place(world, random, x, y - 1, z);
                }
            } else if (type == "indie") {
                byte dir = (byte)random.nextInt(4);
                int i = 4;
                while (true) {
                    int n = i;
                    i = (byte)(i - 1);
                    if (n <= 0 || this.indieTrapChest(world, random, x, y, z, dir)) break;
                    dir = (byte)Direction.field_71577_f[dir];
                }
            }
        }
    }

    private void trapChest(World world, Random random, int x, int y, int z) {
        byte[] nextDir = new byte[]{4, 0, 1, 2, 3};
        byte dir = (byte)random.nextInt(5);
        --y;
        int d = 5;
        while (true) {
            int n = d;
            d = (byte)(d - 1);
            if (n <= 0) break;
            int X = x;
            int Y = y;
            int Z = z;
            if (dir == 4) {
                --Y;
            } else {
                X += Direction.field_71583_a[dir];
                Z += Direction.field_71581_b[dir];
            }
            if (this.canPlaceTNT(world, X, Y, Z)) {
                byte[] byArray;
                world.func_147465_d(X, Y, Z, Blocks.field_150335_W, 0, 2);
                if (dir == 4) {
                    byte[] byArray2 = new byte[5];
                    byArray2[0] = 4;
                    byArray2[1] = 0;
                    byArray2[2] = 1;
                    byArray2[3] = 2;
                    byArray = byArray2;
                    byArray2[4] = 3;
                } else {
                    byte[] byArray3 = new byte[4];
                    byArray3[0] = 3;
                    byArray3[1] = 0;
                    byArray3[2] = 1;
                    byArray = byArray3;
                    byArray3[3] = 2;
                }
                byte[] nextOffDir = byArray;
                byte offDir = (byte)random.nextInt(nextOffDir.length);
                byte i = (byte)nextOffDir.length;
                while (true) {
                    byte by = i;
                    i = (byte)(i - 1);
                    if (by <= 0) break;
                    int xi = X;
                    int yi = Y;
                    int zi = Z;
                    if (offDir == 4 || dir == Direction.field_71580_e[offDir]) {
                        --Y;
                    } else {
                        X += Direction.field_71583_a[offDir];
                        Z += Direction.field_71581_b[offDir];
                    }
                    if (this.canPlaceTNT(world, X, Y, Z)) {
                        world.func_147465_d(X, Y, Z, Blocks.field_150335_W, 0, 2);
                        if (random.nextInt(3) != 0) {
                            this.hideTNTnearChest(world, random, x, y, z);
                            return;
                        }
                        offDir = (byte)random.nextInt(nextOffDir.length);
                    }
                    offDir = nextOffDir[offDir];
                }
            }
            dir = nextDir[dir];
        }
    }

    private boolean indieTrapChest(World world, Random random, int x, int y, int z, byte dir) {
        if (!this.canPlaceTNT(world, x += Direction.field_71583_a[dir] << 1, y, z += Direction.field_71581_b[dir] << 1) || world.func_147439_a(x, y, z).hasTileEntity(world.func_72805_g(x, y, z)) || !this.canPlaceTNT(world, x += Direction.field_71583_a[dir], y, z += Direction.field_71581_b[dir])) {
            return false;
        }
        dir = (byte)Direction.field_71580_e[dir];
        byte[] nextDir = new byte[]{4, 0, 1, 2, 3};
        byte offDir = (byte)random.nextInt(5);
        int d = 5;
        while (true) {
            int n = d;
            d = (byte)(d - 1);
            if (n <= 0) break;
            int X = x;
            int Y = y;
            int Z = z;
            if (offDir == 4) {
                --Y;
            } else if (offDir == dir) {
                ++Y;
            } else {
                X += Direction.field_71583_a[offDir];
                Z += Direction.field_71581_b[offDir];
            }
            if (this.canPlaceTNT(world, X, Y, Z)) {
                world.func_147465_d(X, Y, Z, Blocks.field_150335_W, 0, 2);
                world.func_147465_d(x, y, z, Blocks.field_150335_W, 0, 2);
                world.func_147465_d(x + Direction.field_71583_a[dir], y, z + Direction.field_71581_b[dir], (Block)Blocks.field_150441_bU, (int)dir, 2);
                this.hideTNTnearChest(world, random, x + 3 * Direction.field_71583_a[dir], y, z + 3 * Direction.field_71581_b[dir]);
                return true;
            }
            offDir = nextDir[offDir];
        }
        return false;
    }

    private void hideTNTnearChest(World world, Random random, int x, int y, int z) {
        int i = 4;
        while (true) {
            int Z;
            int Y;
            int n = i;
            i = (byte)(i - 1);
            if (n <= 0) break;
            int X = x + (random.nextInt(3) - 1 << 1);
            if (!world.func_147445_c(X, Y = y + (Math.min(1, random.nextInt(3)) << 1), Z = z + (random.nextInt(3) - 1 << 1), false) || !this.canPlaceTNT(world, X, Y, Z)) continue;
            world.func_147465_d(X, Y, Z, Blocks.field_150335_W, 0, 2);
        }
    }

    private boolean canPlaceTNT(World world, int x, int y, int z) {
        return world.func_147445_c(x - 1, y, z, false) && world.func_147445_c(x + 1, y, z, false) && world.func_147445_c(x, y - 1, z, false) && world.func_147445_c(x, y + 1, z, false) && world.func_147445_c(x, y, z - 1, false) && world.func_147445_c(x, y, z + 1, false);
    }
}

