/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import toast.deadlyWorld.feature.Mine;
import toast.deadlyWorld.feature.SpawnerItem;
import toast.deadlyWorld.feature.WorldFeature;
import toast.deadlyWorld.feature.WorldFeatureItem;
import toast.deadlyWorld.feature.WorldGenerator;

public class PotionTrap
implements WorldFeature {
    public static final WorldFeatureItem[] items = SpawnerItem.buildItems("potion");
    public static final int totalWeight = WorldGenerator.getTotalWeight(items);
    public final double frequency;

    public PotionTrap(double freq) {
        this.frequency = freq;
    }

    @Override
    public void generate(World world, Random random, int x, int z) {
        if (this.frequency <= random.nextDouble()) {
            return;
        }
        x += random.nextInt(16);
        z += random.nextInt(16);
        int state = 0;
        for (int y = random.nextInt(50) + 11; y > 5; --y) {
            if (world.func_147445_c(x, y, z, true)) {
                if (state != 0) continue;
                if (this.canBePlaced(world, random, x, y, z)) {
                    this.place(world, random, x, y, z);
                    return;
                }
                state = -1;
                continue;
            }
            state = 0;
        }
    }

    @Override
    public boolean canBePlaced(World world, Random random, int x, int y, int z) {
        if (world.func_147437_c(x - 1, y, z) || world.func_147437_c(x + 1, y, z) || world.func_147437_c(x, y, z - 1) || world.func_147437_c(x, y, z + 1)) {
            --y;
        }
        if (!(world.func_147445_c(x - 1, y, z, false) && world.func_147445_c(x + 1, y, z, false) && world.func_147445_c(x, y, z - 1, false) && world.func_147445_c(x, y, z + 1, false))) {
            return false;
        }
        return world.func_147437_c(x, y + 2, z) && world.func_147445_c(x, y - 1, z, false);
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        if (world.func_147437_c(x - 1, y, z) || world.func_147437_c(x + 1, y, z) || world.func_147437_c(x, y, z - 1) || world.func_147437_c(x, y, z + 1)) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            --y;
        }
        WorldGenerator.choose(random, totalWeight, items).place(world, random, x, y, z);
        Mine.coverTrap(world, random, x, y, z);
    }
}

