/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import toast.deadlyWorld.ChestBuilder;
import toast.deadlyWorld.Properties;
import toast.deadlyWorld._DeadlyWorld;
import toast.deadlyWorld.feature.BrutalSpawner;
import toast.deadlyWorld.feature.SpawnerItem;
import toast.deadlyWorld.feature.SwarmSpawner;
import toast.deadlyWorld.feature.Tower;
import toast.deadlyWorld.feature.WorldFeature;
import toast.deadlyWorld.feature.WorldFeatureItem;
import toast.deadlyWorld.feature.WorldGenerator;

public class DeadlyWorldDungeon
implements WorldFeature {
    public static final WorldFeatureItem[] items = SpawnerItem.buildItems("dungeon");
    public static final int totalWeight = WorldGenerator.getTotalWeight(items);
    public static final int[] featureWeights = WorldGenerator.getWeights("dungeon_types", _DeadlyWorld.DUNGEON_FEATURES);
    public static final int totalFeatureWeight = WorldGenerator.getTotalWeight(featureWeights);
    public static final double armorChance = Properties.getDouble("dungeons", "_armor_chance");
    public static final double silverfishChance = Properties.getDouble("dungeons", "_silverfish_chance");
    public final double placeAttempts;

    public DeadlyWorldDungeon(double count) {
        this.placeAttempts = count;
    }

    @Override
    public void generate(World world, Random random, int x, int z) {
        int chunkX = x;
        int chunkZ = z;
        for (double count = this.placeAttempts; count >= 1.0 || count > 0.0 && count > random.nextDouble(); count -= 1.0) {
            x = chunkX + random.nextInt(16) + 8;
            int y = random.nextInt(128);
            z = chunkZ + random.nextInt(16) + 8;
            this.place(world, random, x, y, z);
        }
    }

    @Override
    public boolean canBePlaced(World world, Random random, int x, int y, int z) {
        return true;
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        int Z;
        int Y;
        int X;
        byte radX = (byte)(random.nextInt(2) + 2);
        int radY = 3;
        byte radZ = (byte)(random.nextInt(2) + 2);
        int exposedBlocks = 0;
        for (X = x - radX - 1; X <= x + radX + 1; ++X) {
            for (Y = y - 1; Y <= y + radY + 1; ++Y) {
                for (Z = z - radZ - 1; Z <= z + radZ + 1; ++Z) {
                    if (!(Y != y - 1 && Y != y + radY + 1 || world.func_147439_a(X, Y, Z).func_149688_o().func_76220_a())) {
                        return;
                    }
                    if (X != x - radX - 1 && X != x + radX + 1 && Z != z - radZ - 1 && Z != z + radZ + 1 || Y != y || !world.func_147437_c(X, Y, Z) || !world.func_147437_c(X, Y + 1, Z)) continue;
                    ++exposedBlocks;
                }
            }
        }
        if (exposedBlocks < 1 || exposedBlocks > 5) {
            return;
        }
        for (X = x - radX - 1; X <= x + radX + 1; ++X) {
            for (Y = y + radY; Y >= y - 1; --Y) {
                for (Z = z - radZ - 1; Z <= z + radZ + 1; ++Z) {
                    if (X != x - radX - 1 && Y != y - 1 && Z != z - radZ - 1 && X != x + radX + 1 && Y != y + radY + 1 && Z != z + radZ + 1) {
                        world.func_147468_f(X, Y, Z);
                        continue;
                    }
                    if (Y >= 0 && !world.func_147439_a(X, Y - 1, Z).func_149688_o().func_76220_a()) {
                        world.func_147468_f(X, Y, Z);
                        continue;
                    }
                    if (!world.func_147439_a(X, Y, Z).func_149688_o().func_76220_a()) continue;
                    if (Y == y - 1 && random.nextInt(4) != 0) {
                        world.func_147465_d(X, Y, Z, Blocks.field_150341_Y, 0, 2);
                        continue;
                    }
                    if (random.nextDouble() < silverfishChance) {
                        world.func_147465_d(X, Y, Z, Blocks.field_150418_aU, 1, 2);
                        continue;
                    }
                    world.func_147465_d(X, Y, Z, Blocks.field_150347_e, 0, 2);
                }
            }
        }
        block6: for (int chestCount = 0; chestCount < 2; chestCount = (int)((byte)(chestCount + 1))) {
            for (int chestAttempts = 0; chestAttempts < 3; chestAttempts = (int)((byte)(chestAttempts + 1))) {
                X = x + random.nextInt(radX * 2 + 1) - radX;
                if (!world.func_147437_c(X, y, Z = z + random.nextInt(radZ * 2 + 1) - radZ)) continue;
                exposedBlocks = 0;
                if (world.func_147439_a(X - 1, y, Z).func_149688_o().func_76220_a()) {
                    ++exposedBlocks;
                }
                if (world.func_147439_a(X + 1, y, Z).func_149688_o().func_76220_a()) {
                    ++exposedBlocks;
                }
                if (world.func_147439_a(X, y, Z - 1).func_149688_o().func_76220_a()) {
                    ++exposedBlocks;
                }
                if (world.func_147439_a(X, y, Z + 1).func_149688_o().func_76220_a()) {
                    ++exposedBlocks;
                }
                if (exposedBlocks != 1) continue;
                ChestBuilder.place(world, random, X, y, Z, "dungeonChest");
                continue block6;
            }
        }
        String type = WorldGenerator.choose(random, totalFeatureWeight, _DeadlyWorld.DUNGEON_FEATURES, featureWeights);
        if (type == "spawner") {
            if (random.nextDouble() < armorChance) {
                world.func_147465_d(x - 1, y, z, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x + 1, y, z, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x, y - 1, z, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x, y + 1, z, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x, y, z - 1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x, y, z + 1, Blocks.field_150343_Z, 0, 2);
            }
            WorldGenerator.choose(random, totalWeight, items).place(world, random, x, y, z);
        } else if (type == "tower") {
            Tower.placeTower(world, random, x, y + 1, z);
            if (world.func_147439_a(x, y, z) == Blocks.field_150347_e && random.nextDouble() < silverfishChance) {
                world.func_147465_d(x, y, z, Blocks.field_150418_aU, 1, 2);
            }
        } else if (type == "brutal_spawner") {
            new BrutalSpawner(0.0).place(world, random, x, y, z);
        } else if (type == "swarm_spawner") {
            new SwarmSpawner(0.0).place(world, random, x, y, z);
        } else {
            _DeadlyWorld.console("Error choosing dungeon type! Unknown type: " + (type == null ? "null" : type));
        }
    }
}

