/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.world.World;
import toast.deadlyWorld.Properties;
import toast.deadlyWorld.TagBuilder;
import toast.deadlyWorld._DeadlyWorld;
import toast.deadlyWorld.feature.SpawnerItem;
import toast.deadlyWorld.feature.WorldFeature;
import toast.deadlyWorld.feature.WorldFeatureItem;
import toast.deadlyWorld.feature.WorldGenerator;

public class CaveIn
implements WorldFeature {
    public static final WorldFeatureItem[] items = CaveIn.buildItems();
    public static final int totalWeight = WorldGenerator.getTotalWeight(items);
    public final double frequency;

    public CaveIn(double freq) {
        this.frequency = freq;
    }

    @Override
    public void generate(World world, Random random, int x, int z) {
        if (this.frequency <= random.nextDouble()) {
            return;
        }
        x += random.nextInt(16);
        z += random.nextInt(16);
        int state = 0;
        for (int y = random.nextInt(30) + 11; y < 54; ++y) {
            if (world.func_147445_c(x, y, z, true)) {
                if (state != 0) continue;
                if (this.canBePlaced(world, random, x, y, z)) {
                    this.place(world, random, x, y, z);
                    return;
                }
                state = -1;
                continue;
            }
            if (!world.func_147437_c(x, y, z)) continue;
            state = 0;
        }
    }

    @Override
    public boolean canBePlaced(World world, Random random, int x, int y, int z) {
        return world.func_147437_c(x, y - 1, z) && world.func_147445_c(x, y + 2, z, false);
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        WorldGenerator.choose(random, totalWeight, items).place(world, random, x, y + 1, z);
    }

    private static WorldFeatureItem[] buildItems() {
        int length = _DeadlyWorld.CAVE_INS.length;
        WorldFeatureItem[] items = new WorldFeatureItem[length];
        int i = length;
        while (i-- > 0) {
            items[i] = new SpawnerItem(TagBuilder.createCaveInSpawner(_DeadlyWorld.CAVE_INS[i]), Properties.getInt("cave_ins", _DeadlyWorld.CAVE_INS[i].toLowerCase()), true, false);
        }
        return items;
    }
}

