/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import toast.deadlyWorld.ChestBuilder;
import toast.deadlyWorld.Properties;
import toast.deadlyWorld.TagBuilder;
import toast.deadlyWorld.feature.SpawnerItem;
import toast.deadlyWorld.feature.WorldFeature;
import toast.deadlyWorld.feature.WorldFeatureItem;
import toast.deadlyWorld.feature.WorldGenerator;

public class BrutalSpawner
implements WorldFeature {
    public static final NBTTagCompound BASE_TAG = new NBTTagCompound();
    public static final WorldFeatureItem[] items;
    public static final int totalWeight;
    public final double frequency;

    public BrutalSpawner(double freq) {
        this.frequency = freq;
    }

    @Override
    public void generate(World world, Random random, int x, int z) {
        if (this.frequency <= random.nextDouble()) {
            return;
        }
        x += random.nextInt(16);
        z += random.nextInt(16);
        int state = 0;
        for (int y = random.nextInt(40) + 11; y > 4; --y) {
            if (world.func_147445_c(x, y, z, true)) {
                if (state != 0) continue;
                if (this.canBePlaced(world, random, x, y + 1, z)) {
                    this.place(world, random, x, y + 1, z);
                    return;
                }
                state = -1;
                continue;
            }
            state = 0;
        }
    }

    @Override
    public boolean canBePlaced(World world, Random random, int x, int y, int z) {
        return world.func_147437_c(x, y, z) && world.func_147437_c(x, y + 1, z);
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        ChestBuilder.place(world, random, x, y - 1, z, "DeadlyWorld.spawnerChestBrutal");
        WorldGenerator.choose(random, totalWeight, items).place(world, random, x, y, z);
        world.func_147465_d(x, y + 1, z, Blocks.field_150417_aV, 3, 2);
        for (int y1 = 0; y1 < 2; ++y1) {
            if (random.nextInt(4) == 0 && world.func_147437_c(x - 1, y + y1, z)) {
                world.func_147465_d(x - 1, y + y1, z, Blocks.field_150395_bd, 8, 2);
            }
            if (random.nextInt(4) == 0 && world.func_147437_c(x + 1, y + y1, z)) {
                world.func_147465_d(x + 1, y + y1, z, Blocks.field_150395_bd, 2, 2);
            }
            if (random.nextInt(4) == 0 && world.func_147437_c(x, y + y1, z - 1)) {
                world.func_147465_d(x, y + y1, z - 1, Blocks.field_150395_bd, 1, 2);
            }
            if (random.nextInt(4) != 0 || !world.func_147437_c(x, y + y1, z + 1)) continue;
            world.func_147465_d(x, y + y1, z + 1, Blocks.field_150395_bd, 4, 2);
        }
    }

    static {
        Potion[] potions = new Potion[]{Potion.field_76426_n, Potion.field_76428_l, Potion.field_76429_m, Potion.field_76420_g, Potion.field_76424_c, Potion.field_76427_o};
        int[] amplifiers = new int[]{Properties.getBoolean("brutal_mobs", "_fire_resistance") ? 0 : -1, Properties.getInt("brutal_mobs", "_regeneration"), Properties.getInt("brutal_mobs", "_resistance"), Properties.getInt("brutal_mobs", "_strength"), Properties.getInt("brutal_mobs", "_swiftness"), Properties.getBoolean("brutal_mobs", "_water_breathing") ? 0 : -1};
        int i = potions.length;
        while (i-- > 0) {
            if (amplifiers[i] < 0) continue;
            TagBuilder.addPotionEffect(BASE_TAG, potions[i], amplifiers[i]);
        }
        items = SpawnerItem.buildItems("spawner_brutal");
        totalWeight = WorldGenerator.getTotalWeight(items);
    }
}

