/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import toast.deadlyWorld.AttributeHelper;
import toast.deadlyWorld.NameHelper;
import toast.deadlyWorld.Properties;
import toast.deadlyWorld.TagBuilder;
import toast.deadlyWorld.feature.WorldFeatureItem;

public class BossItem
implements WorldFeatureItem {
    public static final Potion[] potions = new Potion[]{Potion.field_76424_c, Potion.field_76420_g, Potion.field_76429_m, Potion.field_76426_n, Potion.field_76427_o, Potion.field_76434_w, Potion.field_76444_x};
    public static final Enchantment[][] enchantments = new Enchantment[][]{{Enchantment.field_77335_o, Enchantment.field_77347_r, Enchantment.field_77345_t, Enchantment.field_77344_u, Enchantment.field_77343_v, Enchantment.field_77342_w}, {Enchantment.field_77338_j, Enchantment.field_77339_k, Enchantment.field_77336_l, Enchantment.field_77337_m, Enchantment.field_77334_n, Enchantment.field_77335_o, Enchantment.field_77349_p, Enchantment.field_77348_q, Enchantment.field_77347_r, Enchantment.field_77346_s}, {Enchantment.field_77332_c, Enchantment.field_77329_d, Enchantment.field_77330_e, Enchantment.field_77327_f, Enchantment.field_77328_g, Enchantment.field_77340_h, Enchantment.field_77341_i, Enchantment.field_92091_k, Enchantment.field_77347_r}};
    public static final int REGEN = Properties.getInt("bosses", "regeneration");
    public static final int RESISTANCE = Properties.getInt("bosses", "resistance");
    public static final boolean FIRE_RESISTANCE = Properties.getBoolean("bosses", "fire_resistance");
    public static final boolean WATER_BREATHING = Properties.getBoolean("bosses", "water_breathing");
    public static final double HEALTH_MULT = Properties.getDouble("bosses", "health_multiplier");
    public static final double KNOCK_RESIST = Properties.getDouble("bosses", "knockback_resistance");
    public static final double SPEED_MULT = Properties.getDouble("bosses", "speed_multiplier");
    public static final double ATTACK_BONUS = Properties.getDouble("bosses", "damage_bonus");
    public static final double LEVEL_UP = Properties.getDouble("bosses", "level_up_chance");
    public static final double EQUIP_CHANCE = Properties.getDouble("bosses", "equip_chance");
    public static final double ENCHANT_CHANCE = Properties.getDouble("bosses", "enchantment_chance");
    public static final double EFFECT_CHANCE = Properties.getDouble("bosses", "effect_chance");
    public final Class entityClass;
    private final int weight;
    public final byte type;

    public BossItem(String name, int wt) {
        this.entityClass = (Class)EntityList.field_75625_b.get(name);
        this.weight = wt;
        this.type = (byte)(this.entityClass.equals(EntitySpider.class) ? 1 : (this.entityClass.equals(EntityCaveSpider.class) ? 0 : -1));
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        EntityLiving entity = null;
        try {
            entity = (EntityLiving)this.entityClass.getConstructor(World.class).newInstance(world);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (entity != null) {
            this.initBoss(random, entity);
            entity.func_70080_a((double)x + (this.type == 1 ? 1.0 : 0.5), (double)y, (double)z + (this.type == 1 ? 1.0 : 0.5), random.nextFloat() * 360.0f, 0.0f);
            world.func_72838_d((Entity)entity);
        }
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public void initBoss(Random random, EntityLiving entity) {
        int i;
        int slot;
        ItemStack[] equipment;
        block22: {
            NBTTagCompound enchTag;
            if (REGEN >= 0) {
                NBTTagCompound tag = new NBTTagCompound();
                entity.func_70109_d(tag);
                TagBuilder.addPotionEffect(tag, Potion.field_76428_l, REGEN, true);
                entity.func_70020_e(tag);
            }
            if (RESISTANCE >= 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, Integer.MAX_VALUE, RESISTANCE, true));
            }
            if (FIRE_RESISTANCE) {
                entity.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, Integer.MAX_VALUE, 0, true));
            }
            if (WATER_BREATHING) {
                entity.func_70690_d(new PotionEffect(Potion.field_76427_o.field_76415_H, Integer.MAX_VALUE, 0, true));
            }
            AttributeHelper.shift((EntityLivingBase)entity, SharedMonsterAttributes.field_111264_e, "DW|BossDamageBonus", ATTACK_BONUS);
            AttributeHelper.baseMult((EntityLivingBase)entity, SharedMonsterAttributes.field_111267_a, "DW|BossHealthMult", HEALTH_MULT - 1.0);
            AttributeHelper.max((EntityLivingBase)entity, SharedMonsterAttributes.field_111266_c, "DW|BossKnockbackResist", KNOCK_RESIST);
            AttributeHelper.baseMult((EntityLivingBase)entity, SharedMonsterAttributes.field_111263_d, "DW|BossSpeedMult", SPEED_MULT - 1.0);
            entity.func_70606_j(entity.func_110138_aP());
            String name = NameHelper.setEntityName(random, entity);
            entity.func_110163_bv();
            int level = 0;
            int i2 = 3;
            while (i2-- > 0) {
                if (!(random.nextDouble() < LEVEL_UP)) continue;
                ++level;
            }
            equipment = new ItemStack[5];
            switch (level) {
                case 1: {
                    equipment = new ItemStack[]{new ItemStack(Items.field_151010_B), new ItemStack((Item)Items.field_151151_aj), new ItemStack((Item)Items.field_151149_ai), new ItemStack((Item)Items.field_151171_ah), new ItemStack((Item)Items.field_151169_ag)};
                    break;
                }
                case 2: {
                    equipment = new ItemStack[]{new ItemStack(Items.field_151040_l), new ItemStack((Item)Items.field_151167_ab), new ItemStack((Item)Items.field_151165_aa), new ItemStack((Item)Items.field_151030_Z), new ItemStack((Item)Items.field_151028_Y)};
                    break;
                }
                case 3: {
                    equipment = new ItemStack[]{new ItemStack(Items.field_151048_u), new ItemStack((Item)Items.field_151175_af), new ItemStack((Item)Items.field_151173_ae), new ItemStack((Item)Items.field_151163_ad), new ItemStack((Item)Items.field_151161_ac)};
                    break;
                }
                default: {
                    equipment = new ItemStack[]{new ItemStack(Items.field_151052_q), new ItemStack((Item)Items.field_151029_X), new ItemStack((Item)Items.field_151022_W), new ItemStack((Item)Items.field_151023_V), new ItemStack((Item)Items.field_151020_U)};
                }
            }
            if (random.nextInt(2) == 0) {
                ItemStack[] tools;
                switch (level) {
                    case 1: {
                        tools = new ItemStack[]{new ItemStack(Items.field_151006_E), new ItemStack(Items.field_151005_D), new ItemStack(Items.field_151011_C)};
                        break;
                    }
                    case 2: {
                        tools = new ItemStack[]{new ItemStack(Items.field_151036_c), new ItemStack(Items.field_151035_b), new ItemStack(Items.field_151037_a)};
                        break;
                    }
                    case 3: {
                        tools = new ItemStack[]{new ItemStack(Items.field_151056_x), new ItemStack(Items.field_151046_w), new ItemStack(Items.field_151047_v)};
                        break;
                    }
                    default: {
                        tools = new ItemStack[]{new ItemStack(Items.field_151049_t), new ItemStack(Items.field_151050_s), new ItemStack(Items.field_151051_r)};
                    }
                }
                equipment[0] = tools[random.nextInt(tools.length)];
            }
            if (entity instanceof EntitySkeleton) {
                equipment[0] = new ItemStack((Item)Items.field_151031_f);
            }
            slot = random.nextInt(2) == 0 ? random.nextInt(4) + 1 : 0;
            entity.func_96120_a(slot, 2.0f);
            int type = equipment[slot].func_77973_b() instanceof ItemArmor ? 2 : (equipment[slot].func_77973_b() instanceof ItemBow ? 0 : 1);
            Enchantment enchantment = enchantments[type][random.nextInt(enchantments[type].length)];
            NameHelper.setItemName(random, equipment[slot], name, enchantment);
            EnchantmentHelper.func_77504_a((Random)random, (ItemStack)equipment[slot], (int)30);
            if (!equipment[slot].field_77990_d.func_74764_b("ench")) {
                equipment[slot].field_77990_d.func_74782_a("ench", (NBTBase)new NBTTagList());
            }
            NBTTagList enchList = equipment[slot].func_77986_q();
            i = enchList.func_74745_c();
            while (i-- > 0) {
                enchTag = enchList.func_150305_b(i);
                if (enchTag.func_74765_d("id") != enchantment.field_77352_x) continue;
                enchTag.func_74777_a("lvl", (short)((byte)enchantment.func_77325_b()));
                break block22;
            }
            enchTag = new NBTTagCompound();
            enchTag.func_74777_a("id", (short)enchantment.field_77352_x);
            enchTag.func_74777_a("lvl", (short)((byte)enchantment.func_77325_b()));
            enchList.func_74742_a((NBTBase)enchTag);
        }
        entity.func_70062_b(slot, equipment[slot]);
        i = 5;
        while (i-- > 0) {
            if (i == slot || !(random.nextDouble() < EQUIP_CHANCE) && !(equipment[i].func_77973_b() instanceof ItemBow)) continue;
            if (random.nextDouble() < ENCHANT_CHANCE) {
                EnchantmentHelper.func_77504_a((Random)random, (ItemStack)equipment[i], (int)(5 + random.nextInt(11)));
            }
            entity.func_70062_b(i, equipment[i]);
        }
        if (random.nextDouble() < EFFECT_CHANCE) {
            entity.func_70690_d(new PotionEffect(BossItem.potions[random.nextInt((int)BossItem.potions.length)].field_76415_H, Integer.MAX_VALUE, 1));
        }
    }
}

