/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld;

import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;

public class SpawnBuilder {
    public Random random;
    public TileEntityMobSpawner mobSpawner;
    public NBTTagCompound spawnerTag;
    public boolean isValid;

    public SpawnBuilder(World world, Random rand, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityMobSpawner) {
            this.random = rand;
            this.mobSpawner = (TileEntityMobSpawner)tileEntity;
            this.spawnerTag = new NBTTagCompound();
            this.mobSpawner.func_145841_b(this.spawnerTag);
            this.isValid = true;
        }
    }

    public SpawnBuilder(TileEntityMobSpawner tileEntity, Random rand) {
        this.mobSpawner = tileEntity;
        if (this.mobSpawner != null) {
            this.random = rand;
            this.spawnerTag = new NBTTagCompound();
            this.mobSpawner.func_145841_b(this.spawnerTag);
            this.isValid = true;
        }
    }

    public void write() {
        this.mobSpawner.func_145839_a(this.spawnerTag);
        this.mobSpawner.func_145831_w().func_147471_g(this.mobSpawner.field_145851_c, this.mobSpawner.field_145848_d, this.mobSpawner.field_145849_e);
    }

    public void setType(String type) {
        this.spawnerTag.func_74778_a("EntityId", type);
    }

    public void setDelay(int delay) {
        this.spawnerTag.func_74777_a("Delay", (short)delay);
    }

    public void setMinDelay(int min) {
        this.spawnerTag.func_74777_a("MinSpawnDelay", (short)min);
    }

    public void setMaxDelay(int max) {
        this.spawnerTag.func_74777_a("MaxSpawnDelay", (short)max);
    }

    public void setMinAndMaxDelay(int min, int max) {
        this.setMinDelay(min);
        this.setMaxDelay(max);
    }

    public void setSpawnCount(int count) {
        this.spawnerTag.func_74777_a("SpawnCount", (short)count);
    }

    public void setMaxNearbyEntities(int max) {
        this.spawnerTag.func_74777_a("MaxNearbyEntities", (short)max);
    }

    public void setPlayerRange(int range) {
        this.spawnerTag.func_74777_a("RequiredPlayerRange", (short)range);
    }

    public void setSpawnRange(int range) {
        this.spawnerTag.func_74777_a("SpawnRange", (short)range);
    }

    public void setSpawnData(NBTTagCompound data) {
        if (data == null) {
            this.spawnerTag.func_82580_o("SpawnData");
            return;
        }
        this.spawnerTag.func_74782_a("SpawnData", data.func_74737_b());
    }

    public void setPotentials(String[] types, int[] weights, NBTTagCompound[] properties) {
        if (types == null) {
            this.spawnerTag.func_82580_o("SpawnPotentials");
            return;
        }
        int length = types.length;
        if (length == 0 || length != weights.length || length != properties.length) {
            this.spawnerTag.func_82580_o("SpawnPotentials");
            return;
        }
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < length; ++i) {
            NBTTagCompound entry = new NBTTagCompound();
            entry.func_74778_a("Type", types[i]);
            entry.func_74768_a("Weight", weights[i]);
            entry.func_74782_a("Properties", properties[i].func_74737_b());
            tagList.func_74742_a((NBTBase)entry);
        }
        this.spawnerTag.func_74782_a("SpawnPotentials", (NBTBase)tagList);
    }
}

