/*
 * Decompiled with CFR 0.152.
 */
package climateControl.utils;

import climateControl.utils.IntStreamer;
import climateControl.utils.Streamer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;

public class Numbered<Type> {
    private int count;
    private Type item;

    public Numbered(int _count, Type _item) {
        this.count = _count;
        this.item = _item;
    }

    public int count() {
        return this.count;
    }

    public Type item() {
        return this.item;
    }

    public static <T> Numbered<T> from(int count, T object) {
        return new Numbered<T>(count, object);
    }

    public static <StreamType> Streamer<Numbered<StreamType>> streamer(final Streamer<StreamType> substreamer) {
        return new Streamer<Numbered<StreamType>>(){
            IntStreamer numberStreamer = new IntStreamer();

            @Override
            public Numbered<StreamType> readFrom(DataInput input) throws IOException {
                Integer number = this.numberStreamer.readFrom(input);
                return new Numbered(number, substreamer.readFrom(input));
            }

            @Override
            public void writeTo(Numbered<StreamType> written, DataOutput output) throws IOException {
                this.numberStreamer.writeTo(written.count, output);
                substreamer.writeTo(written.item, output);
            }
        };
    }

    public static Comparator<Numbered> comparator() {
        return new Comparator<Numbered>(){

            @Override
            public int compare(Numbered arg0, Numbered arg1) {
                return arg0.count - arg1.count;
            }
        };
    }

    public static <ItemType> Comparator<Numbered<ItemType>> comparator(final Comparator<ItemType> subComparator) {
        return new Comparator<Numbered<ItemType>>(){

            @Override
            public int compare(Numbered<ItemType> arg0, Numbered<ItemType> arg1) {
                int result = arg0.count - arg1.count;
                if (result == 0) {
                    return subComparator.compare(arg0.item, arg1.item);
                }
                return result;
            }
        };
    }
}

