/*
 * Decompiled with CFR 0.152.
 */
package climateControl.utils;

import climateControl.utils.Direction;

public class Compass {
    private Direction[] directions = new Direction[8];

    public Compass() {
        this.directions[0] = Direction.UP;
        this.directions[1] = Direction.UP_RIGHT;
        this.directions[2] = Direction.RIGHT;
        this.directions[3] = Direction.DOWN_RIGHT;
        this.directions[4] = Direction.DOWN;
        this.directions[5] = Direction.DOWN_LEFT;
        this.directions[6] = Direction.LEFT;
        this.directions[7] = Direction.UP_LEFT;
    }

    public Direction direction(int index) {
        return this.directions[index];
    }

    public int index(Direction compassDirection) {
        for (int i = 0; i < 8; ++i) {
            if (!this.directions[i].equals(compassDirection)) continue;
            return i;
        }
        throw new RuntimeException("nonexistent compass direction");
    }

    public Direction clockwise(Direction start) {
        int result = this.index(start) + 1;
        return this.directions[result % 8];
    }

    public Direction counterClockwise(Direction start) {
        int result = this.index(start) + 7;
        return this.directions[result % 8];
    }
}

