/*
 * Decompiled with CFR 0.152.
 */
package climateControl.utils;

import climateControl.utils.Zeno410Logger;
import java.lang.reflect.Field;
import java.util.logging.Logger;
import net.minecraft.launchwrapper.Launch;

public class Accessor<ObjectType, FieldType> {
    public static final Logger logger = new Zeno410Logger("Accessor").logger();
    private Field field;
    private final String fieldName;
    static final boolean isDevEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");

    public Accessor(String _fieldName, String _deobfName) {
        this.fieldName = isDevEnv ? _deobfName : _fieldName;
    }

    private Field field(ObjectType example) {
        Class<?> classObject = example.getClass();
        if (this.field == null) {
            try {
                this.setField(classObject);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return this.field;
    }

    private void setField(Class classObject) throws IllegalAccessException {
        do {
            Field[] fields = classObject.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().contains(this.fieldName)) continue;
                this.field = fields[i];
                this.field.setAccessible(true);
                return;
            }
        } while ((classObject = classObject.getSuperclass()) != Object.class);
        logger.info(this.fieldName + " not found in class " + classObject.getName());
        throw new RuntimeException(this.fieldName + " not found in class " + classObject.getName());
    }

    public FieldType get(ObjectType object) {
        try {
            return (FieldType)this.field(object).get(object);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setField(ObjectType object, FieldType fieldValue) {
        try {
            logger.info(" setting to ");
            logger.info(fieldValue.toString());
            this.field(object).set(object, fieldValue);
            logger.info("set");
        }
        catch (IllegalArgumentException ex) {
            logger.info("illegal argument");
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            logger.info("illegal access");
            throw new RuntimeException(ex);
        }
    }
}

