/*
 * Decompiled with CFR 0.152.
 */
package climateControl.utils;

import java.lang.reflect.Field;
import net.minecraft.launchwrapper.Launch;

public class AccessLong<ObjectType> {
    private Field field;
    private final String fieldName;
    static final boolean isDevEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");

    private AccessLong(String _fieldName) {
        this.fieldName = _fieldName;
    }

    public AccessLong(String _fieldName, String _deobfName) {
        this(isDevEnv ? _deobfName : _fieldName);
    }

    private Field field(ObjectType example) {
        Class<?> classObject = example.getClass();
        if (this.field == null) {
            try {
                this.setField(classObject);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return this.field;
    }

    private void setField(Class classObject) throws IllegalAccessException {
        do {
            Field[] fields = classObject.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().contains(this.fieldName)) continue;
                this.field = fields[i];
                this.field.setAccessible(true);
                return;
            }
        } while ((classObject = classObject.getSuperclass()) != Object.class);
        throw new RuntimeException(this.fieldName + " not found in class " + classObject.getName());
    }

    public long get(ObjectType object) {
        try {
            return this.field(object).getLong(object);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setField(ObjectType object, long fieldValue) {
        try {
            this.field(object).setLong(object, fieldValue);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }
}

