/*
 * Decompiled with CFR 0.152.
 */
package climateControl.generator;

import climateControl.api.DistributionPartitioner;
import climateControl.api.IncidenceModifier;
import climateControl.customGenLayer.GenLayerConstant;
import climateControl.customGenLayer.GenLayerLandReport;
import climateControl.customGenLayer.GenLayerLimitedCache;
import climateControl.customGenLayer.GenLayerMountainChains;
import climateControl.genLayerPack.GenLayerRiverInit;
import climateControl.genLayerPack.GenLayerSmooth;
import climateControl.genLayerPack.GenLayerZoom;
import climateControl.utils.Numbered;
import climateControl.utils.StringWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraftforge.common.BiomeDictionary;

public class MountainFormer
extends DistributionPartitioner {
    private GenLayer mountainGens;
    private final boolean mesaMountains;

    public MountainFormer(boolean mesaMountains) {
        super(MountainFormer.incidenceModifiers(mesaMountains));
        this.mesaMountains = mesaMountains;
        this.mountainGens = this.mountainGenLayers();
    }

    @Override
    public void initWorldGenSeed(long par1) {
        this.mountainGens.func_75905_a(par1);
    }

    @Override
    protected IncidenceModifier modifier(int x, int z) {
        int index = this.mountainGens.func_75904_a(x, z, 1, 1)[0];
        return this.modifiers.get(index);
    }

    private GenLayer mountainGenLayers() {
        GenLayer result = new GenLayerConstant(1L, 1);
        result = new GenLayerRiverInit(3001L, result);
        for (int i = 0; i < 3; ++i) {
            result = new GenLayerZoom(3001L + (long)i, result);
            result = new GenLayerSmooth(3001L + (long)i, result);
        }
        result = new GenLayerMountainChains(3005L, result);
        result = new GenLayerLimitedCache(result, 64);
        return result;
    }

    GenLayer reportOn(GenLayer reportedOn, String fileName) {
        try {
            StringWriter target = new StringWriter(new File(fileName));
            reportedOn = new GenLayerLandReport(reportedOn, 40, target);
            return reportedOn;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static ArrayList<IncidenceModifier> incidenceModifiers(boolean mesaMountains) {
        ArrayList<IncidenceModifier> result = new ArrayList<IncidenceModifier>();
        result.add(new LowlandModifier(mesaMountains));
        result.add(new MountainModifier(mesaMountains));
        return result;
    }

    private static class LowlandModifier
    implements IncidenceModifier {
        private final boolean mesaMountains;

        LowlandModifier(boolean mesaMountains) {
            this.mesaMountains = mesaMountains;
        }

        @Override
        public int modifiedIncidence(Numbered<BiomeGenBase> biomeIncidence) {
            BiomeGenBase biome = biomeIncidence.item();
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
                return 0;
            }
            if (biomeIncidence.item().field_76756_M == BiomeGenBase.field_76770_e.field_76756_M) {
                return 0;
            }
            if (this.mesaMountains && (biomeIncidence.item().equals(BiomeGenBase.field_150608_ab) || biomeIncidence.item().equals(BiomeGenBase.field_150607_aa))) {
                return 0;
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
                return biomeIncidence.count();
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                return biomeIncidence.count();
            }
            return biomeIncidence.count() * 4 / 3;
        }
    }

    private static class MountainModifier
    implements IncidenceModifier {
        private final boolean mesaMountains;

        MountainModifier(boolean mesaMountains) {
            this.mesaMountains = mesaMountains;
        }

        @Override
        public int modifiedIncidence(Numbered<BiomeGenBase> biomeIncidence) {
            BiomeGenBase biome = biomeIncidence.item();
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
                return biomeIncidence.count() * 4;
            }
            if (biomeIncidence.item().field_76756_M == BiomeGenBase.field_76770_e.field_76756_M) {
                return biomeIncidence.count() * 4;
            }
            if (this.mesaMountains && (biomeIncidence.item().equals(BiomeGenBase.field_150608_ab) || biomeIncidence.item().equals(BiomeGenBase.field_150607_aa))) {
                return biomeIncidence.count() * 4;
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
                return biomeIncidence.count();
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                return biomeIncidence.count();
            }
            return 0;
        }
    }
}

