/*
 * Decompiled with CFR 0.152.
 */
package climateControl.generator;

import climateControl.ClimateChooser;
import climateControl.api.ClimateControlSettings;
import climateControl.api.IslandClimateMaker;
import climateControl.customGenLayer.ConfirmBiome;
import climateControl.customGenLayer.GenLayerAddBiome;
import climateControl.customGenLayer.GenLayerAdjustIsland;
import climateControl.customGenLayer.GenLayerBandedClimate;
import climateControl.customGenLayer.GenLayerBiomeByTaggedClimate;
import climateControl.customGenLayer.GenLayerBreakMergers;
import climateControl.customGenLayer.GenLayerConfirm;
import climateControl.customGenLayer.GenLayerConstant;
import climateControl.customGenLayer.GenLayerContinentalShelf;
import climateControl.customGenLayer.GenLayerForceStartLand;
import climateControl.customGenLayer.GenLayerIdentifiedClimate;
import climateControl.customGenLayer.GenLayerLandReport;
import climateControl.customGenLayer.GenLayerLessRiver;
import climateControl.customGenLayer.GenLayerLimitedCache;
import climateControl.customGenLayer.GenLayerLowlandRiverMix;
import climateControl.customGenLayer.GenLayerOceanicIslands;
import climateControl.customGenLayer.GenLayerOceanicMushroomIsland;
import climateControl.customGenLayer.GenLayerPrettyShore;
import climateControl.customGenLayer.GenLayerRandomBiomes;
import climateControl.customGenLayer.GenLayerSmoothClimate;
import climateControl.customGenLayer.GenLayerSmoothCoast;
import climateControl.customGenLayer.GenLayerSubBiome;
import climateControl.customGenLayer.GenLayerWidenRiver;
import climateControl.customGenLayer.GenLayerZoomBiome;
import climateControl.genLayerPack.GenLayerAddIsland;
import climateControl.genLayerPack.GenLayerFuzzyZoom;
import climateControl.genLayerPack.GenLayerPack;
import climateControl.genLayerPack.GenLayerRareBiome;
import climateControl.genLayerPack.GenLayerSmooth;
import climateControl.genLayerPack.GenLayerZoom;
import climateControl.generator.AbstractWorldGenerator;
import climateControl.utils.IntRandomizer;
import climateControl.utils.RandomIntUser;
import climateControl.utils.StringWriter;
import java.io.File;
import java.io.IOException;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerRiver;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;

public class CorrectedContinentsGenerator
extends AbstractWorldGenerator {
    private File serverDirectoryFile;

    public CorrectedContinentsGenerator(ClimateControlSettings settings, File serverDirectory) {
        super(settings);
        this.serverDirectoryFile = serverDirectory;
    }

    protected IslandClimateMaker islandClimates() {
        return new IslandClimateMaker(){
            RandomIntUser climateChooser;
            {
                this.climateChooser = new ClimateChooser(CorrectedContinentsGenerator.this.settings().hotIncidence.value(), CorrectedContinentsGenerator.this.settings().warmIncidence.value(), CorrectedContinentsGenerator.this.settings().coolIncidence.value(), CorrectedContinentsGenerator.this.settings().snowyIncidence.value());
            }

            @Override
            public int climate(int x, int z, IntRandomizer randomizer) {
                return this.climateChooser.value(randomizer);
            }
        };
    }

    protected RandomIntUser landmassIdentifier() {
        if (!this.settings().separateLandmasses.value().booleanValue()) {
            return this.justLand();
        }
        return new RandomIntUser(){

            @Override
            public int value(IntRandomizer randomizer) {
                return randomizer.nextInt(10000) + 256;
            }
        };
    }

    protected void setOceanSubBiomes() {
    }

    @Override
    public GenLayerRiverMix fromSeed(long worldSeed, WorldType worldType) {
        this.subBiomeChooser.clear();
        this.subBiomeChooser.set(this.settings().biomeSettings());
        this.setOceanSubBiomes();
        this.mBiomeChooser.set(this.settings().biomeSettings());
        this.setRules();
        boolean climatesAssigned = false;
        GenLayerConstant emptyOcean = new GenLayerConstant(0L);
        GenLayerOceanicIslands genlayerisland = new GenLayerOceanicIslands(1L, (GenLayer)emptyOcean, (int)this.settings().largeContinentFrequency.value(), this.landmassIdentifier(), this.separating(), "Large Continent");
        GenLayerPack genlayeraddisland = this.growRound(genlayerisland, 2L, 3L, climatesAssigned);
        if (this.separating()) {
            genlayeraddisland = new GenLayerBreakMergers(1002L, genlayeraddisland);
        }
        if (this.settings().testingMode.value().booleanValue()) {
            genlayeraddisland = new GenLayerConfirm(genlayeraddisland);
            genlayeraddisland = this.reportOn(genlayeraddisland, "large.txt");
        }
        genlayeraddisland = new GenLayerFuzzyZoom(2000L, genlayeraddisland);
        genlayeraddisland = new GenLayerSmooth(2004L, genlayeraddisland);
        GenLayerOceanicIslands mediumContinents = new GenLayerOceanicIslands(4L, (GenLayer)genlayeraddisland, (int)this.settings().mediumContinentFrequency.value(), this.landmassIdentifier(), this.separating(), "Medium Continent");
        genlayeraddisland = this.growRound(mediumContinents, 5L, 7L, climatesAssigned);
        if (this.separating()) {
            genlayeraddisland = new GenLayerBreakMergers(1005L, genlayeraddisland);
        }
        if (this.settings().testingMode.value().booleanValue()) {
            genlayeraddisland = new GenLayerConfirm(genlayeraddisland);
            genlayeraddisland = this.reportOn(genlayeraddisland, "medium.txt");
        }
        GenLayerPack genlayerzoom = new GenLayerFuzzyZoom(2001L, genlayeraddisland);
        genlayerzoom = new GenLayerSmooth(2008L, genlayerzoom);
        GenLayerPack smallContinents = new GenLayerOceanicIslands(8L, (GenLayer)genlayerzoom, (int)this.settings().smallContinentFrequency.value(), this.landmassIdentifier(), this.separating(), "Small Continent");
        if (this.settings().testingMode.value().booleanValue()) {
            smallContinents = new GenLayerConfirm(smallContinents);
            smallContinents = this.reportOn(smallContinents, "forcedbefore.txt");
        }
        if (this.settings().forceStartContinent.value().booleanValue()) {
            smallContinents = new GenLayerForceStartLand(smallContinents, this.islandClimates(2));
        }
        if (this.settings().testingMode.value().booleanValue()) {
            smallContinents = new GenLayerConfirm(smallContinents);
            smallContinents = this.reportOn(smallContinents, "forcedafter.txt");
        }
        genlayeraddisland = this.growRound(smallContinents, 2L, 3L, climatesAssigned);
        if (this.settings().doFull()) {
            genlayeraddisland = this.climateLayer(1014L, genlayeraddisland, this.settings());
            climatesAssigned = true;
        }
        if (this.settings().testingMode.value().booleanValue()) {
            genlayeraddisland = new GenLayerConfirm(genlayeraddisland);
            genlayeraddisland = this.reportOn(genlayeraddisland, "smallGrown.txt");
        }
        genlayeraddisland = new GenLayerZoom(2002L, genlayeraddisland);
        if (this.separating()) {
            genlayeraddisland = new GenLayerBreakMergers(3012L, genlayeraddisland);
        }
        genlayeraddisland = climatesAssigned ? new GenLayerOceanicIslands(11L, (GenLayer)genlayeraddisland, (int)this.settings().largeIslandFrequency.value(), this.islandClimates(1), (boolean)this.settings().separateLandmasses.value(), "Large Island") : new GenLayerOceanicIslands(11L, (GenLayer)genlayeraddisland, (int)this.settings().largeIslandFrequency.value(), this.landmassIdentifier(), (boolean)this.settings().separateLandmasses.value(), "Large Island");
        genlayeraddisland = this.growRound(genlayeraddisland, 13L, 15L, climatesAssigned);
        if (this.settings().testingMode.value().booleanValue()) {
            genlayeraddisland = this.reportOn(genlayeraddisland, "largeIslands.txt");
        }
        if (this.settings().doHalf()) {
            genlayeraddisland = this.climateLayer(1014L, genlayeraddisland, this.settings());
            climatesAssigned = true;
        }
        if (this.settings().testingMode.value().booleanValue()) {
            genlayeraddisland = new GenLayerConfirm(genlayeraddisland);
            genlayeraddisland = this.reportOn(genlayeraddisland, "smoothed.txt");
        }
        genlayeraddisland = new GenLayerZoom(2003L, genlayeraddisland);
        if (this.separating()) {
            genlayeraddisland = new GenLayerBreakMergers(3017L, genlayeraddisland);
        }
        genlayeraddisland = climatesAssigned ? new GenLayerOceanicIslands(17L, (GenLayer)genlayeraddisland, (int)this.settings().mediumIslandFrequency.value(), this.islandClimates(0), (boolean)this.settings().separateLandmasses.value(), "Medium Island") : new GenLayerOceanicIslands(17L, (GenLayer)genlayeraddisland, (int)this.settings().mediumIslandFrequency.value(), this.landmassIdentifier(), (boolean)this.settings().separateLandmasses.value(), "Medium Island");
        genlayeraddisland = new GenLayerAdjustIsland(21L, genlayeraddisland, 3, 12, 12, false);
        if (this.settings().quarterSize.value().booleanValue()) {
            genlayeraddisland = this.climateLayer(1014L, genlayeraddisland, this.settings());
            climatesAssigned = true;
        }
        genlayeraddisland = new GenLayerSmoothClimate(22L, genlayeraddisland);
        if (this.separating()) {
            genlayeraddisland = new GenLayerBreakMergers(3017L, genlayeraddisland);
        }
        if (this.settings().testingMode.value().booleanValue()) {
            genlayeraddisland = this.reportOn(genlayeraddisland, "mediumIslands.txt");
        }
        if (this.settings().testingMode.value().booleanValue()) {
            genlayeraddisland = new GenLayerConfirm(genlayeraddisland);
        }
        genlayeraddisland = new GenLayerLimitedCache(genlayeraddisland, 100);
        GenLayerContinentalShelf genlayerdeepocean = new GenLayerContinentalShelf(23L, genlayeraddisland);
        GenLayerOceanicMushroomIsland genlayeraddmushroomisland = new GenLayerOceanicMushroomIsland(24L, genlayerdeepocean, this.settings().mushroomIslandIncidence.value());
        GenLayer genlayer3 = GenLayerZoom.magnify(1002L, genlayeraddmushroomisland, 0);
        genlayer3.func_75905_a(worldSeed);
        if (this.settings().testingMode.value().booleanValue()) {
            genlayeraddisland = this.reportOn(genlayeraddisland, "preBiome.txt");
        }
        if (this.settings().smootherCoasts.value().booleanValue()) {
            return this.climateControlExpansion(worldSeed, worldType, genlayer3, this.settings());
        }
        return this.vanillaExpansion(worldSeed, worldType, genlayer3, this.settings());
    }

    private final boolean separating() {
        return this.settings().separateLandmasses.value();
    }

    private GenLayerPack growRound(GenLayerPack genlayeraddisland, long firstSeed, long secondSeed, boolean climatesAssigned) {
        if (this.settings().separateLandmasses.value().booleanValue()) {
            for (int round = 0; round < this.settings().landExpansionRounds.value(); ++round) {
                int adjust = round * 50;
                genlayeraddisland = new GenLayerAdjustIsland(firstSeed + (long)adjust, genlayeraddisland, 3, 11, 12, false);
                genlayeraddisland = new GenLayerBreakMergers(firstSeed + (long)adjust + 1000L, genlayeraddisland);
                genlayeraddisland = new GenLayerAdjustIsland(secondSeed + (long)adjust, genlayeraddisland, 3, 11, 12, false);
                genlayeraddisland = new GenLayerBreakMergers(secondSeed + (long)adjust + 1000L, genlayeraddisland);
                if (!this.settings().testingMode.value().booleanValue()) continue;
                genlayeraddisland = new GenLayerConfirm(genlayeraddisland);
            }
        } else {
            genlayeraddisland = new GenLayerAdjustIsland(firstSeed, genlayeraddisland, 3, 11, 12, false);
            genlayeraddisland = new GenLayerAdjustIsland(secondSeed, genlayeraddisland, 3, 11, 12, false);
        }
        return genlayeraddisland;
    }

    private IslandClimateMaker islandClimates(int level) {
        if (this.settings().bandedClimateWidth.value() > 0) {
            int multiplier = 1;
            if (this.settings().doFull()) {
                if (level == 0) {
                    multiplier = 4;
                }
                if (level == 1) {
                    multiplier = 2;
                }
            }
            if (this.settings().doHalf() && level == 0) {
                multiplier = 2;
            }
            return new GenLayerBandedClimate(0L, null, this.settings(), multiplier);
        }
        return this.settings().separateLandmasses.value() != false ? this.identifiedClimate() : this.islandClimates();
    }

    GenLayerPack reportOn(GenLayerPack reportedOn, String fileName) {
        if (this.serverDirectoryFile != null) {
            try {
                StringWriter target = new StringWriter(new File(this.serverDirectoryFile, fileName));
                reportedOn = new GenLayerLandReport(reportedOn, 40, target);
                return reportedOn;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return reportedOn;
    }

    private GenLayerPack climateLayer(long seed, GenLayer parent, ClimateControlSettings settings) {
        if (settings.bandedClimateWidth.value() > 0) {
            return new GenLayerBandedClimate(seed, parent, settings, 1);
        }
        return new GenLayerIdentifiedClimate(seed, parent, this.settings());
    }

    private RandomIntUser justLand() {
        return new RandomIntUser(){

            @Override
            public int value(IntRandomizer randomizer) {
                return 1;
            }
        };
    }

    private IslandClimateMaker identifiedClimate() {
        return new IslandClimateMaker(){
            IslandClimateMaker island;
            RandomIntUser identifier;
            {
                this.island = CorrectedContinentsGenerator.this.islandClimates();
                this.identifier = CorrectedContinentsGenerator.this.landmassIdentifier();
            }

            @Override
            public int climate(int x, int z, IntRandomizer randomizer) {
                return this.island.climate(x, z, randomizer) + 4 * this.identifier.value(randomizer);
            }
        };
    }

    public GenLayerRiverMix climateControlExpansion(long par0, WorldType par2WorldType, GenLayer genlayer3, ClimateControlSettings settings) {
        int b0 = 4;
        b0 = par2WorldType == WorldType.field_77135_d ? 6 : (int)settings.biomeSize.value().byteValue();
        GenLayer genlayer = GenLayerZoom.magnify(1003L, genlayer3, 0);
        GenLayerLessRiver genlayerriverinit = new GenLayerLessRiver(102L, genlayer, this.rtgAwareRiverReduction(this.settings().percentageRiverReduction.value(), par2WorldType));
        GenLayerLessRiver subBiomeFlags = new GenLayerLessRiver(102L, genlayer, 0);
        GenLayerPack biomes = null;
        biomes = settings.randomBiomes.value() != false ? new GenLayerRandomBiomes(par0, genlayer3, settings) : new GenLayerBiomeByTaggedClimate(par0, genlayer3, settings);
        if (this.settings().testingMode.value().booleanValue()) {
            biomes = this.reportOn(biomes, "Biomes.txt");
        }
        GenLayer object = new GenLayerZoom(1004L, biomes);
        object = new GenLayerAddBiome(1005L, object);
        object = new GenLayerSmooth(103L, object);
        object = new GenLayerZoomBiome(1006L, object);
        object = new GenLayerAddBiome(1007L, object);
        object = new GenLayerSmoothCoast(104L, object);
        subBiomeFlags = GenLayerZoom.magnify(1008L, subBiomeFlags, 2);
        GenLayerSubBiome genlayerhills = null;
        genlayerhills = new GenLayerSubBiome(1009L, object, subBiomeFlags, this.subBiomeChooser, this.mBiomeChooser, this.settings().doBoPSubBiomes());
        genlayer = GenLayerZoom.magnify(1010L, genlayerriverinit, 2);
        genlayer = GenLayerZoom.magnify(1010L, genlayer, b0);
        Object genlayerriver = new GenLayerRiver(1L, genlayer);
        if (settings.widerRivers.value().booleanValue()) {
            genlayerriver = new GenLayerWidenRiver(1L, (GenLayer)genlayerriver);
        }
        GenLayerSmoothCoast genlayersmooth = new GenLayerSmoothCoast(1000L, (GenLayer)genlayerriver);
        object = new GenLayerRareBiome(1001L, genlayerhills);
        for (int j = 0; j < b0; ++j) {
            object = new GenLayerZoom(1000 + j, object, true);
            if (j == 0) {
                object = new GenLayerAddIsland(3L, object);
                object = new GenLayerSmoothCoast(100L, object);
            }
            if (j == 1) {
                object = new GenLayerSmoothCoast(100L, object);
            }
            if (settings.wideBeaches.value().booleanValue()) {
                if (j != 0) continue;
                object = new GenLayerPrettyShore(1000L, object, 1.0f, this.rules(), this.settings().mesaMesaBorders.value());
                continue;
            }
            if (j != 1) continue;
            object = new GenLayerPrettyShore(1000L, object, 1.0f, this.rules(), this.settings().mesaMesaBorders.value());
        }
        GenLayerPack genlayersmooth1 = new GenLayerSmooth(1000L, object);
        genlayersmooth1 = new ConfirmBiome(genlayersmooth1);
        if (this.settings().cachingOn()) {
            // empty if block
        }
        GenLayerLowlandRiverMix genlayerrivermix = new GenLayerLowlandRiverMix(100L, genlayersmooth1, genlayersmooth, this.settings().maxRiverChasm.value().floatValue(), this.rules());
        GenLayerVoronoiZoom genlayervoronoizoom = new GenLayerVoronoiZoom(10L, (GenLayer)genlayerrivermix);
        genlayerrivermix.func_75905_a(par0);
        genlayervoronoizoom.func_75905_a(par0);
        return genlayerrivermix;
    }
}

