/*
 * Decompiled with CFR 0.152.
 */
package climateControl.customGenLayer;

import climateControl.utils.IntRandomizer;

public class LandWaterChoices {
    int original;
    boolean isWater;
    UpToFour land = new UpToFour();
    UpToFour water = new UpToFour();

    LandWaterChoices() {
    }

    void setOriginal(int original, boolean isWater) {
        this.original = original;
        this.isWater = isWater;
        this.land.clear();
        this.water.clear();
    }

    int totalItems() {
        int result = this.water.size();
        return result += this.land.size();
    }

    void add(int value, boolean isAddedWater) {
        this.item(isAddedWater).add(value);
    }

    boolean equal() {
        return this.water.size() == 2;
    }

    boolean isChoiceWater() {
        return this.land.size() < 2;
    }

    UpToFour item(boolean waterItem) {
        if (waterItem) {
            return this.water;
        }
        return this.land;
    }

    int mostCommon(IntRandomizer randomizer) {
        int oldCount = this.water.count;
        if (oldCount < 2) {
            if (!this.isWater) {
                return this.original;
            }
            return this.land.items[randomizer.nextInt(this.land.count)];
        }
        if (oldCount == 2) {
            return this.original;
        }
        if (!this.isWater) {
            return this.water.items[randomizer.nextInt(this.water.count)];
        }
        return this.original;
    }

    private class UpToFour {
        int count = 0;
        int value;
        int[] items = new int[4];

        private UpToFour() {
        }

        void setValue(int newValue) {
            this.value = newValue;
            this.count = 0;
        }

        void clear() {
            this.count = 0;
        }

        void add(int added) {
            this.items[this.count] = added;
            ++this.count;
        }

        int size() {
            return this.count;
        }
    }
}

