/*
 * Decompiled with CFR 0.152.
 */
package climateControl.customGenLayer;

import climateControl.genLayerPack.GenLayerPack;
import climateControl.utils.Receiver;
import net.minecraft.world.gen.layer.GenLayer;

public class GenLayerLandReport
extends GenLayerPack {
    private boolean reported = false;
    private final Receiver<String> reportee;
    private final int distanceFromOrigin;

    public GenLayerLandReport(GenLayer parent, int distance, Receiver<String> reportee) {
        super(0L);
        this.field_75909_a = parent;
        this.distanceFromOrigin = distance;
        this.reportee = reportee;
    }

    @Override
    public int[] func_75904_a(int var1, int var2, int var3, int var4) {
        if (!this.reported) {
            this.report();
            this.reported = true;
        }
        return this.field_75909_a.func_75904_a(var1, var2, var3, var4);
    }

    private void report() {
        int value;
        int j;
        String report;
        int i;
        int width = 2 * this.distanceFromOrigin + 1;
        int[] toReport = this.field_75909_a.func_75904_a(-this.distanceFromOrigin, -this.distanceFromOrigin, 2 * this.distanceFromOrigin + 1, 2 * this.distanceFromOrigin + 1);
        int total = 0;
        int[] climates = new int[5];
        climates[1] = 0;
        climates[2] = 0;
        climates[3] = 0;
        climates[4] = 0;
        for (i = 0; i < 2 * this.distanceFromOrigin + 1; ++i) {
            report = "";
            for (j = 0; j < 2 * this.distanceFromOrigin + 1; ++j) {
                value = toReport[i * (2 * this.distanceFromOrigin + 1) + j];
                if (value == 24) {
                    value = 0;
                }
                if (value == 0) {
                    report = report + ". ";
                    continue;
                }
                if (value > 0 && value < 100000) {
                    int climate = value % 4;
                    if (climate == 0) {
                        climate = 4;
                    }
                    int n = climate;
                    climates[n] = climates[n] + 1;
                    String result = "" + climate + " ";
                    report = report + result;
                } else {
                    report = report + "1 ";
                }
                ++total;
            }
            this.reportee.accept(report);
        }
        this.reportee.accept("");
        this.reportee.accept("Land " + total + " of " + width * width + " " + (int)((double)((float)(total * 100) / (float)(width * width)) + 0.5) + "%");
        if (climates[2] > 0 || climates[3] > 0 || climates[4] > 0) {
            this.reportee.accept("Hot   " + climates[1] + " " + (int)((float)(climates[1] * 100) / (float)total) + "%");
            this.reportee.accept("Warm  " + climates[2] + " " + (int)((float)(climates[2] * 100) / (float)total) + "%");
            this.reportee.accept("Cool  " + climates[3] + " " + (int)((float)(climates[3] * 100) / (float)total) + "%");
            this.reportee.accept("Snowy " + climates[4] + " " + (int)((float)(climates[4] * 100) / (float)total) + "%");
        }
        this.reportee.accept("");
        for (i = 0; i < 2 * this.distanceFromOrigin + 1; ++i) {
            report = "";
            for (j = 0; j < 2 * this.distanceFromOrigin + 1; ++j) {
                value = i;
                report = report + value + " ";
            }
        }
        this.reportee.accept("");
        for (i = 0; i < 2 * this.distanceFromOrigin + 1; ++i) {
            report = "";
            j = 0;
            while (j < 2 * this.distanceFromOrigin + 1) {
                value = j++;
                report = report + value + " ";
            }
        }
        this.reportee.done();
    }
}

