/*
 * Decompiled with CFR 0.152.
 */
package climateControl.customGenLayer;

import climateControl.ClimateControl;
import climateControl.api.ClimateControlSettings;
import climateControl.genLayerPack.GenLayerPack;
import climateControl.utils.Numbered;
import climateControl.utils.PlaneLocation;
import climateControl.utils.Zeno410Logger;
import java.util.HashSet;
import java.util.logging.Logger;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.layer.GenLayer;

public class GenLayerIdentifiedClimate
extends GenLayerPack {
    private final int hotLevel;
    private final int warmLevel;
    private final int coldLevel;
    private final int totalLevel;
    public static Logger logger = new Zeno410Logger("IdentifiedClimate").logger();

    private GenLayerIdentifiedClimate(long par1, GenLayer par3GenLayer, int hot, int warm, int cold, int snow) {
        super(par1);
        this.field_75909_a = par3GenLayer;
        this.hotLevel = hot;
        this.warmLevel = hot + warm;
        this.coldLevel = hot + warm + cold;
        this.totalLevel = hot + warm + cold + snow;
    }

    public GenLayerIdentifiedClimate(long seed, GenLayer genLayer, ClimateControlSettings settings) {
        this(seed, genLayer, settings.hotIncidence.value(), settings.warmIncidence.value(), settings.coolIncidence.value(), settings.snowyIncidence.value());
    }

    @Override
    public int[] func_75904_a(int x0, int z0, int xSize, int zSize) {
        int k2;
        int parentX;
        int parentZ;
        Prioritizer prioritizer = new Prioritizer();
        int parentX0 = x0 - 2;
        int parentZ0 = z0 - 2;
        int parentXSize = xSize + 4;
        int parentZSize = zSize + 4;
        int[] parentIds = this.field_75909_a.func_75904_a(parentX0, parentZ0, parentXSize, parentZSize);
        int[] parentVals = this.getRawClimates(parentIds, parentX0, parentZ0, parentXSize, parentZSize);
        int[] vals = new int[xSize * zSize];
        for (parentZ = 0; parentZ < parentZSize; ++parentZ) {
            for (parentX = 0; parentX < parentXSize; ++parentX) {
                k2 = parentVals[parentX + parentZ * parentXSize];
                this.setFromParentCoords(k2, parentX, parentZ, xSize, zSize, vals);
                if (k2 > 4 && k2 != 24 && k2 != BiomeGenBase.field_76789_p.field_76756_M && ClimateControl.testing) {
                    ClimateControl.logger.info("GenLayerSmoothClimate " + k2);
                    throw new RuntimeException("GenLayerSmoothClimate " + k2);
                }
                this.func_75903_a(parentX + parentX0, parentZ + parentZ0);
                if (k2 != 1 && k2 != 4) continue;
            }
        }
        parentVals = null;
        for (parentZ = 2; parentZ < parentZSize - 2; ++parentZ) {
            for (parentX = 2; parentX < parentXSize - 2; ++parentX) {
                k2 = parentIds[parentX + parentZ * parentXSize];
                if (k2 < 256) continue;
                int n = parentX - 2 + (parentZ - 2) * xSize;
                vals[n] = vals[n] + k2 * 4;
            }
        }
        return vals;
    }

    private final void setFromParentCoords(int value, int px, int pz, int xSize, int zSize, int[] vals) {
        if (px < 2 || pz < 2 || px - 1 > xSize || pz - 1 > zSize) {
            return;
        }
        vals[px - 2 + (pz - 2) * xSize] = value;
    }

    private final void coolerThanHot(int px, int pz, int xSize, int zSize, int[] vals) {
        if (px < 2 || pz < 2 || px - 1 > xSize || pz - 1 > zSize) {
            return;
        }
        int value = vals[px - 2 + (pz - 2) * xSize];
        if (value == 1) {
            vals[px - 2 + (pz - 2) * xSize] = 2;
        }
    }

    private final void warmerThanSnowy(int px, int pz, int xSize, int zSize, int[] vals) {
        if (px < 2 || pz < 2 || px - 1 > xSize || pz - 1 > zSize) {
            return;
        }
        int value = vals[px - 2 + (pz - 2) * xSize];
        if (value == 4) {
            vals[px - 2 + (pz - 2) * xSize] = 3;
        }
    }

    private final void coolerThanWarm(int px, int pz, int xSize, int zSize, int[] vals) {
        if (px < 2 || pz < 2 || px - 1 > xSize || pz - 1 > zSize) {
            return;
        }
        int value = vals[px - 2 + (pz - 2) * xSize];
        if (value == 1) {
            vals[px - 2 + (pz - 2) * xSize] = 3;
        }
        if (value == 2) {
            vals[px - 2 + (pz - 2) * xSize] = 3;
        }
    }

    private final void warmerThanCool(int px, int pz, int xSize, int zSize, int[] vals) {
        if (px < 2 || pz < 2 || px - 1 > xSize || pz - 1 > zSize) {
            return;
        }
        int value = vals[px - 2 + (pz - 2) * xSize];
        if (value == 4) {
            vals[px - 2 + (pz - 2) * xSize] = 2;
        }
        if (value == 3) {
            vals[px - 2 + (pz - 2) * xSize] = 2;
        }
    }

    private int[] getRawClimates(int[] parent, int par1, int par2, int par3, int par4) {
        int[] aint1 = new int[par3 * par4];
        for (int i2 = 0; i2 < par4; ++i2) {
            for (int j2 = 0; j2 < par3; ++j2) {
                int k2 = parent[j2 + i2 * par3];
                this.func_75903_a(j2 + par1, i2 + par2);
                if (k2 == 0) {
                    aint1[j2 + i2 * par3] = 0;
                    continue;
                }
                int l2 = this.func_75902_a(this.totalLevel);
                int b0 = l2 < this.hotLevel ? 1 : (l2 < this.warmLevel ? 2 : (l2 < this.coldLevel ? 3 : 4));
                aint1[j2 + i2 * par3] = b0;
            }
        }
        for (int i = 0; i < par3 * par4; ++i) {
            if (aint1[i] <= 255) continue;
            throw new RuntimeException();
        }
        return aint1;
    }

    private class Prioritizer {
        HashSet<Integer> numbers = new HashSet();
        boolean duplicate = false;

        private Prioritizer() {
        }

        int next() {
            int number = GenLayerIdentifiedClimate.this.func_75902_a(1000000000);
            number = GenLayerIdentifiedClimate.this.func_75902_a(1000000000);
            if (this.numbers.contains(number)) {
                this.duplicate = true;
                throw new RuntimeException();
            }
            this.numbers.add(number);
            return number;
        }
    }

    private class Cold
    extends ExtremeTemp {
        Cold(Prioritizer prioritizer, int x, int z) {
            super(prioritizer, x, z);
        }

        public String toString() {
            return "Cold " + this.x() + "," + this.z();
        }

        @Override
        void adjust(int[] parentVals, int xSize, int zSize, int[] vals) {
            GenLayerIdentifiedClimate.this.setFromParentCoords(4, this.x(), this.z(), xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.coolerThanWarm(this.x() - 1, this.z(), xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.coolerThanWarm(this.x(), this.z() - 1, xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.coolerThanWarm(this.x() + 1, this.z(), xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.coolerThanWarm(this.x(), this.z() + 1, xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.coolerThanHot(this.x() - 2, this.z(), xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.coolerThanHot(this.x() - 1, this.z() - 1, xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.coolerThanHot(this.x(), this.z() - 2, xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.coolerThanHot(this.x() + 1, this.z() - 1, xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.coolerThanHot(this.x() + 2, this.z(), xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.coolerThanHot(this.x() + 1, this.z() + 1, xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.coolerThanHot(this.x(), this.z() + 2, xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.coolerThanHot(this.x() - 1, this.z() + 1, xSize, zSize, vals);
        }
    }

    private class Hot
    extends ExtremeTemp {
        Hot(Prioritizer prioritizer, int x, int z) {
            super(prioritizer, x, z);
        }

        public String toString() {
            return "Hot  " + this.x() + "," + this.z();
        }

        @Override
        void adjust(int[] parentVals, int xSize, int zSize, int[] vals) {
            GenLayerIdentifiedClimate.this.setFromParentCoords(1, this.x(), this.z(), xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.warmerThanCool(this.x() - 1, this.z(), xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.warmerThanCool(this.x(), this.z() - 1, xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.warmerThanCool(this.x() + 1, this.z(), xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.warmerThanCool(this.x(), this.z() + 1, xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.warmerThanSnowy(this.x() - 2, this.z(), xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.warmerThanSnowy(this.x() - 1, this.z() - 1, xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.warmerThanSnowy(this.x(), this.z() - 2, xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.warmerThanSnowy(this.x() + 1, this.z() - 1, xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.warmerThanSnowy(this.x() + 2, this.z(), xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.warmerThanSnowy(this.x() + 1, this.z() + 1, xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.warmerThanSnowy(this.x(), this.z() + 2, xSize, zSize, vals);
            GenLayerIdentifiedClimate.this.warmerThanSnowy(this.x() - 1, this.z() + 1, xSize, zSize, vals);
        }
    }

    private abstract class ExtremeTemp
    extends Numbered<PlaneLocation> {
        ExtremeTemp(Prioritizer prioritizer, int x, int z) {
            super(prioritizer.next(), new PlaneLocation(x, z));
        }

        final int x() {
            return ((PlaneLocation)this.item()).x();
        }

        final int z() {
            return ((PlaneLocation)this.item()).z();
        }

        abstract void adjust(int[] var1, int var2, int var3, int[] var4);
    }
}

