/*
 * Decompiled with CFR 0.152.
 */
package climateControl.biomeSettings;

import climateControl.api.BiomePackage;
import climateControl.api.BiomeSettings;
import climateControl.api.ClimateControlRules;
import climateControl.utils.Mutable;
import climateControl.utils.Settings;
import de.teamlapen.vampirism.biome.BiomeVampireForest;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class VampirismPackage
extends BiomePackage {
    public VampirismPackage() {
        super("VampirismInCC.cfg");
        Class<BiomeVampireForest> vampireForestClass = BiomeVampireForest.class;
    }

    @Override
    public BiomeSettings freshBiomeSetting() {
        return new VampirismBiomeSettings();
    }

    public static class VampirismBiomeSettings
    extends BiomeSettings {
        public static final String biomeCategory = "VampirismBiome";
        public static final String vampirismCategory = "VampirismSettings";
        public final Settings.Category vampirismSettings = new Settings.Category("VampirismSettings");
        public final BiomeSettings.Element vampirismBiome = (BiomeSettings)this.new BiomeSettings.Element("Vampirism Biome", 40, "LAND");
        static final String biomesOnName = "VampirismBiomeOn";
        public final Mutable<Boolean> biomesFromConfig = this.vampirismSettings.booleanSetting("VampirismBiomeOn", "", false);
        static final String configName = "Vampirism";
        public final Mutable<Boolean> biomesInNewWorlds = this.climateControlCategory.booleanSetting(this.startBiomesName("Vampirism"), "Use biome in new worlds and dimensions", true);

        public VampirismBiomeSettings() {
            super(biomeCategory);
        }

        @Override
        public void setRules(ClimateControlRules rules) {
        }

        @Override
        public void setNativeBiomeIDs(File configDirectory) {
            NativeVampirismSettings result = new NativeVampirismSettings();
            File configFile = new File(configDirectory, "vampirism.cfg");
            result.readFrom(new Configuration(configFile));
            this.vampirismBiome.biomeID().set(result.vampirismBiomeID.value());
        }

        @Override
        public void onNewWorld() {
            this.biomesFromConfig.set(this.biomesInNewWorlds);
        }

        @Override
        public boolean biomesAreActive() {
            return this.biomesFromConfig.value();
        }

        private class NativeVampirismSettings
        extends Settings {
            public static final String biomeIDName = "general";
            public static final String disableName = "disable";
            public final Settings.Category biomeIDs = new Settings.Category("general");
            public final Settings.Category disable = new Settings.Category("disable");
            Mutable<Integer> vampirismBiomeID = this.biomeIDs.intSetting("vampirism_biome_id", 40);
            Mutable<Boolean> vampirismBiomeDisabled = this.disable.booleanSetting("disable_vampire_biome", false);

            private NativeVampirismSettings() {
            }
        }
    }
}

