/*
 * Decompiled with CFR 0.152.
 */
package climateControl.biomeSettings;

import climateControl.api.BiomeSettings;
import climateControl.api.ClimateControlRules;
import climateControl.utils.Mutable;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ThaumcraftBiomeSettings
extends BiomeSettings {
    public static final String biomeCategory = "ThaumcraftBiome";
    public final BiomeSettings.Element tainted = (BiomeSettings)this.new BiomeSettings.Element("Tainted", 192, 1);
    public final BiomeSettings.Element magicalForest = (BiomeSettings)this.new BiomeSettings.Element("Magical Forest", 193, 7);
    public final BiomeSettings.Element eerie = (BiomeSettings)this.new BiomeSettings.Element("Eerie", 194, 3);
    static final String biomesOnName = "ThaumcraftBiomesOn";
    public final Mutable<Boolean> biomesFromConfig = this.climateControlCategory.booleanSetting("ThaumcraftBiomesOn", "", false);
    static final String configName = "Thaumcraft";
    public final Mutable<Boolean> biomesInNewWorlds = this.climateControlCategory.booleanSetting(this.startBiomesName("Thaumcraft"), "Use biome in new worlds and dimensions", true);

    public ThaumcraftBiomeSettings() {
        super(biomeCategory);
    }

    @Override
    public void setNativeBiomeIDs(File configDirectory) {
        Configuration config = new Configuration(new File(configDirectory, "Thaumcraft.cfg"));
        this.tainted.biomeID().set(config.get("biomes", "biome_taint", 192).getInt());
        this.magicalForest.biomeID().set(config.get("biomes", "biome_magical_forest", 193).getInt());
        this.eerie.biomeID().set(config.get("biomes", "biome_eerie", 194).getInt());
    }

    @Override
    public void setRules(ClimateControlRules rules) {
    }

    @Override
    public void onNewWorld() {
        this.biomesFromConfig.set(this.biomesInNewWorlds);
    }

    @Override
    public boolean biomesAreActive() {
        return this.biomesFromConfig.value();
    }
}

