/*
 * Decompiled with CFR 0.152.
 */
package climateControl.api;

import climateControl.api.ClimateControlSettings;
import climateControl.api.DimensionalSettingsModifier;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import java.util.HashMap;
import net.minecraftforge.event.world.WorldEvent;

public class DimensionalSettingsRegistry {
    private HashMap<String, DimensionalSettingsModifier> modifiers = new HashMap();
    private HashMap<Integer, Long> dimensionalSeeds = new HashMap();
    public static DimensionalSettingsRegistry instance;

    public void add(String tag, DimensionalSettingsModifier modifier) {
        this.modifiers.put(tag, modifier);
    }

    public void remove(String tag) {
        this.modifiers.remove(tag);
    }

    public boolean useCCIn(int dimension) {
        for (DimensionalSettingsModifier modifier : this.modifiers.values()) {
            if (!modifier.signalCCActive(dimension)) continue;
            return true;
        }
        return false;
    }

    public void modify(int dimension, ClimateControlSettings settings) {
        for (DimensionalSettingsModifier modifier : this.modifiers.values()) {
            modifier.modify(dimension, settings);
        }
    }

    public void onWorldLoad(WorldEvent.Load event) {
        for (DimensionalSettingsModifier modifier : this.modifiers.values()) {
            modifier.onWorldLoad(event);
        }
    }

    public void unloadWorld(WorldEvent.Unload event) {
        for (DimensionalSettingsModifier modifier : this.modifiers.values()) {
            modifier.unloadWorld(event);
        }
    }

    public void serverStarted(FMLServerStartedEvent event) {
        for (DimensionalSettingsModifier modifier : this.modifiers.values()) {
            modifier.serverStarted(event);
        }
    }

    public void serverStopped(FMLServerStoppedEvent event) {
        for (DimensionalSettingsModifier modifier : this.modifiers.values()) {
            modifier.serverStopped(event);
        }
    }
}

