/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.IMENetworkInventory;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.NetworkItemList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class PrioritizedNetworkItemList<T extends IAEStack>
extends NetworkItemList<T> {
    private final Map<IMENetworkInventory<T>, Map<Integer, IItemList<T>>> prioritizedNetworkItemLists;

    public PrioritizedNetworkItemList(IMENetworkInventory<T> network) {
        super(network, null);
        this.prioritizedNetworkItemLists = new HashMap<IMENetworkInventory<T>, Map<Integer, IItemList<T>>>();
    }

    public PrioritizedNetworkItemList(PrioritizedNetworkItemList<T> networkItemList) {
        super(networkItemList);
        this.prioritizedNetworkItemLists = networkItemList.prioritizedNetworkItemLists;
    }

    @Override
    public void addNetworkItems(IMENetworkInventory<T> network, IItemList<T> itemList) {
        throw new UnsupportedOperationException();
    }

    public void addNetworkItems(IMENetworkInventory<T> network, int priority, IItemList<T> itemList) {
        IItemList<T> l;
        Map<Integer, IItemList<T>> priorityItemList = this.prioritizedNetworkItemLists.get(network);
        IItemList<T> iItemList = l = priorityItemList == null ? null : priorityItemList.get(priority);
        if (l instanceof PrioritizedNetworkItemList) {
            if (itemList instanceof PrioritizedNetworkItemList) {
                for (Predicate filter : ((PrioritizedNetworkItemList)itemList).getPredicates()) {
                    ((PrioritizedNetworkItemList)l).addFilter(filter);
                }
                return;
            }
            throw new RuntimeException("This PrioritizedNetworkItemList already contains a PrioritizedNetworkItemList for the provided network and priority and cannot replace it with a non-PrioritizedNetworkItemList");
        }
        if (l != null) {
            throw new RuntimeException("This PrioritizedNetworkItemList already contains a non-PrioritizedNetworkItemList for the provided network and priority and cannot replace it");
        }
        if (priorityItemList == null) {
            priorityItemList = new HashMap<Integer, IItemList<T>>();
            this.prioritizedNetworkItemLists.put(network, priorityItemList);
        }
        priorityItemList.put(priority, itemList);
    }

    private Stream<PrioritizedNetworkItemStack<T>> getFilteredPrioritizedNetworkItemStackStream(Set<IMENetworkInventory<T>> visitedNetworks, boolean ascendingPriority) {
        return this.prioritizedNetworkItemLists.entrySet().stream().flatMap(entry -> {
            ArrayList<Stream<PrioritizedNetworkItemStack<Object>>> priorityStreams = new ArrayList<Stream<PrioritizedNetworkItemStack<Object>>>();
            Iterator it = ((Map)entry.getValue()).entrySet().stream().sorted(this.getPriorityOrder(ascendingPriority)).iterator();
            while (it.hasNext()) {
                Map.Entry priorityItemList = (Map.Entry)it.next();
                int priorty = (Integer)priorityItemList.getKey();
                IItemList itemList = (IItemList)priorityItemList.getValue();
                if (itemList instanceof PrioritizedNetworkItemList) {
                    if (visitedNetworks.contains(entry.getKey())) {
                        return Stream.empty();
                    }
                    HashSet<IMENetworkInventory> localVisitedNetworks = new HashSet<IMENetworkInventory>(visitedNetworks);
                    localVisitedNetworks.add((IMENetworkInventory)entry.getKey());
                    PrioritizedNetworkItemList l = (PrioritizedNetworkItemList)itemList;
                    Predicate predicate = l.buildFilter();
                    Stream<PrioritizedNetworkItemStack> stream = l.getFilteredPrioritizedNetworkItemStackStream(Collections.unmodifiableSet(localVisitedNetworks), ascendingPriority).filter(e -> predicate.test(e.getItemStack())).peek(e -> e.setNetworkPriority(this.getNetwork(), priorty));
                    priorityStreams.add(stream);
                    continue;
                }
                ArrayList buffer = new ArrayList();
                itemList.forEach(item -> buffer.add(new PrioritizedNetworkItemStack<IAEStack>((IMENetworkInventory)entry.getKey(), (IAEStack)item, priorty)));
                priorityStreams.add(buffer.stream());
            }
            return priorityStreams.stream().flatMap(Function.identity());
        });
    }

    private Comparator<Map.Entry<Integer, IItemList<T>>> getPriorityOrder(boolean asc) {
        Comparator<Map.Entry<Integer, IItemList<T>>> comparator = Map.Entry.comparingByKey();
        if (asc) {
            return comparator;
        }
        return comparator.reversed();
    }

    @Override
    public Stream<T> getItems() {
        return this.getItems(true);
    }

    public Stream<T> getItems(boolean ascendingPriority) {
        HashSet visitedNetworks = new HashSet();
        visitedNetworks.add(this.getNetwork());
        Comparator comparator = new Comparator<PrioritizedNetworkItemStack<T>>(){

            @Override
            public int compare(PrioritizedNetworkItemStack<T> o1, PrioritizedNetworkItemStack<T> o2) {
                int result = 0;
                for (Map.Entry entry : o1.networkPriority.entrySet()) {
                    int o1Prio = (Integer)entry.getValue();
                    Integer o2Prio = o2.getNetworkPriority((IMENetworkInventory)entry.getKey());
                    if (o2Prio != null) {
                        result = Integer.compare(o1Prio, o2Prio);
                    }
                    if (result == 0) continue;
                    break;
                }
                return result;
            }
        };
        return this.getFilteredPrioritizedNetworkItemStackStream(Collections.unmodifiableSet(visitedNetworks), ascendingPriority).distinct().sorted(ascendingPriority ? comparator : comparator.reversed()).map(NetworkItemList.NetworkItemStack::getItemStack);
    }

    @Override
    public IItemList<T> buildFinalItemList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IItemList<T> buildFinalItemList(IItemList<T> out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T findPrecise(T i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<T> findFuzzy(T input, FuzzyMode fuzzy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getStackType() {
        Map m = this.prioritizedNetworkItemLists.values().stream().findAny().orElse(null);
        if (m == null) {
            return 0;
        }
        IItemList list = m.values().stream().findAny().orElse(null);
        return list == null ? (byte)0 : list.getStackType();
    }

    @Override
    public void resetStatus() {
        for (Map<Integer, IItemList<T>> m : this.prioritizedNetworkItemLists.values()) {
            for (IItemList<T> l : m.values()) {
                l.resetStatus();
            }
        }
    }

    private static class PrioritizedNetworkItemStack<U extends IAEStack>
    extends NetworkItemList.NetworkItemStack<U> {
        private final Map<IMENetworkInventory<U>, Integer> networkPriority = new HashMap<IMENetworkInventory<U>, Integer>();

        public PrioritizedNetworkItemStack(@Nonnull IMENetworkInventory<U> networkInventory, @Nonnull U itemStack, int priority) {
            super(networkInventory, itemStack);
            this.setNetworkPriority(networkInventory, priority);
        }

        public Integer getNetworkPriority(@Nonnull IMENetworkInventory<U> networkInventory) {
            return this.networkPriority.get(networkInventory);
        }

        public void setNetworkPriority(@Nonnull IMENetworkInventory<U> networkInventory, int priority) {
            if (this.networkPriority.containsKey(networkInventory)) {
                return;
            }
            this.networkPriority.put(networkInventory, priority);
        }
    }
}

