/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.config.Actionable;
import appeng.api.config.InsertionMode;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.me.storage.CellInventory;
import appeng.tile.storage.TileChest;
import appeng.util.inv.AdaptorIInventory;
import appeng.util.inv.WrapperMCISidedInventory;
import appeng.util.item.AEItemStack;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class AdaptorMEChest
extends AdaptorIInventory {
    private final TileChest meChest;
    private final IInventory i;

    public AdaptorMEChest(WrapperMCISidedInventory i, TileChest meChest) {
        super(i);
        this.meChest = meChest;
        this.i = i;
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded) {
        return this.addItems(toBeAdded, InsertionMode.DEFAULT);
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded, InsertionMode insertionMode) {
        if (this.meChest.getItemInventory() == null) {
            if (CellInventory.isCell(toBeAdded)) {
                return this.addCell(toBeAdded, true);
            }
            return toBeAdded;
        }
        IAEItemStack result = this.meChest.getItemInventory().injectItems(AEItemStack.create(toBeAdded), Actionable.MODULATE, this.meChest.getActionSource());
        return result == null ? null : result.getItemStack();
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        return this.simulateAdd(toBeSimulated, InsertionMode.DEFAULT);
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated, InsertionMode insertionMode) {
        if (this.meChest.getItemInventory() == null) {
            if (CellInventory.isCell(toBeSimulated)) {
                return this.addCell(toBeSimulated, false);
            }
            return toBeSimulated;
        }
        IAEItemStack result = this.meChest.getItemInventory().injectItems(AEItemStack.create(toBeSimulated), Actionable.SIMULATE, this.meChest.getActionSource());
        return result == null ? null : result.getItemStack();
    }

    @Override
    public IAEStack<?> addStack(IAEStack<?> toBeAdded, InsertionMode insertionMode) {
        IMEMonitor monitor = toBeAdded.isItem() ? this.meChest.getItemInventory() : this.meChest.getFluidInventory();
        return monitor != null ? monitor.injectItems(toBeAdded, Actionable.MODULATE, this.meChest.getActionSource()) : toBeAdded;
    }

    @Override
    public IAEStack<?> simulateAddStack(IAEStack<?> toBeSimulated, InsertionMode insertionMode) {
        IMEMonitor monitor = toBeSimulated.isItem() ? this.meChest.getItemInventory() : this.meChest.getFluidInventory();
        return monitor != null ? monitor.injectItems(toBeSimulated, Actionable.SIMULATE, this.meChest.getActionSource()) : toBeSimulated;
    }

    @Override
    public boolean containsItems() {
        if (this.meChest.getItemInventory() != null && !this.meChest.getItemInventory().getStorageList().isEmpty()) {
            return true;
        }
        if (this.meChest.getFluidInventory() != null) {
            return !this.meChest.getFluidInventory().getStorageList().isEmpty();
        }
        return false;
    }

    private ItemStack addCell(ItemStack cell, boolean modulate) {
        ItemStack leftoverItems = cell.func_77946_l();
        ItemStack nextItem = leftoverItems.func_77946_l();
        nextItem.field_77994_a = 1;
        leftoverItems.field_77994_a -= nextItem.field_77994_a;
        if (modulate) {
            this.i.func_70299_a(0, nextItem);
            this.i.func_70296_d();
        }
        if (leftoverItems.field_77994_a <= 0) {
            return null;
        }
        return leftoverItems;
    }
}

