/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.config.FuzzyMode;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import com.google.common.collect.Iterators;
import com.gtnewhorizon.gtnhlib.capability.item.ItemIO;
import com.gtnewhorizon.gtnhlib.item.FastImmutableItemStack;
import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.item.InventoryIterator;
import com.gtnewhorizon.gtnhlib.util.ItemUtil;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class AdaptorItemIO
extends InventoryAdaptor {
    private final ItemIO itemIO;

    public AdaptorItemIO(ItemIO itemIO) {
        this.itemIO = itemIO;
    }

    @Override
    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        InventoryIterator iter = this.itemIO.sourceIterator();
        if (iter == null) {
            return null;
        }
        ItemStack out = null;
        while (iter.hasNext() && amount > 0) {
            ItemStack extracted;
            ImmutableItemStack immutableStack = (ImmutableItemStack)iter.next();
            if (immutableStack == null || filter != null && !immutableStack.matches(filter)) continue;
            ItemStack stack = immutableStack.toStack();
            if (destination != null && !destination.canInsert(stack)) continue;
            if (out == null) {
                out = immutableStack.toStack(0);
            }
            if ((extracted = iter.extract(amount, false)) == null) continue;
            out.field_77994_a += extracted.field_77994_a;
            amount -= extracted.field_77994_a;
        }
        return out;
    }

    @Override
    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        InventoryIterator iter = this.itemIO.sourceIterator();
        if (iter == null) {
            return null;
        }
        ItemStack out = null;
        while (iter.hasNext() && amount > 0) {
            ImmutableItemStack stack = (ImmutableItemStack)iter.next();
            if (stack == null || filter != null && !stack.matches(filter) || destination != null && !destination.canInsert(stack.toStackFast())) continue;
            if (out == null) {
                out = stack.toStack(0);
            }
            int simulatedTransfer = Math.min(amount, stack.getStackSize());
            out.field_77994_a += simulatedTransfer;
            amount -= simulatedTransfer;
        }
        return out;
    }

    @Override
    public ItemStack removeSimilarItems(int amount, ItemStack fuzzyFilter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        InventoryIterator iter = this.itemIO.sourceIterator();
        if (iter == null) {
            return null;
        }
        ItemStack out = null;
        while (iter.hasNext() && amount > 0) {
            ItemStack extracted;
            ImmutableItemStack immutableStack = (ImmutableItemStack)iter.next();
            if (immutableStack == null) continue;
            ItemStack stack = immutableStack.toStack();
            if (out == null ? fuzzyFilter != null && !Platform.isSameItemFuzzy(stack, fuzzyFilter, fuzzyMode) : !Platform.isSameItemPrecise(out, stack)) continue;
            if (destination != null && !destination.canInsert(stack)) continue;
            if (out == null) {
                out = immutableStack.toStack(0);
            }
            if ((extracted = iter.extract(amount, false)) == null) continue;
            out.field_77994_a += extracted.field_77994_a;
            amount -= extracted.field_77994_a;
        }
        return out;
    }

    @Override
    public ItemStack simulateSimilarRemove(int amount, ItemStack fuzzyFilter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        InventoryIterator iter = this.itemIO.sourceIterator();
        if (iter == null) {
            return null;
        }
        ItemStack out = null;
        while (iter.hasNext() && amount > 0) {
            ImmutableItemStack immutableStack = (ImmutableItemStack)iter.next();
            if (immutableStack == null) continue;
            ItemStack stack = immutableStack.toStack();
            if (out == null ? fuzzyFilter != null && !Platform.isSameItemFuzzy(stack, fuzzyFilter, fuzzyMode) : !Platform.isSameItemPrecise(out, stack)) continue;
            if (destination != null && !destination.canInsert(stack)) continue;
            if (out == null) {
                out = immutableStack.toStack(0);
            }
            int simulatedTransfer = Math.min(amount, immutableStack.getStackSize());
            out.field_77994_a += simulatedTransfer;
            amount -= simulatedTransfer;
        }
        return out;
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded) {
        int rejected = this.itemIO.store((ImmutableItemStack)new FastImmutableItemStack(toBeAdded));
        return rejected == 0 ? null : ItemUtil.copyAmount((int)rejected, (ItemStack)toBeAdded);
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        return null;
    }

    @Override
    public boolean containsItems() {
        if (this.itemIO.getStoredItemsInSink(null).orElse(0) > 0) {
            return true;
        }
        InventoryIterator iter = this.itemIO.sinkIterator();
        if (iter != null) {
            while (iter.hasNext()) {
                if (iter.next() == null) continue;
                return true;
            }
        }
        if ((iter = this.itemIO.sourceIterator()) != null) {
            while (iter.hasNext()) {
                if (iter.next() == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Iterator<ItemSlot> iterator() {
        final InventoryIterator iter = this.itemIO.sourceIterator();
        if (iter == null) {
            return Iterators.emptyIterator();
        }
        return new Iterator<ItemSlot>(){
            private final ItemSlot slot = new ItemSlot();
            private int i = 0;

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public ItemSlot next() {
                ImmutableItemStack stack = (ImmutableItemStack)iter.next();
                this.slot.setItemStack(stack == null ? null : stack.toStack());
                this.slot.setExtractable(true);
                this.slot.setSlot(this.i++);
                return this.slot;
            }
        };
    }
}

