/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.config.FuzzyMode;
import appeng.api.config.InsertionMode;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorIInventory;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import appeng.util.inv.WrapperMCISidedInventory;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.ItemFluidPacket;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class AdaptorFluidHandler
extends InventoryAdaptor {
    IFluidHandler fluidHandler;
    AdaptorIInventory itemHandler;
    ForgeDirection toAdaptor;

    public AdaptorFluidHandler(IFluidHandler tank, ForgeDirection direction) {
        IInventory i;
        this.fluidHandler = tank;
        this.toAdaptor = direction;
        if (tank instanceof ISidedInventory) {
            ISidedInventory si = (ISidedInventory)tank;
            int[] slots = si.func_94128_d(direction.ordinal());
            if (si.func_70302_i_() > 0 && slots != null && slots.length > 0) {
                this.itemHandler = new AdaptorIInventory(new WrapperMCISidedInventory(si, direction));
            }
        } else if (tank instanceof IInventory && (i = (IInventory)tank).func_70302_i_() > 0) {
            this.itemHandler = new AdaptorIInventory(i);
        }
    }

    @Override
    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        return this.itemHandler != null ? this.itemHandler.removeItems(amount, filter, destination) : null;
    }

    @Override
    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        return this.itemHandler != null ? this.itemHandler.simulateRemove(amount, filter, destination) : null;
    }

    @Override
    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        return this.itemHandler != null ? this.itemHandler.removeSimilarItems(amount, filter, fuzzyMode, destination) : null;
    }

    @Override
    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        return this.itemHandler != null ? this.itemHandler.simulateSimilarRemove(amount, filter, fuzzyMode, destination) : null;
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded) {
        return this.addItems(toBeAdded, InsertionMode.DEFAULT);
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded, InsertionMode insertionMode) {
        return this.itemHandler != null ? this.itemHandler.addItems(toBeAdded, insertionMode) : toBeAdded;
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        return this.simulateAdd(toBeSimulated, InsertionMode.DEFAULT);
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated, InsertionMode insertionMode) {
        return this.itemHandler != null ? this.itemHandler.simulateAdd(toBeSimulated, insertionMode) : toBeSimulated;
    }

    @Override
    public boolean containsItems() {
        return this.itemHandler != null && this.itemHandler.containsItems() || this.containsFluid();
    }

    private boolean containsFluid() {
        FluidTankInfo[] tankInfos;
        if (this.fluidHandler != null && (tankInfos = this.fluidHandler.getTankInfo(this.toAdaptor)) != null) {
            for (FluidTankInfo tankInfo : tankInfos) {
                FluidStack fluid = tankInfo.fluid;
                if (fluid == null || fluid.amount <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IAEStack<?> addStack(IAEStack<?> toBeAdded, InsertionMode insertionMode) {
        if (toBeAdded.getStackSize() < Integer.MAX_VALUE) {
            if (toBeAdded instanceof IAEItemStack) {
                IAEItemStack ais = (IAEItemStack)toBeAdded;
                return AEItemStack.create(this.addItems(ais.getItemStack(), insertionMode));
            }
            if (toBeAdded instanceof IAEFluidStack) {
                IAEFluidStack ifs = (IAEFluidStack)toBeAdded;
                int rest = this.fluidHandler.fill(this.toAdaptor, ifs.getFluidStack(), true);
                if ((long)rest == toBeAdded.getStackSize()) {
                    return null;
                }
                return toBeAdded.setStackSize(toBeAdded.getStackSize() - (long)rest);
            }
        }
        return toBeAdded;
    }

    @Override
    public IAEStack<?> simulateAddStack(IAEStack<?> toBeSimulated, InsertionMode insertionMode) {
        if (toBeSimulated.getStackSize() < Integer.MAX_VALUE) {
            if (toBeSimulated instanceof IAEItemStack) {
                IAEItemStack ais = (IAEItemStack)toBeSimulated;
                return AEItemStack.create(this.simulateAdd(ais.getItemStack(), insertionMode));
            }
            if (toBeSimulated instanceof IAEFluidStack) {
                IAEFluidStack ifs = (IAEFluidStack)toBeSimulated;
                int rest = this.fluidHandler.fill(this.toAdaptor, ifs.getFluidStack(), false);
                if ((long)rest == toBeSimulated.getStackSize()) {
                    return null;
                }
                return toBeSimulated.setStackSize(toBeSimulated.getStackSize() - (long)rest);
            }
        }
        return toBeSimulated;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        FluidTankInfo[] info = null;
        if (this.fluidHandler != null) {
            info = this.fluidHandler.getTankInfo(this.toAdaptor);
        }
        if (info == null) {
            info = new FluidTankInfo[]{};
        }
        return new SlotIterator(info, this.itemHandler != null ? this.itemHandler.iterator() : Collections.emptyIterator());
    }

    private static class SlotIterator
    implements Iterator<ItemSlot> {
        private final FluidTankInfo[] tanks;
        private final Iterator<ItemSlot> itemSlots;
        private int nextSlotIndex = 0;

        SlotIterator(FluidTankInfo[] tanks, Iterator<ItemSlot> itemSlots) {
            this.tanks = tanks;
            this.itemSlots = itemSlots;
        }

        @Override
        public boolean hasNext() {
            return this.itemSlots.hasNext() || this.nextSlotIndex < this.tanks.length;
        }

        @Override
        public ItemSlot next() {
            if (Platform.isAE2FCLoaded && this.nextSlotIndex < this.tanks.length) {
                FluidStack fluid = this.tanks[this.nextSlotIndex].fluid;
                ItemSlot slot = new ItemSlot();
                slot.setSlot(this.nextSlotIndex++);
                slot.setItemStack(fluid != null ? ItemFluidPacket.newStack((FluidStack)fluid) : null);
                slot.setExtractable(false);
                return slot;
            }
            ItemSlot slot = this.itemSlots.next();
            slot.setSlot(this.nextSlotIndex++);
            return slot;
        }
    }
}

