/*
 * Decompiled with CFR 0.152.
 */
package appeng.transformer.asm;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class ASMTweaker
implements IClassTransformer {
    private static final String[] EXCEPTIONS = new String[0];
    private final Multimap<String, PublicLine> privateToPublicMethods = HashMultimap.create();

    public ASMTweaker() {
        this.privateToPublicMethods.put((Object)"net.minecraft.client.gui.inventory.GuiContainer", (Object)new PublicLine("func_146977_a", "(Lnet/minecraft/inventory/Slot;)V"));
        this.privateToPublicMethods.put((Object)"net.minecraft.client.gui.inventory.GuiContainer", (Object)new PublicLine("a", "(Lzk;)V"));
        this.privateToPublicMethods.put((Object)"appeng.tile.AEBaseTile", (Object)new PublicLine("writeToNBT", "(Lnet/minecraft/nbt/NBTTagCompound;)V"));
        this.privateToPublicMethods.put((Object)"appeng.tile.AEBaseTile", (Object)new PublicLine("func_145841_b", "(Lnet/minecraft/nbt/NBTTagCompound;)V"));
        this.privateToPublicMethods.put((Object)"appeng.tile.AEBaseTile", (Object)new PublicLine("b", "(Ldh;)V"));
        this.privateToPublicMethods.put((Object)"appeng.tile.AEBaseTile", (Object)new PublicLine("readFromNBT", "(Lnet/minecraft/nbt/NBTTagCompound;)V"));
        this.privateToPublicMethods.put((Object)"appeng.tile.AEBaseTile", (Object)new PublicLine("func_145839_a", "(Lnet/minecraft/nbt/NBTTagCompound;)V"));
        this.privateToPublicMethods.put((Object)"appeng.tile.AEBaseTile", (Object)new PublicLine("a", "(Ldh;)V"));
    }

    @Nullable
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        try {
            if (transformedName != null && this.privateToPublicMethods.containsKey((Object)transformedName)) {
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(basicClass);
                classReader.accept((ClassVisitor)classNode, 0);
                for (PublicLine set : this.privateToPublicMethods.get((Object)transformedName)) {
                    this.makePublic(classNode, set);
                }
                if (transformedName.equals("net.minecraft.client.gui.inventory.GuiContainer")) {
                    for (MethodNode mn : classNode.methods) {
                        if (!mn.name.equals("func_146977_a") && (!mn.name.equals("a") || !mn.desc.equals("(Lzk;)V"))) continue;
                        MethodNode newNode = new MethodNode(1, "func_146977_a_original", mn.desc, mn.signature, EXCEPTIONS);
                        newNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        newNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        newNode.instructions.add((AbstractInsnNode)new MethodInsnNode(183, classNode.name, mn.name, mn.desc, false));
                        newNode.instructions.add((AbstractInsnNode)new InsnNode(177));
                        this.log(newNode.name + newNode.desc + " - New Method");
                        classNode.methods.add(newNode);
                        break;
                    }
                    block4: for (MethodNode mn : classNode.methods) {
                        if (!mn.name.equals("func_73863_a") && !mn.name.equals("drawScreen") && (!mn.name.equals("a") || !mn.desc.equals("(IIF)V"))) continue;
                        for (AbstractInsnNode in : mn.instructions) {
                            if (in.getOpcode() != 183) continue;
                            MethodInsnNode n = (MethodInsnNode)in;
                            if (!n.name.equals("func_146977_a") && (!n.name.equals("a") || !n.desc.equals("(Lzk;)V"))) continue;
                            this.log(n.name + n.desc + " - Invoke Virtual");
                            mn.instructions.insertBefore((AbstractInsnNode)n, (AbstractInsnNode)new MethodInsnNode(182, n.owner, n.name, n.desc, false));
                            mn.instructions.remove(in);
                            continue block4;
                        }
                    }
                }
                ClassWriter writer = new ClassWriter(1);
                classNode.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return basicClass;
    }

    private void makePublic(ClassNode classNode, PublicLine set) {
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(set.name) || !mn.desc.equals(set.desc)) continue;
            mn.access = mn.access & 0xFFFFFFE9 | 1;
            this.log(mn.name + mn.desc + " - Transformed");
        }
    }

    private void log(String string) {
        FMLRelaunchLog.log((String)"AE2-CORE", (Level)Level.INFO, (String)string, (Object[])new Object[0]);
    }

    private static final class PublicLine {
        private final String name;
        private final String desc;

        public PublicLine(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }
}

