/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Upgrades;
import appeng.api.exceptions.AppEngException;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.items.storage.ItemVoidStorageCell;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.NullInventory;
import appeng.util.item.AEItemStack;
import appeng.util.prioitylist.FuzzyPriorityList;
import appeng.util.prioitylist.OreFilteredList;
import appeng.util.prioitylist.PrecisePriorityList;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class VoidCellInventory
extends MEInventoryHandler<IAEItemStack> {
    private final boolean fuzzy;

    protected VoidCellInventory(ItemStack o) throws AppEngException {
        super(new NullInventory(), StorageChannel.ITEMS);
        Item item;
        if (o == null || !((item = o.func_77973_b()) instanceof ItemVoidStorageCell)) {
            throw new AppEngException("ItemStack was used as a void cell, but was not a void cell!");
        }
        ItemVoidStorageCell cell = (ItemVoidStorageCell)item;
        IInventory upgrades = cell.getUpgradesInventory(o);
        IInventory config = cell.getConfigInventory(o);
        FuzzyMode fzMode = cell.getFuzzyMode(o);
        String filter = cell.getOreFilter(o);
        boolean hasInverter = false;
        boolean hasFuzzy = false;
        boolean hasOreFilter = false;
        boolean hasSticky = false;
        block6: for (int x = 0; x < upgrades.func_70302_i_(); ++x) {
            Upgrades u;
            ItemStack is = upgrades.func_70301_a(x);
            if (is == null || !(is.func_77973_b() instanceof IUpgradeModule) || (u = ((IUpgradeModule)is.func_77973_b()).getType(is)) == null) continue;
            switch (u) {
                case FUZZY: {
                    hasFuzzy = true;
                    continue block6;
                }
                case INVERTER: {
                    hasInverter = true;
                    continue block6;
                }
                case ORE_FILTER: {
                    hasOreFilter = true;
                    continue block6;
                }
                case STICKY: {
                    hasSticky = true;
                    continue block6;
                }
            }
        }
        if (hasSticky) {
            this.setSticky(true);
        }
        this.fuzzy = hasFuzzy;
        this.setWhitelist(hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
        if (hasOreFilter && !filter.isEmpty()) {
            this.setPartitionList(new OreFilteredList(filter));
        } else {
            IItemList<IAEItemStack> priorityList = AEApi.instance().storage().createItemList();
            for (int x = 0; x < config.func_70302_i_(); ++x) {
                ItemStack is = config.func_70301_a(x);
                if (is == null) continue;
                priorityList.add(AEItemStack.create(is));
            }
            if (!priorityList.isEmpty()) {
                if (hasFuzzy) {
                    this.setPartitionList(new FuzzyPriorityList<IAEItemStack>(priorityList, fzMode));
                } else {
                    this.setPartitionList(new PrecisePriorityList<IAEItemStack>(priorityList));
                }
            }
        }
    }

    public static IMEInventoryHandler<IAEItemStack> getCell(ItemStack o) {
        try {
            return new VoidCellInventory(o);
        }
        catch (AppEngException e) {
            return null;
        }
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
        return this.canAccept(input) ? null : input;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        return null;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out, int iteration) {
        return out;
    }

    @Override
    public IAEItemStack getAvailableItem(@Nonnull IAEItemStack request, int iteration) {
        return null;
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.WRITE;
    }

    @Override
    public boolean canAccept(IAEItemStack input) {
        if (this.getWhitelist() == IncludeExclude.BLACKLIST && this.getPartitionList().isListed(input)) {
            return false;
        }
        if (this.getPartitionList().isEmpty() || this.getWhitelist() == IncludeExclude.BLACKLIST) {
            return true;
        }
        return this.getPartitionList().isListed(input);
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean isPreformatted() {
        return !this.getPartitionList().isEmpty();
    }

    public boolean isFuzzy() {
        return this.fuzzy;
    }
}

