/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMENetworkInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemContainer;
import appeng.api.storage.data.IItemList;
import appeng.me.cache.SecurityCache;
import appeng.util.SortedArrayList;
import appeng.util.inv.ItemListIgnoreCrafting;
import appeng.util.item.NetworkItemList;
import appeng.util.item.PrioritizedNetworkItemList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

public class NetworkInventoryHandler<T extends IAEStack<T>>
implements IMENetworkInventory<T> {
    private static final ThreadLocal<LinkedList> DEPTH_MOD = new ThreadLocal();
    private static final ThreadLocal<LinkedList> DEPTH_SIM = new ThreadLocal();
    private static final Comparator<IMEInventoryHandler<?>> CRAFTING_STICKY_PRIORITY_PLACEMENT_PASS_SORTER = (o1, o2) -> {
        boolean o1ValidFor1;
        int result = Boolean.compare(o2.isAutoCraftingInventory(), o1.isAutoCraftingInventory());
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(o2.getSticky(), o1.getSticky());
        if (result != 0) {
            return result;
        }
        result = Integer.compare(o2.getPriority(), o1.getPriority());
        if (result != 0) {
            return result;
        }
        boolean o2ValidFor1 = o2.validForPass(1);
        result = Boolean.compare(o2ValidFor1, o1ValidFor1 = o1.validForPass(1));
        if (result != 0) {
            return result;
        }
        boolean o2ValidFor2 = o2.validForPass(2);
        boolean o1ValidFor2 = o1.validForPass(2);
        return Boolean.compare(o2ValidFor2, o1ValidFor2);
    };
    private final StorageChannel myChannel;
    private final SecurityCache security;
    private final List<IMEInventoryHandler<T>> priorityInventory;
    private int myPass = 0;
    private NetworkItemList<T> iterationItems = null;
    private PrioritizedNetworkItemList<T> prioritizedIterationItems = null;

    public NetworkInventoryHandler(StorageChannel chan, SecurityCache security) {
        this.myChannel = chan;
        this.security = security;
        this.priorityInventory = new SortedArrayList(CRAFTING_STICKY_PRIORITY_PLACEMENT_PASS_SORTER);
    }

    public void addNewStorage(IMEInventoryHandler<T> h) {
        this.priorityInventory.add(h);
    }

    @Override
    public T injectItems(T input, Actionable type, BaseActionSource src) {
        IMEInventoryHandler<T> inv;
        int i;
        if (this.diveList(this, type)) {
            return input;
        }
        if (this.testPermission(src, SecurityPermissions.INJECT)) {
            this.surface(this, type);
            return input;
        }
        List<IMEInventoryHandler<T>> priorityInventory = this.priorityInventory;
        int size = priorityInventory.size();
        boolean stickyInventoryFound = false;
        for (i = 0; i < size && input != null && ((inv = priorityInventory.get(i)).getSticky() || inv.isAutoCraftingInventory()); ++i) {
            if (!inv.canAccept(input) || !inv.isPrioritized(input) && inv.extractItems(input, Actionable.SIMULATE, src) == null) continue;
            input = inv.injectItems(input, type, src);
            if (stickyInventoryFound || !inv.getSticky()) continue;
            stickyInventoryFound = true;
        }
        if (stickyInventoryFound || input == null || i >= size) {
            this.surface(this, type);
            return input;
        }
        inv = priorityInventory.get(i);
        int lastPriority = inv.getPriority();
        block1: while (true) {
            boolean prioritySwitch;
            int passTwoIndex = -1;
            do {
                boolean canAcceptInput = true;
                boolean validForPass1 = inv.validForPass(1);
                if (validForPass1 && (canAcceptInput = inv.canAccept(input)) && (inv.isPrioritized(input) || inv.extractItems(input, Actionable.SIMULATE, src) != null) && (input = inv.injectItems(input, type, src)) == null) break block1;
                if (canAcceptInput && passTwoIndex == -1 && inv.validForPass(2)) {
                    passTwoIndex = i;
                    if (!validForPass1) break;
                }
                if (++i >= size) {
                    if (passTwoIndex == -1) {
                        break block1;
                    }
                    break;
                }
                inv = priorityInventory.get(i);
                int priority = inv.getPriority();
                prioritySwitch = lastPriority != priority;
                lastPriority = priority;
            } while (!prioritySwitch);
            if (passTwoIndex == -1) continue;
            i = passTwoIndex;
            inv = priorityInventory.get(i);
            lastPriority = inv.getPriority();
            while ((!inv.canAccept(input) || inv.isPrioritized(input) || (input = inv.injectItems(input, type, src)) != null) && ++i < size) {
                inv = priorityInventory.get(i);
                int priority = inv.getPriority();
                boolean prioritySwitch2 = lastPriority != priority;
                lastPriority = priority;
                if (!prioritySwitch2) continue;
                continue block1;
            }
            break;
        }
        this.surface(this, type);
        return input;
    }

    private boolean diveList(NetworkInventoryHandler<T> networkInventoryHandler, Actionable type) {
        LinkedList cDepth = this.getDepth(type);
        if (cDepth.contains(networkInventoryHandler)) {
            return true;
        }
        cDepth.push(this);
        return false;
    }

    private boolean testPermission(BaseActionSource src, SecurityPermissions permission) {
        if (src.isPlayer()) {
            if (!this.security.hasPermission(((PlayerSource)src).player, permission)) {
                return true;
            }
        } else if (src.isMachine() && this.security.isAvailable()) {
            IGridNode n = ((MachineSource)src).via.getActionableNode();
            if (n == null) {
                return true;
            }
            IGrid gn = n.getGrid();
            if (gn != this.security.getGrid()) {
                int playerID;
                ISecurityGrid sg = (ISecurityGrid)gn.getCache(ISecurityGrid.class);
                int n2 = playerID = sg.isAvailable() ? sg.getOwner() : n.getPlayerID();
                if (!this.security.hasPermission(playerID, permission)) {
                    return true;
                }
            }
        }
        return false;
    }

    private void surface(NetworkInventoryHandler<T> networkInventoryHandler, Actionable type) {
        if (this.getDepth(type).pop() != this) {
            throw new IllegalStateException("Invalid Access to Networked Storage API detected.");
        }
    }

    private LinkedList getDepth(Actionable type) {
        ThreadLocal<LinkedList> depth = type == Actionable.MODULATE ? DEPTH_MOD : DEPTH_SIM;
        LinkedList s = depth.get();
        if (s == null) {
            s = new LinkedList();
            depth.set(s);
        }
        return s;
    }

    @Override
    public T extractItems(T request, Actionable mode, BaseActionSource src) {
        if (this.diveList(this, mode)) {
            return null;
        }
        if (this.testPermission(src, SecurityPermissions.EXTRACT)) {
            this.surface(this, mode);
            return null;
        }
        Object output = request.copy();
        request = request.copy();
        output.setStackSize(0L);
        long req = request.getStackSize();
        List<IMEInventoryHandler<T>> priorityInventory = this.priorityInventory;
        int size = priorityInventory.size();
        for (int i = size - 1; i >= 0 && output.getStackSize() < req; --i) {
            IMEInventoryHandler<T> inv = priorityInventory.get(i);
            request.setStackSize(req - output.getStackSize());
            output.add((Object)inv.extractItems(request, mode, src));
        }
        this.surface(this, mode);
        if (output.getStackSize() <= 0L) {
            return null;
        }
        return (T)output;
    }

    @Override
    public IItemList<T> getAvailableItems(IItemList out, int iteration) {
        if (this.diveIteration(this, Actionable.SIMULATE, iteration)) {
            return this.iterationItems == null ? out : this.iterationItems;
        }
        boolean isIgnoreCrafting = out instanceof ItemListIgnoreCrafting;
        boolean isSource = this.getDepth(Actionable.SIMULATE).size() == 1;
        NetworkItemList<T> networkItemList = new NetworkItemList<T>(this, () -> this.getChannel().createList());
        this.iterationItems = networkItemList;
        IItemList<T> currentNetworkItemList = isIgnoreCrafting ? new ItemListIgnoreCrafting<T>(this.getPrimitiveItemList()) : this.getPrimitiveItemList();
        List<IMEInventoryHandler<T>> priorityInventory = this.priorityInventory;
        int size = priorityInventory.size();
        for (int i = 0; i < size; ++i) {
            IMEInventoryHandler<T> inv = priorityInventory.get(i);
            IMENetworkInventory<T> externalNetworkInventory = inv.getExternalNetworkInventory();
            if (externalNetworkInventory == this) continue;
            IItemList<T> passedInList = this.getPrimitiveItemList();
            IItemList<T> passedOutList = inv.getAvailableItems(passedInList, iteration);
            if (externalNetworkInventory != null && passedOutList instanceof NetworkItemList) {
                networkItemList.addNetworkItems(externalNetworkInventory, passedOutList);
                continue;
            }
            for (IAEStack item : passedOutList) {
                currentNetworkItemList.add(item);
            }
        }
        networkItemList.addNetworkItems(this, currentNetworkItemList);
        this.surface(this, Actionable.SIMULATE);
        return isSource ? networkItemList.buildFinalItemList(out) : networkItemList;
    }

    private IItemList<T> getPrimitiveItemList() {
        return this.getChannel() == StorageChannel.ITEMS ? AEApi.instance().storage().createPrimitiveItemList() : AEApi.instance().storage().createFluidList();
    }

    @Override
    public PrioritizedNetworkItemList<T> getAvailableItemsWithPriority(int iteration) {
        if (this.diveIteration(this, Actionable.SIMULATE, iteration)) {
            return this.prioritizedIterationItems;
        }
        PrioritizedNetworkItemList networkItemList = new PrioritizedNetworkItemList(this);
        this.prioritizedIterationItems = networkItemList;
        boolean isSource = this.getDepth(Actionable.SIMULATE).size() == 1;
        IItemContainer currentPriorityItemList = null;
        SortedArrayList<IMEInventoryHandler> priorityInventory = new SortedArrayList<IMEInventoryHandler>(Comparator.comparing(e -> e.getPriority()).reversed());
        priorityInventory.addAll(this.priorityInventory);
        int size = priorityInventory.size();
        Integer lastPriority = null;
        for (int i = 0; i < size; ++i) {
            IMEInventoryHandler inv = (IMEInventoryHandler)priorityInventory.get(i);
            IMENetworkInventory externalNetworkInventory = inv.getExternalNetworkInventory();
            if (externalNetworkInventory == this) continue;
            if (lastPriority == null || lastPriority.intValue() != inv.getPriority()) {
                if (lastPriority != null && !currentPriorityItemList.isEmpty()) {
                    networkItemList.addNetworkItems(this, lastPriority, currentPriorityItemList);
                }
                lastPriority = inv.getPriority();
                IItemContainer<T> iItemContainer = currentPriorityItemList = isSource ? new ItemListIgnoreCrafting<T>(this.getPrimitiveItemList()) : this.getPrimitiveItemList();
            }
            if (externalNetworkInventory != null) {
                PrioritizedNetworkItemList passedOutList = inv.getAvailableItemsWithPriority(iteration);
                networkItemList.addNetworkItems(externalNetworkInventory, inv.getPriority(), passedOutList);
                continue;
            }
            IItemList<T> passedInList = this.getPrimitiveItemList();
            IItemList<T> passedOutList = inv.getAvailableItems(passedInList, iteration);
            for (IAEStack item : passedOutList) {
                currentPriorityItemList.add(item);
            }
        }
        if (currentPriorityItemList != null && !currentPriorityItemList.isEmpty()) {
            networkItemList.addNetworkItems(this, lastPriority, currentPriorityItemList);
        }
        this.surface(this, Actionable.SIMULATE);
        return networkItemList;
    }

    @Override
    public T getAvailableItem(@Nonnull T request, int iteration) {
        int i;
        long count = 0L;
        List<IMEInventoryHandler<T>> priorityInventory = this.priorityInventory;
        int size = priorityInventory.size();
        boolean readsFromOtherNetwork = false;
        for (i = 0; i < size; ++i) {
            if (priorityInventory.get(i).getExternalNetworkInventory() == null) continue;
            readsFromOtherNetwork = true;
            break;
        }
        if (readsFromOtherNetwork) {
            T stack = this.getAvailableItems((IItemList)this.getPrimitiveItemList(), iteration).findPrecise(request);
            count = this.addStackCount(stack, count);
        } else {
            IMEInventoryHandler<T> j;
            T stack;
            if (this.diveIteration(this, Actionable.SIMULATE, iteration)) {
                return null;
            }
            for (i = 0; i < size && (count = this.addStackCount(stack = (j = priorityInventory.get(i)).getAvailableItem(request, iteration), count)) != Long.MAX_VALUE; ++i) {
            }
            this.surface(this, Actionable.SIMULATE);
        }
        return count == 0L ? null : (T)request.copy().setStackSize(count);
    }

    private long addStackCount(T stack, long count) {
        if (stack != null && stack.getStackSize() > 0L && (count += stack.getStackSize()) < 0L) {
            count = Long.MAX_VALUE;
        }
        return count;
    }

    private boolean diveIteration(NetworkInventoryHandler<T> networkInventoryHandler, Actionable type, int iteration) {
        if (iteration == this.myPass) {
            return true;
        }
        this.myPass = iteration;
        this.getDepth(type).push(this);
        return false;
    }

    @Override
    public Collection<T> getSortedFuzzyItems(Collection<T> out, T fuzzyItem, FuzzyMode fuzzyMode, int iteration) {
        if (this.diveIteration(this, Actionable.SIMULATE, iteration)) {
            return out;
        }
        List<IMEInventoryHandler<T>> priorityInventory = this.priorityInventory;
        int size = priorityInventory.size();
        for (int i = size - 1; i >= 0; --i) {
            IItemList<T> inv;
            IMEInventoryHandler<T> invObject = priorityInventory.get(i);
            if (invObject.isAutoCraftingInventory() || (inv = invObject.getAvailableItems(invObject.getChannel().createList(), iteration)).isEmpty()) continue;
            Collection<T> fzlist = inv.findFuzzy(fuzzyItem, fuzzyMode);
            out.addAll(fzlist);
        }
        this.surface(this, Actionable.SIMULATE);
        return out;
    }

    @Override
    public StorageChannel getChannel() {
        return this.myChannel;
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(T input) {
        return false;
    }

    @Override
    public boolean canAccept(T input) {
        return true;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }
}

