/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.HasServerSideToolLogic;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.implementations.items.IAEWrench;
import appeng.api.implementations.items.INetworkToolItem;
import appeng.api.networking.IGridHost;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.INetworkToolAgent;
import appeng.client.ClientHelper;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerNetworkStatus;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketClick;
import appeng.integration.IntegrationType;
import appeng.items.AEBaseItem;
import appeng.items.contents.NetworkToolViewer;
import appeng.transformer.annotations.Integration;
import appeng.util.Platform;
import buildcraft.api.tools.IToolWrench;
import cofh.api.item.IToolHammer;
import com.google.common.base.Optional;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

@Integration.InterfaceList(value={@Integration.Interface(iface="cofh.api.item.IToolHammer", iname=IntegrationType.CoFHWrench), @Integration.Interface(iface="buildcraft.api.tools.IToolWrench", iname=IntegrationType.BuildCraftCore)})
public class ToolNetworkTool
extends AEBaseItem
implements IGuiItem,
IAEWrench,
IToolWrench,
IToolHammer,
HasServerSideToolLogic,
INetworkToolItem {
    public ToolNetworkTool() {
        super((Optional<String>)Optional.absent());
        this.setFeature(EnumSet.of(AEFeature.NetworkTool));
        this.func_77625_d(1);
        this.setHarvestLevel("wrench", 0);
    }

    @Override
    public IGuiItemObject getGuiObject(ItemStack is, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return new NetworkToolViewer(is, (IGridHost)(te instanceof IGridHost ? te : null), this.getInventorySize());
    }

    public ItemStack func_77659_a(ItemStack it, World w, EntityPlayer p) {
        if (Platform.isServer()) {
            return it;
        }
        MovingObjectPosition mop = ClientHelper.proxy.getMOP();
        if (mop != null) {
            int i = mop.field_72311_b;
            int j = mop.field_72312_c;
            int k = mop.field_72309_d;
            if (w.func_147439_a(i, j, k).isAir((IBlockAccess)w, i, j, k)) {
                this.onItemUseFirst(it, p, w, 0, 0, 0, -1, 0.0f, 0.0f, 0.0f);
            }
        } else {
            this.onItemUseFirst(it, p, w, 0, 0, 0, -1, 0.0f, 0.0f, 0.0f);
        }
        return it;
    }

    private boolean isPlayerInteractionCanceled(Block block, EntityPlayer player, World world, int x, int y, int z, int side) {
        PlayerInteractEvent.Action action = block.isAir((IBlockAccess)world, x, y, z) ? PlayerInteractEvent.Action.RIGHT_CLICK_AIR : PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK;
        PlayerInteractEvent event = ForgeEventFactory.onPlayerInteract((EntityPlayer)player, (PlayerInteractEvent.Action)action, (int)x, (int)y, (int)z, (int)side, (World)world);
        return event.isCanceled();
    }

    public boolean onItemUseFirst(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        INetworkToolAgent nta;
        if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)is, (int)1) <= 0) {
            return true;
        }
        Block blk = world.func_147439_a(x, y, z);
        if (blk != null && this.isPlayerInteractionCanceled(blk, player, world, x, y, z, side)) {
            return true;
        }
        MovingObjectPosition mop = new MovingObjectPosition(x, y, z, side, Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ));
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IPartHost) {
            INetworkToolAgent nta2;
            IPartHost host = (IPartHost)te;
            SelectedPart part = host.selectPart(mop.field_72307_f);
            IPart iPart = part.part;
            if (iPart instanceof INetworkToolAgent && !(nta2 = (INetworkToolAgent)((Object)iPart)).showNetworkInfo(mop)) {
                return false;
            }
        } else if (te instanceof INetworkToolAgent && !(nta = (INetworkToolAgent)te).showNetworkInfo(mop)) {
            return false;
        }
        if (Platform.isClient()) {
            NetworkHandler.instance.sendToServer(new PacketClick(x, y, z, side, hitX, hitY, hitZ));
        }
        return true;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    protected void openToolGui(EntityPlayer p) {
        Platform.openGUI(p, null, ForgeDirection.UNKNOWN, GuiBridge.GUI_NETWORK_TOOL);
    }

    @Override
    public boolean serverSideToolLogic(ItemStack is, EntityPlayer p, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (side < 0) {
            this.openToolGui(p);
            return false;
        }
        if (!Platform.hasPermissions(new DimensionalCoord(w, x, y, z), p)) {
            return false;
        }
        Block b = w.func_147439_a(x, y, z);
        if (b == null) {
            return false;
        }
        if (this.isPlayerInteractionCanceled(b, p, w, x, y, z, side)) {
            return false;
        }
        if (!p.func_70093_af()) {
            TileEntity te = w.func_147438_o(x, y, z);
            if (!(te instanceof IGridHost) && b.rotateBlock(w, x, y, z, ForgeDirection.getOrientation((int)side))) {
                b.func_149695_a(w, x, y, z, Platform.AIR_BLOCK);
                p.func_71038_i();
                return !w.field_72995_K;
            }
            if (p.field_71070_bA instanceof ContainerNetworkStatus) {
                b.func_149727_a(w, x, y, z, p, side, 0.0f, 0.0f, 0.0f);
            }
            if (p.field_71070_bA instanceof AEBaseContainer) {
                return true;
            }
            if (te instanceof IGridHost) {
                Platform.openGUI(p, te, ForgeDirection.getOrientation((int)side), GuiBridge.GUI_NETWORK_STATUS);
            } else {
                this.openToolGui(p);
            }
            return true;
        }
        b.func_149727_a(w, x, y, z, p, side, hitX, hitY, hitZ);
        return false;
    }

    @Override
    public boolean canWrench(ItemStack is, EntityPlayer player, int x, int y, int z) {
        return true;
    }

    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        return true;
    }

    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
        player.func_71038_i();
    }

    public boolean isUsable(ItemStack itemStack, EntityLivingBase entityLivingBase, int x, int y, int z) {
        return true;
    }

    public void toolUsed(ItemStack itemStack, EntityLivingBase entity, int x, int y, int z) {
        entity.func_71038_i();
    }

    @Override
    public int getInventorySize() {
        return 3;
    }
}

