/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.NEIHelpers;

import appeng.api.config.TerminalFontSize;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.client.render.StackSizeRenderer;
import appeng.core.localization.GuiText;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.IUsageHandler;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class NEIPatternViewHandler
implements IUsageHandler {
    private static final ResourceLocation SLOT_TEXTURE_LOCATION = new ResourceLocation("nei", "textures/slot.png");
    private static final ResourceLocation ARROW_TEXTURE = new ResourceLocation("textures/gui/container/crafting_table.png");
    private static final int OFFSET_X = 10;
    private static final int INFO_OFFSET_Y = 8;
    private static final int SLOTS_OFFSET_Y = 8 + Minecraft.func_71410_x().field_71466_p.field_78288_b + 5;
    private static final int TEXT_COLOR = 0x404040;
    private static final int CRAFTING_INPUTS_COLS = 3;
    private static final int CRAFTING_INPUTS_ROWS = 3;
    private static final int CRAFTING_OUTPUTS_COLS = 1;
    private static final int CRAFTING_OUTPUTS_ROWS = 1;
    private static final int PROCESSING_INPUTS_COLS = 4;
    private static final int PROCESSING_INPUTS_ROWS = 8;
    private static final int PROCESSING_OUTPUTS_COLS = 1;
    private static final int PROCESSING_OUTPUTS_ROWS = 8;
    private static final int REVERSED_INPUTS_COLS = 1;
    private static final int REVERSED_INPUTS_ROWS = 8;
    private static final int REVERSED_OUTPUTS_COLS = 4;
    private static final int REVERSED_OUTPUTS_ROWS = 8;
    private static final int ARROW_TEXTURE_X = 91;
    private static final int ARROW_TEXTURE_Y = 35;
    private static final int ARROW_TEXTURE_WIDTH = 22;
    private static final int ARROW_TEXTURE_HEIGHT = 15;
    private static final int ARROW_DRAW_WIDTH = 22;
    private static final int ARROW_DRAW_HEIGHT = 15;
    private static final double ARROW_OFFSET_X = 5.0;
    private static final double ARROW_OFFSET_Y = 8.5;
    private int inputsCols;
    private int inputsRows;
    private int inputsOffsetX;
    private int outputsCols;
    private int outputsRows;
    private int outputsOffsetX;
    private int arrowOffsetX;
    private int arrowCenterY;
    private int craftingOutputY = SLOTS_OFFSET_Y;
    private final ArrayList<PatternSlot> inputSlots = new ArrayList();
    private final ArrayList<PatternSlot> outputSlots = new ArrayList();
    private ICraftingPatternDetails patternDetails;

    public IUsageHandler getUsageHandler(String inputId, Object ... ingredients) {
        Object object;
        if (ingredients.length == 0 || !((object = ingredients[0]) instanceof ItemStack)) {
            return null;
        }
        ItemStack ingredient = (ItemStack)object;
        Item item = ingredient.func_77973_b();
        if (!(item instanceof ICraftingPatternItem)) {
            return null;
        }
        ICraftingPatternItem patternItem = (ICraftingPatternItem)item;
        this.patternDetails = patternItem.getPatternForItem(ingredient, (World)Minecraft.func_71410_x().field_71441_e);
        if (this.patternDetails == null) {
            return null;
        }
        this.initializeLayout();
        this.initializeSlots();
        return this;
    }

    private void initializeLayout() {
        boolean isCraftable = this.patternDetails.isCraftable();
        List<IAEItemStack> aeOutputs = this.getFilteredStacks(this.patternDetails.getAEOutputs());
        int nonNullOutputs = (int)aeOutputs.stream().filter(Objects::nonNull).count();
        if (isCraftable) {
            this.setupCraftingLayout();
        } else if (nonNullOutputs > 8) {
            this.setupReversedLayout();
        } else {
            this.setupProcessingLayout();
        }
    }

    private void setupCraftingLayout() {
        this.inputsCols = 3;
        this.inputsRows = 3;
        this.outputsCols = 1;
        this.outputsRows = 1;
        this.inputsOffsetX = 10;
        this.arrowOffsetX = this.inputsOffsetX + this.inputsCols * 18 + 10;
        this.arrowCenterY = SLOTS_OFFSET_Y + this.inputsRows * 18 / 2 - 16;
        this.outputsOffsetX = this.arrowOffsetX + 32 + 10;
        this.craftingOutputY = this.arrowCenterY + 8;
    }

    private void setupReversedLayout() {
        this.inputsCols = 1;
        this.inputsRows = 8;
        this.outputsCols = 4;
        this.outputsRows = 8;
        this.inputsOffsetX = 20;
        this.arrowOffsetX = this.inputsOffsetX + this.inputsCols * 18 + 8;
        this.arrowCenterY = SLOTS_OFFSET_Y + this.inputsRows * 18 / 2 - 16;
        this.outputsOffsetX = this.inputsOffsetX + this.inputsCols * 18 + 50;
    }

    private void setupProcessingLayout() {
        this.inputsCols = 4;
        this.inputsRows = 8;
        this.outputsCols = 1;
        this.outputsRows = 8;
        this.inputsOffsetX = 10;
        this.arrowOffsetX = this.inputsOffsetX + this.inputsCols * 18 + 4;
        this.arrowCenterY = SLOTS_OFFSET_Y + this.inputsRows * 18 / 2 - 16;
        this.outputsOffsetX = this.inputsOffsetX + this.inputsCols * 18 + 40;
    }

    private void initializeSlots() {
        this.inputSlots.clear();
        this.outputSlots.clear();
        List<IAEItemStack> aeInputs = this.getFilteredStacks(this.patternDetails.getAEInputs());
        List<IAEItemStack> aeOutputs = this.getFilteredStacks(this.patternDetails.getAEOutputs());
        this.populateInputSlots(aeInputs);
        this.populateOutputSlots(aeOutputs);
    }

    private List<IAEItemStack> getFilteredStacks(IAEStack<?>[] stacks) {
        boolean isCraftable = this.patternDetails.isCraftable();
        return Arrays.stream(stacks).filter(stack -> isCraftable || stack != null).map(stack -> stack instanceof IAEItemStack ? (IAEItemStack)stack : null).filter(stack -> isCraftable || stack != null).collect(Collectors.toList());
    }

    private void populateInputSlots(List<IAEItemStack> inputs) {
        for (int i = 0; i < this.inputsCols * this.inputsRows; ++i) {
            IAEItemStack aeInput;
            int row = i / this.inputsCols;
            int col = i % this.inputsCols;
            int x = this.inputsOffsetX + col * 18 + 1;
            int y = SLOTS_OFFSET_Y + row * 18 + 1;
            if (i >= inputs.size() || (aeInput = inputs.get(i)) == null) continue;
            ItemStack inputStack = aeInput.getItemStack().func_77946_l();
            inputStack.field_77994_a = 1;
            PositionedStack posStack = this.createPositionedStack(inputStack, x, y);
            this.inputSlots.add(new PatternSlot(posStack, aeInput.getStackSize()));
        }
    }

    private void populateOutputSlots(List<IAEItemStack> outputs) {
        for (int i = 0; i < this.outputsCols * this.outputsRows; ++i) {
            IAEItemStack aeOutput;
            int y;
            int row = i / this.outputsCols;
            int col = i % this.outputsCols;
            int x = this.outputsOffsetX + col * 18 + 1;
            int n = y = this.patternDetails.isCraftable() && i == 0 ? this.craftingOutputY + 1 : SLOTS_OFFSET_Y + row * 18 + 1;
            if (i >= outputs.size() || (aeOutput = outputs.get(i)) == null) continue;
            ItemStack outputStack = aeOutput.getItemStack().func_77946_l();
            outputStack.field_77994_a = 1;
            PositionedStack posStack = this.createPositionedStack(outputStack, x, y);
            this.outputSlots.add(new PatternSlot(posStack, aeOutput.getStackSize()));
        }
    }

    private PositionedStack createPositionedStack(ItemStack stack, int x, int y) {
        ItemStack stackCopy = stack.func_77946_l();
        PositionedStack posStack = new PositionedStack((Object)stackCopy, x, y);
        posStack.items = new ItemStack[]{stackCopy};
        return posStack;
    }

    public String getRecipeName() {
        return GuiText.EncodedPattern.getLocal();
    }

    public int numRecipes() {
        return 1;
    }

    public void drawBackground(int recipe) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(SLOT_TEXTURE_LOCATION);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        this.drawInputSlots(tessellator);
        this.drawOutputSlots(tessellator);
        tessellator.func_78381_a();
        this.drawArrow();
    }

    private void drawInputSlots(Tessellator tessellator) {
        for (int row = 0; row < this.inputsRows; ++row) {
            for (int col = 0; col < this.inputsCols; ++col) {
                this.drawSlot(tessellator, this.inputsOffsetX + col * 18, SLOTS_OFFSET_Y + row * 18);
            }
        }
    }

    private void drawOutputSlots(Tessellator tessellator) {
        for (int row = 0; row < this.outputsRows; ++row) {
            for (int col = 0; col < this.outputsCols; ++col) {
                int x = this.outputsOffsetX + col * 18;
                int y = this.patternDetails.isCraftable() && row == 0 ? this.craftingOutputY : SLOTS_OFFSET_Y + row * 18;
                this.drawSlot(tessellator, x, y);
            }
        }
    }

    private void drawSlot(Tessellator tessellator, int x, int y) {
        tessellator.func_78374_a((double)(x + 18), (double)y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)x, (double)y, 0.0, 0.0, 0.0);
        tessellator.func_78374_a((double)x, (double)(y + 18), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)(x + 18), (double)(y + 18), 0.0, 1.0, 1.0);
    }

    private void drawArrow() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ARROW_TEXTURE);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        double arrowX = (double)this.arrowOffsetX + 5.0;
        double arrowY = (double)this.arrowCenterY + 8.5;
        float uMin = 0.35546875f;
        float uMax = 0.44140625f;
        float vMin = 0.13671875f;
        float vMax = 0.1953125f;
        tessellator.func_78374_a(arrowX + 22.0, arrowY, 0.0, (double)uMax, (double)vMin);
        tessellator.func_78374_a(arrowX, arrowY, 0.0, (double)uMin, (double)vMin);
        tessellator.func_78374_a(arrowX, arrowY + 15.0, 0.0, (double)uMin, (double)vMax);
        tessellator.func_78374_a(arrowX + 22.0, arrowY + 15.0, 0.0, (double)uMax, (double)vMax);
        tessellator.func_78381_a();
    }

    public void drawForeground(int recipe) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String inputs = GuiText.Inputs.getLocal();
        String outputs = GuiText.Outputs.getLocal();
        int inputsCenterX = this.inputsOffsetX + this.inputsCols * 18 / 2 - fontRenderer.func_78256_a(inputs) / 2;
        int outputsCenterX = this.outputsOffsetX + this.outputsCols * 18 / 2 - fontRenderer.func_78256_a(outputs) / 2;
        fontRenderer.func_78276_b(inputs, inputsCenterX, 8, 0x404040);
        fontRenderer.func_78276_b(outputs, outputsCenterX, 8, 0x404040);
        this.drawStackSize(this.inputSlots);
        this.drawStackSize(this.outputSlots);
    }

    private void drawStackSize(ArrayList<PatternSlot> stacks) {
        for (PatternSlot viewStack : stacks) {
            StackSizeRenderer.drawStackSize(viewStack.stack.relx, viewStack.stack.rely, viewStack.stackSize, GuiDraw.fontRenderer, TerminalFontSize.SMALL);
        }
    }

    private void drawStackSizeTooltip(ArrayList<PatternSlot> stacks, ItemStack curStack, List<String> currenttip) {
        stacks.stream().filter(viewStack -> viewStack.stack.item.equals(curStack)).findFirst().ifPresent(viewItemStack -> currenttip.add(1, EnumChatFormatting.GRAY + GuiText.Stored.getLocal() + ": " + NumberFormat.getNumberInstance().format(viewItemStack.stackSize)));
    }

    public List<PositionedStack> getIngredientStacks(int recipe) {
        return Collections.emptyList();
    }

    public List<PositionedStack> getOtherStacks(int recipe) {
        ArrayList<PositionedStack> result = new ArrayList<PositionedStack>(this.inputSlots.size() + this.outputSlots.size());
        result.addAll(this.inputSlots.stream().map(slot -> slot.stack).collect(Collectors.toList()));
        result.addAll(this.outputSlots.stream().map(slot -> slot.stack).collect(Collectors.toList()));
        return result;
    }

    public PositionedStack getResultStack(int recipe) {
        return null;
    }

    public void onUpdate() {
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        return null;
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        return null;
    }

    public int recipiesPerPage() {
        return 1;
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currenttip, int recipe) {
        return currenttip;
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack stack, List<String> currenttip, int recipe) {
        if (stack == null) {
            return currenttip;
        }
        this.drawStackSizeTooltip(this.inputSlots, stack, currenttip);
        this.drawStackSizeTooltip(this.outputSlots, stack, currenttip);
        return currenttip;
    }

    public boolean keyTyped(GuiRecipe<?> gui, char keyChar, int keyCode, int recipe) {
        return false;
    }

    public boolean mouseClicked(GuiRecipe<?> gui, int button, int recipe) {
        return false;
    }

    public int getRecipeHeight(int recipe) {
        int headerHeight = 8 + Minecraft.func_71410_x().field_71466_p.field_78288_b;
        int slotsHeight = this.inputsRows * 18;
        int bottomPadding = 10;
        return headerHeight + slotsHeight + bottomPadding;
    }

    private static class PatternSlot {
        public final PositionedStack stack;
        public long stackSize;

        public PatternSlot(PositionedStack stack, long stackSize) {
            this.stack = stack;
            this.stackSize = stackSize;
        }
    }
}

