/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.localization;

import appeng.core.localization.Localization;
import net.minecraft.util.EnumChatFormatting;

public enum WailaText implements Localization
{
    Crafting,
    DeviceOnline,
    DeviceOffline,
    DeviceMissingChannel,
    P2PUnlinked,
    P2PInputOneOutput,
    P2PInputManyOutputs,
    P2POutput,
    Locked,
    Unlocked,
    Showing,
    CraftingLockedByRedstoneSignal,
    CraftingLockedByLackOfRedstoneSignal,
    CraftingLockedUntilPulse,
    CraftingLockedUntilResult,
    Contains,
    Channels,
    ChannelsUnbound,
    Booting,
    wireless_connected,
    wireless_connected_multiple,
    wireless_connected_detailsTitle,
    wireless_connected_details,
    wireless_notconnected,
    wireless_channels,
    wireless_power,
    wireless_name,
    CoordinateX,
    CoordinateY,
    CoordinateZ,
    Dimension,
    Id,
    ConnectedTo,
    Disconnected,
    Singularity;

    private final String formatedName;

    private WailaText() {
        this.formatedName = this.name().replace("_", ".");
    }

    private WailaText(String name) {
        this.formatedName = name;
    }

    @Override
    public String getUnlocalized() {
        return "waila.appliedenergistics2." + this.formatedName;
    }

    public static String getPowerState(boolean isActive, boolean isPowered, boolean isBooting) {
        if (isBooting) {
            return Booting.getLocal(EnumChatFormatting.GREEN);
        }
        if (isActive && isPowered) {
            return DeviceOnline.getLocal(EnumChatFormatting.GREEN);
        }
        if (isPowered) {
            return DeviceMissingChannel.getLocal(EnumChatFormatting.RED);
        }
        return DeviceOffline.getLocal(EnumChatFormatting.RED);
    }
}

