/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.me;

import appeng.api.AEApi;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.storage.IItemDisplayRegistry;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IDisplayRepo;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.AEConfig;
import appeng.integration.modules.NEI;
import appeng.items.storage.ItemViewCell;
import appeng.util.ItemSorters;
import appeng.util.Platform;
import appeng.util.item.ItemImmutableList;
import appeng.util.item.OreHelper;
import appeng.util.item.OreReference;
import appeng.util.prioitylist.IPartitionList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class ItemRepo
implements IDisplayRepo {
    private final IItemList<IAEItemStack> list = AEApi.instance().storage().createSortedItemList();
    private IAEItemStack[] pinsRepo = new IAEItemStack[0];
    private final ArrayList<IAEItemStack> view = new ArrayList();
    private final ArrayList<ItemStack> dsp = new ArrayList();
    private final IScrollSource src;
    private final ISortSource sortSrc;
    private int rowSize = 9;
    private String searchString = "";
    private Map<IAEItemStack, Boolean> searchCache = new WeakHashMap<IAEItemStack, Boolean>();
    private IPartitionList<IAEItemStack> myPartitionList;
    private boolean hasPower;
    private boolean paused = false;

    public ItemRepo(IScrollSource src, ISortSource sortSrc) {
        this.src = src;
        this.sortSrc = sortSrc;
    }

    @Override
    public void setAEPins(IAEItemStack[] newPins) {
        IItemList<IAEItemStack> oldPins = this.getPinsCache();
        this.pinsRepo = new IAEItemStack[newPins.length];
        for (int i = 0; i < this.pinsRepo.length; ++i) {
            IAEItemStack isToPin = this.list.findPrecise(newPins[i]);
            if (isToPin == null) {
                isToPin = oldPins.findPrecise(newPins[i]);
            }
            if (isToPin != null) {
                this.pinsRepo[i] = isToPin.copy();
                isToPin.reset();
                continue;
            }
            this.pinsRepo[i] = newPins[i];
        }
        for (IAEItemStack ais : oldPins) {
            if (ais.getStackSize() == -1L) continue;
            this.list.add(ais);
        }
        this.updateView();
    }

    private IItemList<IAEItemStack> getPinsCache() {
        IItemList<IAEItemStack> oldPins = AEApi.instance().storage().createItemList();
        for (IAEItemStack pin : this.pinsRepo) {
            if (pin == null) continue;
            oldPins.add(pin);
        }
        return oldPins;
    }

    @Override
    public IAEItemStack getAEPin(int idx) {
        if (idx < 0 || idx >= this.pinsRepo.length) {
            return null;
        }
        return this.pinsRepo[idx];
    }

    @Override
    public IAEItemStack getReferenceItem(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.view.size()) {
            return null;
        }
        return this.view.get(idx);
    }

    @Override
    public ItemStack getItem(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.dsp.size()) {
            return null;
        }
        return this.dsp.get(idx);
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems() {
        IItemList<IAEItemStack> pins = AEApi.instance().storage().createItemList();
        for (IAEItemStack is : this.pinsRepo) {
            if (is == null || is.getStackSize() <= 0L) continue;
            pins.add(is);
        }
        return new ItemImmutableList(this.list, pins);
    }

    @Override
    public void postUpdate(IAEItemStack is) {
        IAEItemStack st = this.list.findPrecise(is);
        for (IAEItemStack pin : this.pinsRepo) {
            if (pin == null || !pin.isSameType(is)) continue;
            pin.reset();
            pin.add(is);
            return;
        }
        if (st != null) {
            st.reset();
            st.add(is);
        } else {
            this.list.add(is);
        }
    }

    @Override
    public void setViewCell(ItemStack[] list) {
        this.myPartitionList = ItemViewCell.createFilter(list);
        this.updateView();
    }

    @Override
    public void updateView() {
        if (this.paused) {
            IItemList<IAEItemStack> pins = this.getPinsCache();
            for (int i = 0; i < this.view.size(); ++i) {
                IAEItemStack entry = this.view.get(i);
                IAEItemStack serverEntry = this.list.findPrecise(entry);
                IAEItemStack pinsEntry = pins.findPrecise(serverEntry);
                if (serverEntry == null || pinsEntry != null) {
                    entry.setStackSize(0L);
                    continue;
                }
                this.view.set(i, serverEntry);
            }
            HashSet<IAEItemStack> viewSet = new HashSet<IAEItemStack>(this.view);
            ArrayList<IAEItemStack> entriesToAdd = new ArrayList<IAEItemStack>();
            for (IAEItemStack serverEntry : this.list) {
                if (viewSet.contains(serverEntry)) continue;
                entriesToAdd.add(serverEntry);
            }
            this.addEntriesToView(entriesToAdd);
        } else {
            this.view.clear();
            this.view.ensureCapacity(this.list.size());
            this.addEntriesToView(this.list);
        }
        if (!this.paused) {
            Enum SortBy = this.sortSrc.getSortBy();
            Enum SortDir2 = this.sortSrc.getSortDir();
            ItemSorters.setDirection((SortDir)SortDir2);
            if (SortBy == SortOrder.MOD) {
                this.view.sort(ItemSorters.CONFIG_BASED_SORT_BY_MOD);
            } else if (SortBy == SortOrder.AMOUNT) {
                this.view.sort(ItemSorters.CONFIG_BASED_SORT_BY_SIZE);
            } else if (SortBy == SortOrder.INVTWEAKS) {
                this.view.sort(ItemSorters.CONFIG_BASED_SORT_BY_INV_TWEAKS);
            } else {
                this.view.sort(ItemSorters.CONFIG_BASED_SORT_BY_NAME);
            }
        }
        this.dsp.clear();
        this.dsp.ensureCapacity(this.list.size());
        for (IAEItemStack is : this.view) {
            this.dsp.add(is.getItemStack());
        }
    }

    private void addEntriesToView(Iterable<IAEItemStack> entries) {
        Enum viewMode = this.sortSrc.getSortDisplay();
        Enum typeFilter = this.sortSrc.getTypeFilter();
        Predicate<IAEItemStack> itemFilter = null;
        if (!this.searchString.trim().isEmpty()) {
            if (NEI.searchField.existsSearchField()) {
                Predicate<ItemStack> neiFilter = NEI.searchField.getFilter(this.searchString);
                itemFilter = is -> neiFilter.test(is.getItemStack());
            } else {
                itemFilter = this.getFilter(this.searchString);
            }
        }
        IItemDisplayRegistry registry = AEApi.instance().registries().itemDisplay();
        block0: for (IAEItemStack is2 : entries) {
            if (viewMode == ViewItems.CRAFTABLE && !is2.isCraftable() || viewMode == ViewItems.STORED && is2.getStackSize() == 0L || this.myPartitionList != null && !this.myPartitionList.isListed(is2) || registry.isBlacklisted(is2.getItem()) || registry.isBlacklisted(is2.getItem().getClass())) continue;
            for (BiPredicate<TypeFilter, IAEItemStack> filter : registry.getItemFilters()) {
                if (filter.test((TypeFilter)typeFilter, is2)) continue;
                continue block0;
            }
            if (itemFilter != null) {
                if (!Boolean.TRUE.equals(this.searchCache.computeIfAbsent(is2, itemFilter::test))) continue;
            }
            if (viewMode == ViewItems.CRAFTABLE) {
                is2 = is2.copy();
                is2.setStackSize(0L);
            }
            this.view.add(is2);
        }
    }

    private Predicate<IAEItemStack> getFilter(String innerSearch) {
        if (innerSearch.isEmpty()) {
            return stack -> true;
        }
        String prefix = innerSearch.substring(0, 1);
        if ("#".equals(prefix)) {
            Pattern pattern = ItemRepo.getPattern(innerSearch.substring(1));
            return stack -> {
                String tooltip = String.join((CharSequence)"\n", Platform.getTooltip(stack));
                return pattern.matcher(tooltip).find();
            };
        }
        if ("@".equals(prefix)) {
            Pattern pattern = ItemRepo.getPattern(innerSearch.substring(1));
            return stack -> {
                String mod = Platform.getModId(stack);
                return pattern.matcher(mod).find();
            };
        }
        if ("$".equals(prefix)) {
            Pattern pattern = ItemRepo.getPattern(innerSearch.substring(1));
            return stack -> {
                OreReference ores = OreHelper.INSTANCE.isOre(stack.getItemStack());
                return ores != null && pattern.matcher(String.join((CharSequence)"\n", ores.getEquivalents())).find();
            };
        }
        Pattern pattern = ItemRepo.getPattern(innerSearch);
        return stack -> {
            String name = Platform.getItemDisplayName(stack);
            if (pattern.matcher(name).find()) {
                return true;
            }
            String tooltip = String.join((CharSequence)"\n", Platform.getTooltip(stack));
            return pattern.matcher(tooltip).find();
        };
    }

    private static Pattern getPattern(String search) {
        int flags = 74;
        try {
            return Pattern.compile(search, 74);
        }
        catch (PatternSyntaxException __) {
            return Pattern.compile(Pattern.quote(search), 74);
        }
    }

    @Override
    public int size() {
        return this.view.size();
    }

    @Override
    public void clear() {
        this.list.resetStatus();
    }

    @Override
    public boolean hasPower() {
        return this.hasPower;
    }

    @Override
    public void setPowered(boolean hasPower) {
        this.hasPower = hasPower;
    }

    @Override
    public int getRowSize() {
        return this.rowSize;
    }

    @Override
    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    @Override
    public String getSearchString() {
        return this.searchString;
    }

    @Override
    public void setSearchString(@Nonnull String searchString) {
        if (!searchString.equals(this.searchString)) {
            Enum<?> searchMode;
            this.searchString = searchString;
            this.searchCache.clear();
            if (NEI.searchField.existsSearchField() && ((searchMode = AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE)) == SearchBoxMode.NEI_AUTOSEARCH || searchMode == SearchBoxMode.NEI_MANUAL_SEARCH)) {
                NEI.searchField.setText(this.searchString);
            }
        }
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void setPaused(boolean paused) {
        if (this.paused != paused) {
            this.paused = paused;
            if (!paused) {
                this.updateView();
            }
        }
    }
}

