/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.IDropToFillTextField;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerOreFilter;
import appeng.core.AELog;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.IOreFilterable;
import appeng.integration.modules.NEI;
import appeng.parts.automation.PartSharedItemBus;
import appeng.parts.misc.PartStorageBus;
import appeng.tile.misc.TileCellWorkbench;
import appeng.util.prioitylist.OreFilteredList;
import java.io.IOException;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Mouse;

public class GuiOreFilter
extends AEBaseGui
implements IDropToFillTextField {
    private MEGuiTextField textField;
    private boolean useNEIFilter = false;
    private long lastclicktime;

    public GuiOreFilter(InventoryPlayer ip, IOreFilterable obj) {
        super(new ContainerOreFilter(ip, obj));
        this.field_146999_f = 256;
        this.textField = new MEGuiTextField(231, 12){

            @Override
            public void onTextChange(String oldText) {
                String text = this.getText();
                if (!text.equals(oldText)) {
                    ((ContainerOreFilter)GuiOreFilter.this.field_147002_h).setFilter(text);
                    if (GuiOreFilter.this.useNEIFilter) {
                        NEI.searchField.updateFilter();
                    }
                }
            }
        };
        if (NEI.searchField.existsSearchField()) {
            this.textField.setFormatter(new OreFilteredList.OreFilterTextFormatter());
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.textField.x = this.field_147003_i + 12;
        this.textField.y = this.field_147009_r + 35;
        this.textField.setFocused(true);
        ((ContainerOreFilter)this.field_147002_h).setTextField(this.textField);
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        if (this.useNEIFilter) {
            this.useNEIFilter = false;
            NEI.searchField.updateFilter();
        }
    }

    public String getText() {
        return this.textField.getText();
    }

    public boolean useNEIFilter() {
        return this.useNEIFilter;
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(GuiText.OreFilterLabel.getLocal(), 12, 8, GuiColors.OreFilterLabel.getColor());
        String counterText = String.valueOf(this.textField.getText().length()) + "/" + String.valueOf(this.textField.getMaxStringLength());
        int counterColor = this.textField.getText().length() == this.textField.getMaxStringLength() ? GuiColors.OreFilterTextLengthFull.getColor() : GuiColors.OreFilterTextLength.getColor();
        this.field_146289_q.func_78276_b(counterText, this.field_146999_f - this.field_146289_q.func_78256_a(counterText) - 13, 25, counterColor);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/renamer.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.textField.drawTextBox();
        if (this.useNEIFilter) {
            GuiOreFilter.func_73734_a((int)(this.textField.x - 1), (int)(this.textField.y - 1), (int)(this.textField.x + this.textField.w), (int)this.textField.y, (int)-256);
            GuiOreFilter.func_73734_a((int)(this.textField.x - 1), (int)(this.textField.y + this.textField.h - 1), (int)(this.textField.x + this.textField.w), (int)(this.textField.y + this.textField.h), (int)-256);
            GuiOreFilter.func_73734_a((int)(this.textField.x - 1), (int)this.textField.y, (int)this.textField.x, (int)(this.textField.y + this.textField.h - 1), (int)-256);
            GuiOreFilter.func_73734_a((int)(this.textField.x + this.textField.w - 1), (int)this.textField.y, (int)(this.textField.x + this.textField.w), (int)(this.textField.y + this.textField.h - 1), (int)-256);
        }
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        if (btn == 0 && NEI.searchField.existsSearchField() && this.textField.isMouseIn(xCoord, yCoord)) {
            if (this.textField.isFocused() && System.currentTimeMillis() - this.lastclicktime < 400L) {
                this.useNEIFilter = !this.useNEIFilter;
                NEI.searchField.updateFilter();
            }
            this.lastclicktime = System.currentTimeMillis();
        }
        this.textField.mouseClicked(xCoord, yCoord, btn);
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_73869_a(char character, int key) {
        if (key == 28 || key == 156) {
            try {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("OreFilter", this.textField.getText()));
            }
            catch (IOException e) {
                AELog.debug(e);
            }
            Object target = ((AEBaseContainer)this.field_147002_h).getTarget();
            GuiBridge OriginalGui = null;
            if (target instanceof PartStorageBus) {
                OriginalGui = GuiBridge.GUI_STORAGEBUS;
            } else if (target instanceof PartSharedItemBus) {
                OriginalGui = GuiBridge.GUI_BUS;
            } else if (target instanceof TileCellWorkbench) {
                OriginalGui = GuiBridge.GUI_CELL_WORKBENCH;
            }
            if (OriginalGui != null) {
                NetworkHandler.instance.sendToServer(new PacketSwitchGuis(OriginalGui));
            } else {
                this.field_146297_k.field_71439_g.func_71053_j();
            }
        } else if (!this.textField.textboxKeyTyped(character, key)) {
            super.func_73869_a(character, key);
        }
    }

    @Override
    public boolean isOverTextField(int mousex, int mousey) {
        return this.textField.isMouseIn(mousex, mousey);
    }

    @Override
    public void setTextFieldValue(String displayName, int mousex, int mousey, ItemStack stack) {
        int[] ores = OreDictionary.getOreIDs((ItemStack)stack);
        if (ores.length > 0) {
            if (Mouse.isButtonDown((int)0)) {
                String oldText = this.textField.getText();
                if (!oldText.isEmpty()) {
                    oldText = oldText + " | ";
                }
                this.textField.setText(oldText + OreDictionary.getOreName((int)ores[0]));
            } else if (Mouse.isButtonDown((int)1)) {
                this.textField.setText(OreDictionary.getOreName((int)ores[0]));
            }
            this.textField.setCursorPositionEnd();
        }
    }
}

