/*
 * Decompiled with CFR 0.152.
 */
package appeng.capabilities;

import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.helpers.DualityInterface;
import appeng.me.GridAccessException;
import appeng.parts.misc.PartInterface;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.misc.TileInterface;
import appeng.util.IterationCounter;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.item.ImmutableAEItemStackWrapper;
import com.gtnewhorizon.gtnhlib.capability.item.ItemIO;
import com.gtnewhorizon.gtnhlib.item.AbstractInventoryIterator;
import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.item.InventoryIterator;
import com.gtnewhorizon.gtnhlib.item.ItemStack2IntFunction;
import com.gtnewhorizon.gtnhlib.item.ItemStackPredicate;
import com.gtnewhorizon.gtnhlib.util.ItemUtil;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Collection;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MEItemIO
implements ItemIO {
    private final DualityInterface duality;
    private final IEnergyGrid energyGrid;
    private final IMEMonitor<IAEItemStack> storage;
    private int[] allowedSourceSlots;
    private int[] allowedSinkSlots;
    private static final int[] SLOTS = IntStream.range(0, 9).toArray();

    public MEItemIO(TileInterface iface) throws GridAccessException {
        this.energyGrid = (IEnergyGrid)iface.getProxy().getGrid().getCache(IEnergyGrid.class);
        this.storage = ((IStorageGrid)iface.getProxy().getGrid().getCache(IStorageGrid.class)).getItemInventory();
        this.duality = iface.getInterfaceDuality();
    }

    public MEItemIO(PartInterface iface) throws GridAccessException {
        this.energyGrid = (IEnergyGrid)iface.getProxy().getGrid().getCache(IEnergyGrid.class);
        this.storage = ((IStorageGrid)iface.getProxy().getGrid().getCache(IStorageGrid.class)).getItemInventory();
        this.duality = iface.getInterfaceDuality();
    }

    @NotNull
    public InventoryIterator sourceIterator() {
        return this.getInventoryIterator(this.allowedSourceSlots);
    }

    @NotNull
    public InventoryIterator sinkIterator() {
        return this.getInventoryIterator(this.allowedSinkSlots);
    }

    public void setAllowedSourceSlots(int[] allowedSourceSlots) {
        this.allowedSourceSlots = allowedSourceSlots;
    }

    public void setAllowedSinkSlots(int @Nullable [] slots) {
        this.allowedSinkSlots = slots;
    }

    @Nullable
    public ItemStack pull(@Nullable ItemStackPredicate filter, @Nullable ItemStack2IntFunction amount) {
        InventoryIterator iter = this.sourceIterator();
        while (iter.hasNext()) {
            ImmutableItemStack stack = (ImmutableItemStack)iter.next();
            if (stack == null || stack.isEmpty() || filter != null && !filter.test(stack)) continue;
            int toExtract = amount == null ? stack.getStackSize() : amount.apply(stack);
            return iter.extract(toExtract, false);
        }
        return null;
    }

    public int store(ImmutableItemStack stack) {
        int[] slots;
        if (stack == null || stack.isEmpty()) {
            return 0;
        }
        if (!this.duality.getProxy().isActive()) {
            return stack.getStackSize();
        }
        int[] nArray = slots = this.allowedSinkSlots == null ? SLOTS : AbstractInventoryIterator.intersect((int[])SLOTS, (int[])this.allowedSinkSlots);
        if (this.isFiltered() && !this.matchesFilter(stack, slots)) {
            return stack.getStackSize();
        }
        IAEItemStack rejected = this.storage.injectItems(AEItemStack.create(stack.toStack()), Actionable.MODULATE, this.duality.getActionSource());
        return rejected == null ? 0 : Platform.longToInt(rejected.getStackSize());
    }

    private boolean isFiltered() {
        AppEngInternalAEInventory configInv = this.duality.getConfig();
        boolean isFiltered = false;
        for (ItemStack config : configInv) {
            if (config == null) continue;
            isFiltered = true;
            break;
        }
        return isFiltered;
    }

    private boolean matchesFilter(ImmutableItemStack stack, int[] slots) {
        AppEngInternalAEInventory configInv = this.duality.getConfig();
        for (int slot : slots) {
            ItemStack config = configInv.func_70301_a(slot);
            if (config == null || !stack.matches(config)) continue;
            return true;
        }
        return false;
    }

    public OptionalInt getStoredItemsInSink(@Nullable ItemStackPredicate filter) {
        if (!this.duality.getProxy().isActive()) {
            return OptionalInt.empty();
        }
        if (filter == null) {
            long sum = 0L;
            for (IAEItemStack s : this.storage.getStorageList()) {
                sum += s.getStackSize();
            }
            return sum == 0L ? ZERO : OptionalInt.of(Platform.longToInt(sum));
        }
        Collection stacks = filter.getStacks();
        long sum = 0L;
        ImmutableAEItemStackWrapper wrapper = new ImmutableAEItemStackWrapper();
        if (stacks != null) {
            for (ItemStack stack : stacks) {
                IAEItemStack available = this.storage.getAvailableItem(AEItemStack.create(stack), IterationCounter.fetchNewId());
                if (!filter.test((ImmutableItemStack)wrapper.set(available))) continue;
                sum += available.getStackSize();
            }
        } else {
            for (IAEItemStack stack : this.storage.getStorageList()) {
                if (!filter.test((ImmutableItemStack)wrapper.set(stack))) continue;
                sum += stack.getStackSize();
            }
        }
        return sum == 0L ? ZERO : OptionalInt.of(Platform.longToInt(sum));
    }

    @NotNull
    private InventoryIterator getInventoryIterator(int[] allowedSlots) {
        if (!this.duality.getProxy().isActive()) {
            return InventoryIterator.EMPTY;
        }
        if (this.isFiltered()) {
            return new FilteredInventoryIterator(allowedSlots);
        }
        ObjectList contents = ObjectIterators.pour(this.storage.getStorageList().iterator(), (int)64);
        int[] slots = new int[contents.size() + 64];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return new UnfilteredInventoryIterator(slots, (ObjectList<IAEItemStack>)contents);
    }

    private class FilteredInventoryIterator
    extends AbstractInventoryIterator {
        public FilteredInventoryIterator(int[] allowedSlots) {
            super(SLOTS, allowedSlots);
        }

        protected ItemStack getStackInSlot(int slot) {
            IAEItemStack config = MEItemIO.this.duality.getConfig().getAEStackInSlot(slot);
            if (config == null) {
                return null;
            }
            ItemStack stored = MEItemIO.this.duality.getStorage().func_70301_a(slot);
            IAEItemStack inMESystem = MEItemIO.this.storage.getAvailableItem(config, IterationCounter.fetchNewId());
            long total = 0L;
            ItemStack out = null;
            if (stored != null) {
                out = stored.func_77979_a(0);
                total += (long)stored.field_77994_a;
            }
            if (inMESystem != null) {
                if (out == null) {
                    out = inMESystem.getItemStack();
                }
                total += inMESystem.getStackSize();
            }
            if (out != null) {
                out.field_77994_a = Platform.longToInt(total);
            }
            return out;
        }

        public ItemStack extract(int amount, boolean force) {
            IAEItemStack config = MEItemIO.this.duality.getConfig().getAEStackInSlot(this.getCurrentSlot());
            if (config == null) {
                return null;
            }
            ItemStack result = config.getItemStack();
            result.field_77994_a = 0;
            IAEItemStack extracted = Platform.poweredExtraction(MEItemIO.this.energyGrid, MEItemIO.this.storage, (IAEItemStack)((IAEItemStack)config.empty()).setStackSize(amount), MEItemIO.this.duality.getActionSource());
            if (extracted != null) {
                result.field_77994_a += Platform.longToInt(extracted.getStackSize());
                amount -= Platform.longToInt(extracted.getStackSize());
            }
            ItemStack stored = MEItemIO.this.duality.getStorage().func_70301_a(this.getCurrentSlot());
            if (amount > 0 && !ItemUtil.isStackEmpty((ItemStack)stored)) {
                ItemStack fromSlot = MEItemIO.this.duality.getStorage().func_70298_a(this.getCurrentSlot(), Math.min(amount, stored.field_77994_a));
                result.field_77994_a += fromSlot.field_77994_a;
            }
            return result;
        }

        public int insert(ImmutableItemStack stack, boolean force) {
            if (!MEItemIO.this.matchesFilter(stack, new int[]{this.getCurrentSlot()})) {
                return stack.getStackSize();
            }
            IAEItemStack rejected = MEItemIO.this.storage.injectItems(AEItemStack.create(stack.toStack()), Actionable.MODULATE, MEItemIO.this.duality.getActionSource());
            return rejected == null ? 0 : Platform.longToInt(rejected.getStackSize());
        }
    }

    private class UnfilteredInventoryIterator
    extends AbstractInventoryIterator {
        private final ObjectList<IAEItemStack> contents;

        public UnfilteredInventoryIterator(int[] slots, ObjectList<IAEItemStack> contents) {
            super(slots);
            this.contents = contents;
        }

        protected ItemStack getStackInSlot(int slot) {
            if (slot < 0 || slot >= this.contents.size()) {
                return null;
            }
            IAEItemStack stack = (IAEItemStack)this.contents.get(slot);
            return stack == null ? null : stack.getItemStack();
        }

        public ItemStack extract(int amount, boolean force) {
            int slot = this.getCurrentSlot();
            if (slot < 0 || slot >= this.contents.size()) {
                return null;
            }
            IAEItemStack current = (IAEItemStack)this.contents.get(slot);
            if (current == null) {
                return null;
            }
            IAEItemStack extracted = Platform.poweredExtraction(MEItemIO.this.energyGrid, MEItemIO.this.storage, (IAEItemStack)((IAEItemStack)current.empty()).setStackSize(amount), MEItemIO.this.duality.getActionSource());
            return extracted == null ? null : extracted.getItemStack();
        }

        public int insert(ImmutableItemStack stack, boolean force) {
            IAEItemStack rejected = MEItemIO.this.storage.injectItems(AEItemStack.create(stack.toStack()), Actionable.MODULATE, MEItemIO.this.duality.getActionSource());
            return rejected == null ? 0 : Platform.longToInt(rejected.getStackSize());
        }
    }
}

