/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseTileBlock;
import appeng.client.render.blocks.RenderBlockQuartzAccelerator;
import appeng.client.render.effects.LightningFX;
import appeng.core.AEConfig;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.tile.misc.TileQuartzGrowthAccelerator;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockQuartzGrowthAccelerator
extends AEBaseTileBlock
implements IOrientableBlock {
    public BlockQuartzGrowthAccelerator() {
        super(Material.field_151576_e);
        this.func_149672_a(Block.field_149777_j);
        this.setTileEntity(TileQuartzGrowthAccelerator.class);
        this.setFeature(EnumSet.of(AEFeature.Core));
    }

    @SideOnly(value=Side.CLIENT)
    protected RenderBlockQuartzAccelerator getRenderer() {
        return new RenderBlockQuartzAccelerator();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World w, int x, int y, int z, Random r) {
        if (!AEConfig.instance.enableEffects) {
            return;
        }
        TileQuartzGrowthAccelerator cga = (TileQuartzGrowthAccelerator)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (cga != null && cga.isPowered() && CommonHelper.proxy.shouldAddParticles(r)) {
            double d0 = r.nextFloat() - 0.5f;
            double d1 = r.nextFloat() - 0.5f;
            ForgeDirection up = cga.getUp();
            ForgeDirection forward = cga.getForward();
            ForgeDirection west = Platform.crossProduct(forward, up);
            double rx = 0.5 + (double)x;
            double ry = 0.5 + (double)y;
            double rz = 0.5 + (double)z;
            rx += (double)up.offsetX * d0;
            ry += (double)up.offsetY * d0;
            rz += (double)up.offsetZ * d0;
            double dz = 0.0;
            double dx = 0.0;
            switch (r.nextInt(4)) {
                case 0: {
                    dx = 0.6;
                    dz = d1;
                    if (w.func_147439_a(x + west.offsetX, y + west.offsetY, z + west.offsetZ).isAir((IBlockAccess)w, x + west.offsetX, y + west.offsetY, z + west.offsetZ)) break;
                    return;
                }
                case 1: {
                    dx = d1;
                    dz += 0.6;
                    if (w.func_147439_a(x + forward.offsetX, y + forward.offsetY, z + forward.offsetZ).isAir((IBlockAccess)w, x + forward.offsetX, y + forward.offsetY, z + forward.offsetZ)) break;
                    return;
                }
                case 2: {
                    dx = d1;
                    dz = -0.6;
                    if (w.func_147439_a(x - forward.offsetX, y - forward.offsetY, z - forward.offsetZ).isAir((IBlockAccess)w, x - forward.offsetX, y - forward.offsetY, z - forward.offsetZ)) break;
                    return;
                }
                case 3: {
                    dx = -0.6;
                    dz = d1;
                    if (w.func_147439_a(x - west.offsetX, y - west.offsetY, z - west.offsetZ).isAir((IBlockAccess)w, x - west.offsetX, y - west.offsetY, z - west.offsetZ)) break;
                    return;
                }
            }
            rx += dx * (double)west.offsetX;
            ry += dx * (double)west.offsetY;
            rz += dx * (double)west.offsetZ;
            LightningFX fx = new LightningFX(w, rx += dz * (double)forward.offsetX, ry += dz * (double)forward.offsetY, rz += dz * (double)forward.offsetZ, 0.0, 0.0, 0.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    @Deprecated
    public boolean usesMetadata() {
        return true;
    }
}

