/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.buildcraft.pluggable;

import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.pluggable.IPipePluggableRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.render.TextureStateManager;
import buildcraft.core.lib.utils.MatrixTranformations;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class DroneStationRenderer
implements IPipePluggableRenderer {
    private float zFightOffset = 2.4414062E-4f;

    private void droneStationPartRender(RenderBlocks renderblocks, ForgeDirection side, ITextureStates blockStateMachine, int x, int y, int z, float xStart, float xEnd, float yStart, float yEnd, float zStart, float zEnd) {
        float[][] zeroState = new float[3][2];
        zeroState[0][0] = xStart + this.zFightOffset;
        zeroState[0][1] = xEnd - this.zFightOffset;
        zeroState[1][0] = yStart;
        zeroState[1][1] = yEnd;
        zeroState[2][0] = zStart + this.zFightOffset;
        zeroState[2][1] = zEnd - this.zFightOffset;
        IIcon[] icons = ((TextureStateManager)blockStateMachine.getTextureState()).popArray();
        icons[0] = TextureHandler.Textures.DRONE_STATION_BOTTOM.getIcon();
        icons[1] = TextureHandler.Textures.DRONE_STATION_BOTTOM.getIcon();
        for (int i = 2; i < icons.length; ++i) {
            icons[i] = TextureHandler.Textures.DRONE_STATION_SIDE.getIcon();
        }
        float[][] rotated = MatrixTranformations.deepClone((float[][])zeroState);
        MatrixTranformations.transform((float[][])rotated, (ForgeDirection)side);
        renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
        renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
    }

    public void renderPluggable(RenderBlocks renderblocks, IPipe pipe, ForgeDirection side, PipePluggable pipePluggable, ITextureStates blockStateMachine, int renderPass, int x, int y, int z) {
        if (renderPass != 0) {
            return;
        }
        this.droneStationPartRender(renderblocks, side, blockStateMachine, x, y, z, 0.56f, 0.625f, 0.09f, 0.225f - this.zFightOffset, 0.375f, 0.44f);
        this.droneStationPartRender(renderblocks, side, blockStateMachine, x, y, z, 0.56f, 0.625f, 0.09f, 0.225f - this.zFightOffset, 0.56f, 0.625f);
        this.droneStationPartRender(renderblocks, side, blockStateMachine, x, y, z, 0.375f, 0.44f, 0.09f, 0.225f - this.zFightOffset, 0.375f, 0.44f);
        this.droneStationPartRender(renderblocks, side, blockStateMachine, x, y, z, 0.375f, 0.44f, 0.09f, 0.225f - this.zFightOffset, 0.56f, 0.625f);
        float[][] zeroState = new float[3][2];
        zeroState[0][0] = 0.25f + this.zFightOffset;
        zeroState[0][1] = 0.75f - this.zFightOffset;
        zeroState[1][0] = 0.225f;
        zeroState[1][1] = 0.25f - this.zFightOffset;
        zeroState[2][0] = 0.25f + this.zFightOffset;
        zeroState[2][1] = 0.75f - this.zFightOffset;
        IIcon[] icons = ((TextureStateManager)blockStateMachine.getTextureState()).popArray();
        icons[0] = TextureHandler.Textures.DRONE_STATION_SIDE.getIcon();
        icons[1] = TextureHandler.Textures.DRONE_STATION_TOP.getIcon();
        for (int i = 2; i < icons.length; ++i) {
            icons[i] = TextureHandler.Textures.DRONE_STATION_SIDE.getIcon();
        }
        float[][] rotated = MatrixTranformations.deepClone((float[][])zeroState);
        MatrixTranformations.transform((float[][])rotated, (ForgeDirection)side);
        renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
        renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
        zeroState[0][0] = 0.3125f + this.zFightOffset;
        zeroState[0][1] = 0.6875f - this.zFightOffset;
        zeroState[1][0] = 0.25f;
        zeroState[1][1] = 0.375f;
        zeroState[2][0] = 0.3125f + this.zFightOffset;
        zeroState[2][1] = 0.6875f - this.zFightOffset;
        icons[0] = TextureHandler.Textures.DRONE_STATION_BOTTOM.getIcon();
        icons[1] = TextureHandler.Textures.DRONE_STATION_SIDE.getIcon();
        for (int i = 2; i < icons.length; ++i) {
            icons[i] = TextureHandler.Textures.DRONE_STATION_SIDE.getIcon();
        }
        rotated = MatrixTranformations.deepClone((float[][])zeroState);
        MatrixTranformations.transform((float[][])rotated, (ForgeDirection)side);
        renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
        renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
        ((TextureStateManager)blockStateMachine.getTextureState()).pushArray();
    }

    public static class TextureHandler {
        @SubscribeEvent
        public void textureHook(TextureStitchEvent.Pre event) {
            if (event.map.func_130086_a() == 0) {
                for (Textures t : Textures.VALUES) {
                    t.registerIcon((IIconRegister)event.map);
                }
            }
        }

        private static class WrappedIcon
        implements IIcon {
            private IIcon icon;
            private final int size;

            private WrappedIcon(IIcon icon) {
                this(icon, 2);
            }

            private WrappedIcon(IIcon icon, int size) {
                this.icon = icon;
                this.size = size;
            }

            public int func_94211_a() {
                return this.icon.func_94211_a();
            }

            public int func_94216_b() {
                return this.icon.func_94216_b();
            }

            public float func_94209_e() {
                return this.size > 0 ? this.icon.func_94209_e() - (this.icon.func_94212_f() - this.icon.func_94209_e()) * (float)this.size / 4.0f : this.icon.func_94209_e();
            }

            public float func_94212_f() {
                return this.size > 0 ? this.icon.func_94212_f() + (this.icon.func_94212_f() - this.icon.func_94209_e()) * (float)this.size / 4.0f : this.icon.func_94212_f();
            }

            public float func_94214_a(double par1) {
                float f = this.func_94212_f() - this.func_94209_e();
                float uOffset = this.func_94209_e() + f * (float)par1 / 16.0f;
                if (uOffset < this.icon.func_94209_e()) {
                    uOffset += Math.abs(this.icon.func_94209_e() - this.func_94209_e());
                } else if (uOffset > this.icon.func_94212_f()) {
                    uOffset -= Math.abs(this.func_94212_f() - this.icon.func_94212_f());
                }
                return uOffset;
            }

            public float func_94206_g() {
                float f = this.icon.func_94210_h() - this.icon.func_94206_g();
                return this.size > 0 ? this.icon.func_94206_g() - f * (float)this.size / 4.0f : this.icon.func_94206_g();
            }

            public float func_94210_h() {
                float f = this.icon.func_94210_h() - this.icon.func_94206_g();
                return this.size > 0 ? this.icon.func_94210_h() + f * (float)this.size / 4.0f : this.icon.func_94210_h();
            }

            public float func_94207_b(double par1) {
                float f = this.func_94210_h() - this.func_94206_g();
                float vOffset = this.func_94206_g() + f * (float)par1 / 16.0f;
                if (vOffset < this.icon.func_94206_g()) {
                    vOffset += Math.abs(this.icon.func_94206_g() - this.func_94206_g());
                } else if (vOffset > this.icon.func_94210_h()) {
                    vOffset -= Math.abs(this.func_94210_h() - this.icon.func_94210_h());
                }
                return vOffset;
            }

            public String func_94215_i() {
                return this.icon.func_94215_i();
            }
        }

        static enum Textures {
            DRONE_STATION_TOP("drone_station_top"),
            DRONE_STATION_BOTTOM("drone_station_bottom"),
            DRONE_STATION_SIDE("drone_station_side");

            private IIcon icon;
            private final String location;
            public static final Textures[] VALUES;

            private Textures(String location) {
                this.location = location;
            }

            public IIcon getIcon() {
                return this.icon;
            }

            public void registerIcon(IIconRegister iconRegister) {
                this.icon = new WrappedIcon(iconRegister.func_94245_a("computronics:buildcraft/pluggable/" + this.location));
            }

            static {
                VALUES = Textures.values();
            }
        }
    }

    public static class ItemRenderer
    extends ModelBase
    implements IItemRenderer {
        private ResourceLocation texture = new ResourceLocation("computronics", "textures/blocks/buildcraft/pluggable/drone_station.png");
        public ModelRenderer Base;
        public ModelRenderer Nook1;
        public ModelRenderer Nook2;
        public ModelRenderer Nook3;
        public ModelRenderer Nook4;

        public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
            switch (type) {
                case ENTITY: 
                case EQUIPPED: 
                case EQUIPPED_FIRST_PERSON: 
                case INVENTORY: {
                    return true;
                }
            }
            return false;
        }

        public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
            return helper != IItemRenderer.ItemRendererHelper.BLOCK_3D;
        }

        public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
            GL11.glPushAttrib((int)1048575);
            GL11.glPushMatrix();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDepthFunc((int)515);
            GL11.glDisable((int)2884);
            switch (type) {
                case ENTITY: {
                    GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    this.Base.func_78785_a(0.0625f);
                    break;
                }
                case EQUIPPED_FIRST_PERSON: {
                    GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)50.0f, (float)1.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)20.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glRotatef((float)-10.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.6f, (float)0.0f, (float)-0.3f);
                }
                case EQUIPPED: {
                    GL11.glTranslatef((float)0.6f, (float)1.0f, (float)0.7f);
                    GL11.glRotatef((float)-140.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)140.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)-35.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                    this.Base.func_78785_a(0.0625f);
                    break;
                }
                case INVENTORY: {
                    GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                    GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    this.Base.func_78785_a(0.0625f);
                    break;
                }
            }
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }

        public ItemRenderer() {
            this.field_78090_t = 64;
            this.field_78089_u = 32;
            this.Nook3 = new ModelRenderer((ModelBase)this, 8, 12);
            this.Nook3.func_78793_a(1.0f, -2.0f, -2.0f);
            this.Nook3.func_78790_a(0.0f, 0.0f, 0.0f, 1, 2, 1, 0.0f);
            this.Nook4 = new ModelRenderer((ModelBase)this, 12, 12);
            this.Nook4.func_78793_a(-2.0f, -2.0f, -2.0f);
            this.Nook4.func_78790_a(0.0f, 0.0f, 0.0f, 1, 2, 1, 0.0f);
            this.Base = new ModelRenderer((ModelBase)this, 0, 0);
            this.Base.func_78793_a(0.0f, 0.0f, 0.0f);
            this.Base.func_78790_a(-4.0f, 0.0f, -4.0f, 8, 2, 8, 0.0f);
            this.Nook1 = new ModelRenderer((ModelBase)this, 0, 12);
            this.Nook1.func_78793_a(1.0f, -2.0f, 1.0f);
            this.Nook1.func_78790_a(0.0f, 0.0f, 0.0f, 1, 2, 1, 0.0f);
            this.Nook2 = new ModelRenderer((ModelBase)this, 4, 12);
            this.Nook2.func_78793_a(-2.0f, -2.0f, 1.0f);
            this.Nook2.func_78790_a(0.0f, 0.0f, 0.0f, 1, 2, 1, 0.0f);
            this.Base.func_78792_a(this.Nook3);
            this.Base.func_78792_a(this.Nook4);
            this.Base.func_78792_a(this.Nook1);
            this.Base.func_78792_a(this.Nook2);
        }
    }
}

