/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.buildcraft.pluggable;

import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IPipePluggableRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.utils.MatrixTranformations;
import cofh.api.energy.IEnergyReceiver;
import io.netty.buffer.ByteBuf;
import li.cil.oc.Settings;
import li.cil.oc.api.internal.Drone;
import li.cil.oc.api.network.Connector;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.integration.buildcraft.pluggable.DroneStationRenderer;
import pl.asie.computronics.util.ParticleUtils;
import pl.asie.lib.util.EnergyConverter;

public class DroneStationPluggable
extends PipePluggable
implements IEnergyReceiver {
    private DroneStationState state = DroneStationState.Available;
    private Drone drone;

    public Drone getDrone() {
        return this.drone;
    }

    public void setDrone(Drone drone) {
        this.drone = drone;
        this.state = this.drone == null ? DroneStationState.Available : DroneStationState.Used;
    }

    public DroneStationState getState() {
        return this.state;
    }

    public boolean isConnected(Drone drone, ForgeDirection side) {
        return this.drone == drone;
    }

    public ItemStack[] getDropItems(IPipeTile pipe) {
        return new ItemStack[]{new ItemStack((Item)Computronics.buildcraft.droneStationItem, 1, 0)};
    }

    public boolean isBlocking(IPipeTile pipe, ForgeDirection direction) {
        return true;
    }

    public void update(IPipeTile pipe, ForgeDirection direction) {
        super.update(pipe, direction);
        if (this.getState() == DroneStationState.Used && this.drone == null) {
            this.state = DroneStationState.Available;
        }
        if (this.drone != null && (this.drone.world() != pipe.getWorld() || this.drone instanceof Entity && ((Entity)this.drone).func_70092_e((double)pipe.x(), (double)pipe.y(), (double)pipe.z()) >= 4.0)) {
            this.setDrone(null);
        }
    }

    public AxisAlignedBB getBoundingBox(ForgeDirection side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.25f;
        bounds[0][1] = 0.75f;
        bounds[1][0] = 0.125f;
        bounds[1][1] = 0.251f;
        bounds[2][0] = 0.25f;
        bounds[2][1] = 0.75f;
        MatrixTranformations.transform((float[][])bounds, (ForgeDirection)side);
        return AxisAlignedBB.func_72330_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    public IPipePluggableRenderer getRenderer() {
        return new DroneStationRenderer();
    }

    public void readFromNBT(NBTTagCompound tag) {
    }

    public void writeToNBT(NBTTagCompound tag) {
    }

    public void writeData(ByteBuf data) {
    }

    public void readData(ByteBuf data) {
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.drone == null || this.state == DroneStationState.Available || this.drone.world() == null) {
            return 0;
        }
        World world = this.drone.world();
        if (!world.field_72995_K) {
            double newPower;
            Connector node = (Connector)this.drone.machine().node();
            double change = Math.min(Settings.get().chargeRateExternal(), node.globalBufferSize() - node.globalBuffer());
            if (change > 10.0 && (newPower = Math.min(EnergyConverter.convertEnergy((double)maxReceive, (String)"RF", (String)"OC"), change)) > 0.0) {
                if (simulate) {
                    return (int)Math.ceil(EnergyConverter.convertEnergy((double)newPower, (String)"OC", (String)"RF"));
                }
                double remainingPower = node.changeBuffer(newPower);
                if (remainingPower < newPower && world.func_72912_H().func_82573_f() % 10L == 0L) {
                    double theta = world.field_73012_v.nextDouble() * Math.PI;
                    double phi = world.field_73012_v.nextDouble() * Math.PI * 2.0;
                    double dx = 0.45 * Math.sin(theta) * Math.cos(phi);
                    double dy = 0.45 * Math.sin(theta) * Math.sin(phi);
                    double dz = 0.45 * Math.cos(theta);
                    ParticleUtils.sendParticlePacket("happyVillager", this.drone.world(), this.drone.xPosition() + dx, this.drone.yPosition() + dz, this.drone.zPosition() + dy, 0.0, 0.0, 0.0);
                }
                return (int)Math.ceil(EnergyConverter.convertEnergy((double)(newPower - remainingPower), (String)"OC", (String)"RF"));
            }
        }
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public static enum DroneStationState {
        Available,
        Used;

        public static final DroneStationState[] VALUES;

        static {
            VALUES = DroneStationState.values();
        }
    }
}

