/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.charge;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderzoo.PacketHandler;
import crazypants.enderzoo.charge.BlockConfusingCharge;
import crazypants.enderzoo.charge.EntityPrimedCharge;
import crazypants.enderzoo.charge.PacketExplodeEffect;
import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.entity.EntityUtil;
import crazypants.enderzoo.entity.TeleportHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityPortalFX;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class BlockEnderCharge
extends BlockConfusingCharge {
    private static final String NAME = "blockEnderCharge";

    public static BlockEnderCharge create() {
        if (!Config.enderChargeEnabled) {
            return null;
        }
        BlockEnderCharge res = new BlockEnderCharge();
        res.init();
        return res;
    }

    protected BlockEnderCharge() {
        super(NAME);
    }

    @Override
    public void explode(EntityPrimedCharge entity) {
        PacketHandler.sendToAllAround(new PacketExplodeEffect(entity, this), entity);
        BlockEnderCharge.doEntityTeleport(entity);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void explodeEffect(World world, double x, double y, double z) {
        world.func_72869_a("hugeexplosion", x, y, z, 1.0, 0.0, 0.0);
        BlockEnderCharge.doTeleportEffect(world, x, y, z);
    }

    public static void doEntityTeleport(EntityPrimedCharge entity) {
        World world = entity.field_70170_p;
        world.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "random.explode", 1.0f, 1.4f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f);
        world.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "mob.endermen.portal", 2.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f);
        AxisAlignedBB bb = EntityUtil.getBoundsAround(entity, Config.enderChargeRange);
        List ents = world.func_72872_a(EntityLivingBase.class, bb);
        for (EntityLivingBase ent : ents) {
            boolean done = false;
            for (int i = 0; i < 20 && !done; ++i) {
                done = TeleportHelper.teleportRandomly(ent, Config.enderChargeMaxTeleportRange);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void doTeleportEffect(World world, double x, double y, double z) {
        Random random = world.field_73012_v;
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble() * 2.0;
            double mag = 2.0;
            double motionX = (0.5 - random.nextDouble()) * mag * d;
            double motionY = (0.5 - random.nextDouble()) * mag;
            double motionZ = (0.5 - random.nextDouble()) * mag * d;
            EntityPortalFX entityfx = new EntityPortalFX(world, x + motionX * 0.1, y + motionY * 0.1, z + motionZ * 0.1, motionX, motionY, motionZ);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)entityfx);
        }
    }
}

