/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock.listtypes;

import cofh.lib.util.helpers.MathHelper;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class ListWrapper<T>
implements Iterable<T> {
    LinkedList<T> list;
    Object[] array;
    int cursor;
    public SortType type;

    public void setList(LinkedList<T> linkedList, SortType sortType) {
        this.list = linkedList;
        this.array = null;
        this.type = sortType;
        this.cursor = 0;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.list.size() <= 1) {
            return this.list.listIterator();
        }
        if (this.type == SortType.NORMAL) {
            return this.list.iterator();
        }
        if (this.type == SortType.REVERSE) {
            return this.list.descendingIterator();
        }
        if (this.type == SortType.ROUNDROBIN) {
            return new RRobinIter();
        }
        if (this.type == SortType.SHUFFLE) {
            if (this.array == null || this.list.size() != this.array.length) {
                this.array = this.list.toArray();
            }
            return new ShuffleIter();
        }
        return this.list.iterator();
    }

    public void advanceCursor() {
        ++this.cursor;
        if (this.cursor >= this.list.size()) {
            this.cursor = 0;
        }
    }

    public T peekRR() {
        if (this.cursor + 1 >= this.list.size()) {
            return this.list.get(0);
        }
        return this.list.get(this.cursor + 1);
    }

    public int size() {
        return this.list.size();
    }

    private class ShuffleIter
    implements Iterator<T> {
        int i;

        @Override
        public boolean hasNext() {
            return this.i < ListWrapper.this.array.length;
        }

        @Override
        public T next() {
            Object object = ListWrapper.this.array[this.i];
            int n = MathHelper.RANDOM.nextInt(ListWrapper.this.array.length - this.i) + this.i;
            ListWrapper.this.array[this.i] = ListWrapper.this.array[n];
            ListWrapper.this.array[n] = object;
            ++this.i;
            return object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum SortType {
        NORMAL,
        REVERSE,
        SHUFFLE,
        ROUNDROBIN;

    }

    public class RRobinIter
    implements Iterator<T> {
        public ListIterator<T> tListIterator;
        final int stopCursor;

        public RRobinIter() {
            this.stopCursor = ListWrapper.this.cursor - 1;
            this.tListIterator = ListWrapper.this.list.listIterator(ListWrapper.this.cursor);
        }

        @Override
        public boolean hasNext() {
            if (!this.tListIterator.hasNext()) {
                if (this.stopCursor < 0) {
                    return false;
                }
                this.tListIterator = ListWrapper.this.list.listIterator(0);
            }
            return this.tListIterator.nextIndex() != this.stopCursor;
        }

        @Override
        public T next() {
            ListWrapper.this.advanceCursor();
            return this.tListIterator.next();
        }

        @Override
        public void remove() {
        }
    }
}

