/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.light;

import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.lib.util.position.ChunkCoord;
import cofh.thermaldynamics.core.WorldGridList;
import cofh.thermaldynamics.duct.light.PacketLight;
import cofh.thermaldynamics.duct.light.TileLightDuct;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class LightGrid
extends MultiBlockGrid {
    public HashSet<ChunkCoord> chunks;
    public boolean upToDate = false;
    boolean lit = false;

    public LightGrid(WorldGridList worldGridList) {
        super(worldGridList);
    }

    public LightGrid(World world) {
        super(world);
    }

    @Override
    public boolean canAddBlock(IMultiBlock iMultiBlock) {
        return iMultiBlock instanceof TileLightDuct;
    }

    @Override
    public void onMajorGridChange() {
        super.onMajorGridChange();
        this.upToDate = false;
        this.chunks = null;
    }

    @Override
    public void onMinorGridChange() {
        super.onMinorGridChange();
        this.upToDate = false;
    }

    @Override
    public void tickGrid() {
        super.tickGrid();
        if (this.upToDate && this.worldGrid.worldObj.func_82737_E() % 160L != 0L) {
            if (this.rs != null && this.rs.nextRedstoneLevel != -128) {
                this.upToDate = false;
            }
            return;
        }
        boolean bl = this.upToDate = this.rs == null || this.rs.nextRedstoneLevel == -128;
        boolean bl2 = this.rs != null ? (this.rs.nextRedstoneLevel != -128 ? this.rs.nextRedstoneLevel > 0 : this.rs.redstoneLevel > 0) : false;
        if (!bl2) {
            for (Object t : Iterables.concat(this.nodeSet, this.idleSet)) {
                TileLightDuct tileLightDuct = (TileLightDuct)t;
                if (!tileLightDuct.lit) continue;
                bl2 = true;
                break;
            }
        }
        if (this.lit != bl2) {
            this.setLight(bl2);
        }
    }

    public void setLight(boolean bl) {
        this.lit = bl;
        if (this.chunks == null) {
            this.buildMap();
        }
        if (this.worldGrid.worldObj instanceof WorldServer) {
            PacketLight packetLight = new PacketLight(bl, this);
            WorldServer worldServer = (WorldServer)this.worldGrid.worldObj;
            PlayerManager playerManager = worldServer.func_73040_p();
            block0: for (Object object : worldServer.field_73010_i) {
                for (ChunkCoord chunkCoord : this.chunks) {
                    PlayerManager.PlayerInstance playerInstance = playerManager.func_72690_a(chunkCoord.chunkX, chunkCoord.chunkZ, false);
                    if (playerInstance == null || !playerInstance.field_73263_b.contains(object)) continue;
                    PacketHandler.sendTo((PacketBase)packetLight, (EntityPlayerMP)object);
                    continue block0;
                }
            }
            for (Object object : Iterables.concat(this.nodeSet, this.idleSet)) {
                ((TileLightDuct)object).checkLight();
            }
        }
    }

    public void buildMap() {
        this.chunks = new HashSet();
        for (IMultiBlock iMultiBlock : Iterables.concat(this.nodeSet, this.idleSet)) {
            this.buildMapEntry(iMultiBlock);
        }
    }

    private void buildMapEntry(IMultiBlock iMultiBlock) {
        this.chunks.add(new ChunkCoord(iMultiBlock.x() >> 4, iMultiBlock.z() >> 4));
    }
}

