/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.cover;

import cofh.lib.util.helpers.MathHelper;
import cofh.thermaldynamics.core.TDProps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;

public class CoverHoleRender {
    public static final ITransformer[] hollowDuct = CoverHoleRender.hollowCover(0.3125f);
    public static final ITransformer[] hollowDuctLarge = CoverHoleRender.hollowCover(0.28125f);
    public static final ITransformer[] hollowDuctTile = CoverHoleRender.hollowCover(0.25f);
    public static final ITransformer[] hollowDuctCryo = CoverHoleRender.octaCover(0.125f, 0.1812f);
    public static final ITransformer[] hollowDuctTransport = CoverHoleRender.octaCover(0.5f * (1.0f - TDProps.largeInnerModelScaling), 0.1812f);

    public static void holify(int n, int n2, int n3, int n4, int n5, ITransformer[] iTransformerArray) {
        List<Quad> list = CoverHoleRender.loadFromTessellator(n, true);
        for (Quad quad : list) {
            quad.sliceStretchDraw(n2, n3, n4, n5, iTransformerArray);
        }
    }

    public static List<Quad> loadFromTessellator(int n, boolean bl) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int n2 = tessellator.field_147569_p;
        int[] nArray = tessellator.field_78405_h;
        float f = (float)tessellator.field_78408_v;
        float f2 = (float)tessellator.field_78407_w;
        float f3 = (float)tessellator.field_78417_x;
        if (n == n2) {
            return Collections.emptyList();
        }
        ArrayList<Quad> arrayList = new ArrayList<Quad>(n2 - n >> 2);
        for (int i = n; i < n2; i += 32) {
            Vertex8[] vertex8Array = new Vertex8[4];
            for (int j = 0; j < 4; ++j) {
                int n3 = i + j * 8;
                vertex8Array[j] = new Vertex8(Float.intBitsToFloat(nArray[n3]) - f, Float.intBitsToFloat(nArray[n3 + 1]) - f2, Float.intBitsToFloat(nArray[n3 + 2]) - f3, Float.intBitsToFloat(nArray[n3 + 3]), Float.intBitsToFloat(nArray[n3 + 4]), nArray[n3 + 5], nArray[n3 + 6], nArray[n3 + 7]);
            }
            arrayList.add(new Quad(vertex8Array));
        }
        if (bl) {
            tessellator.field_147569_p = n;
            tessellator.field_78406_i = n >> 3;
        }
        return arrayList;
    }

    public static ITransformer[] hollowCover(float f) {
        return new ITransformer[]{new TransformSquare(0.0f, f, 0.0f, 1.0f), new TransformSquare(1.0f - f, 1.0f, 0.0f, 1.0f), new TransformSquare(f, 1.0f - f, 0.0f, f), new TransformSquare(f, 1.0f - f, 1.0f - f, 1.0f)};
    }

    public static ITransformer[] octaCover(float f, float f2) {
        return new ITransformer[]{new TransformSquare(0.0f, f, 0.0f, 1.0f), new TransformSquare(1.0f - f, 1.0f, 0.0f, 1.0f), new TransformSquare(f, 1.0f - f, 0.0f, f), new TransformSquare(f, 1.0f - f, 1.0f - f, 1.0f), new TriTransformer(f, f + 0.5f - f2, false, false), new TriTransformer(f, f + 0.5f - f2, false, true), new TriTransformer(f, f + 0.5f - f2, true, false), new TriTransformer(f, f + 0.5f - f2, true, true)};
    }

    public static ITransformer[] octaCover(float f) {
        return new ITransformer[]{new TriTransformer(0.0f, 0.5f - f, false, false), new TriTransformer(0.0f, 0.5f - f, false, true), new TriTransformer(0.0f, 0.5f - f, true, false), new TriTransformer(0.0f, 0.5f - f, true, true)};
    }

    public static class Vertex8 {
        public static final int TEX_NUM = 8;
        float x;
        float y;
        float z;
        float u;
        float v;
        int color;
        int normal;
        int brightness;

        public String toString() {
            return String.format("V8{{%s,%s,%s},{%s,%s},c=%d,n=%d,b=%d}", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.u), Float.valueOf(this.v), this.color, this.normal, this.brightness);
        }

        public Vertex8(float f, float f2, float f3, float f4, float f5, int n, int n2, int n3) {
            this.x = f;
            this.y = f2;
            this.z = f3;
            this.u = f4;
            this.v = f5;
            this.color = n;
            this.normal = n2;
            this.brightness = n3;
        }

        public Vertex8 copy() {
            return new Vertex8(this.x, this.y, this.z, this.u, this.v, this.color, this.normal, this.brightness);
        }

        public void draw() {
            Tessellator tessellator = Tessellator.field_78398_a;
            int n = tessellator.field_147569_p;
            tessellator.func_78377_a((double)this.x, (double)this.y, (double)this.z);
            int[] nArray = tessellator.field_78405_h;
            nArray[n + 3] = Float.floatToRawIntBits(this.u);
            nArray[n + 4] = Float.floatToRawIntBits(this.v);
            nArray[n + 5] = this.color;
            nArray[n + 6] = this.normal;
            nArray[n + 7] = this.brightness;
        }

        public float[] buildTex() {
            return new float[]{this.u, this.v, this.color >> 24 & 0xFF, this.color >> 16 & 0xFF, this.color >> 8 & 0xFF, this.color & 0xFF, this.brightness & 0xFFFF, this.brightness >>> 16 & 0xFFFF};
        }

        public void reloadTex(float[] fArray) {
            this.u = fArray[0];
            this.v = fArray[1];
            this.color = (int)MathHelper.clamp((float)fArray[2], (float)0.0f, (float)255.0f) << 24 | (int)MathHelper.clamp((float)fArray[3], (float)0.0f, (float)255.0f) << 16 | (int)MathHelper.clamp((float)fArray[4], (float)0.0f, (float)255.0f) << 8 | (int)MathHelper.clamp((float)fArray[5], (float)0.0f, (float)255.0f);
            this.brightness = (int)MathHelper.clamp((float)fArray[6], (float)0.0f, (float)65535.0f) | (int)MathHelper.clamp((float)fArray[7], (float)0.0f, (float)65535.0f) << 16;
        }
    }

    public static class TriTransformer
    implements ITransformer {
        float m;
        float k;
        boolean flipX;
        boolean flipY;

        public String toString() {
            return "TriTransformer{m=" + this.m + ", k=" + this.k + ", flipX=" + this.flipX + ", flipY=" + this.flipY + '}';
        }

        public TriTransformer(float f, float f2, boolean bl, boolean bl2) {
            this.m = f;
            this.k = f2;
            this.flipX = bl;
            this.flipY = bl2;
        }

        @Override
        public boolean shouldTransform(float f, float f2) {
            if (this.flipX) {
                f = 1.0f - f;
            }
            if (this.flipY) {
                f2 = 1.0f - f2;
            }
            return f < this.m || f2 < this.m || f + f2 > this.k;
        }

        @Override
        public float transformX(float f, float f2) {
            if (this.flipX) {
                f = 1.0f - f;
            }
            if (f < this.m) {
                return this.flipX ? 1.0f - this.m : this.m;
            }
            if (this.flipY) {
                f2 = 1.0f - f2;
            }
            if (f2 < this.m) {
                float f3 = MathHelper.clamp((float)f, (float)this.m, (float)(this.k - this.m));
                return this.flipX ? 1.0f - f3 : f3;
            }
            float f4 = this.k * f / (f + f2);
            return this.flipX ? 1.0f - f4 : f4;
        }

        @Override
        public float transformY(float f, float f2) {
            if (this.flipY) {
                f2 = 1.0f - f2;
            }
            if (f2 < this.m) {
                return this.flipY ? 1.0f - this.m : this.m;
            }
            if (this.flipX) {
                f = 1.0f - f;
            }
            if (f < this.m) {
                float f3 = MathHelper.clamp((float)f2, (float)this.m, (float)(this.k - this.m));
                return this.flipY ? 1.0f - f3 : f3;
            }
            float f4 = this.k * f2 / (f2 + f);
            return this.flipY ? 1.0f - f4 : f4;
        }
    }

    public static class TransformSquare
    implements ITransformer {
        float x0;
        float x1;
        float y0;
        float y1;

        public TransformSquare(float f, float f2, float f3, float f4) {
            this.x0 = f;
            this.x1 = f2;
            this.y0 = f3;
            this.y1 = f4;
        }

        @Override
        public boolean shouldTransform(float f, float f2) {
            return f < this.x0 || f > this.x1 || f2 < this.y0 || f2 > this.y1;
        }

        @Override
        public float transformX(float f, float f2) {
            return MathHelper.clamp((float)f, (float)this.x0, (float)this.x1);
        }

        @Override
        public float transformY(float f, float f2) {
            return MathHelper.clamp((float)f2, (float)this.y0, (float)this.y1);
        }

        public String toString() {
            return "TransformSquare{x0=" + this.x0 + ", x1=" + this.x1 + ", y0=" + this.y0 + ", y1=" + this.y1 + '}';
        }
    }

    public static interface ITransformer {
        public boolean shouldTransform(float var1, float var2);

        public float transformX(float var1, float var2);

        public float transformY(float var1, float var2);
    }

    public static class Quad {
        Vertex8[] verts;

        public Quad(Vertex8[] vertex8Array) {
            this.verts = vertex8Array;
        }

        public void sliceStretchDraw(int n, int n2, int n3, int n4, ITransformer[] iTransformerArray) {
            float[][] fArray = this.getUVTransform(this.verts, n4, n, n2, n3);
            if (fArray == null) {
                this.draw();
                return;
            }
            for (ITransformer iTransformer : iTransformerArray) {
                Quad quad = this.slice(n, n2, n3, n4, iTransformer, fArray);
                if (!quad.notEmpty()) continue;
                quad.draw();
            }
        }

        private boolean notEmpty() {
            Vertex8 vertex8 = this.verts[0];
            int n = 0;
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            for (int i = 1; i < 4; ++i) {
                Vertex8 vertex82 = this.verts[i];
                if (bl && Math.abs(vertex8.x - vertex82.x) > 1.0E-4f) {
                    bl = false;
                    n = (byte)(n + 1);
                }
                if (bl2 && Math.abs(vertex8.y - vertex82.y) > 1.0E-4f) {
                    bl2 = false;
                    n = (byte)(n + 1);
                }
                if (bl3 && Math.abs(vertex8.z - vertex82.z) > 1.0E-4f) {
                    bl3 = false;
                    n = (byte)(n + 1);
                }
                if (n <= true) continue;
                return true;
            }
            return false;
        }

        public Quad slice(int n, int n2, int n3, int n4, ITransformer iTransformer, float[][] fArray) {
            Vertex8[] vertex8Array = new Vertex8[this.verts.length];
            int n5 = n4 >> 1;
            for (int i = 0; i < this.verts.length; ++i) {
                float f;
                float f2;
                Vertex8 vertex8 = this.verts[i].copy();
                if (n5 == 0) {
                    f2 = vertex8.x - (float)n;
                    f = vertex8.z - (float)n3;
                } else if (n5 == 1) {
                    f2 = vertex8.x - (float)n;
                    f = vertex8.y - (float)n2;
                } else {
                    f2 = vertex8.z - (float)n3;
                    f = vertex8.y - (float)n2;
                }
                if (iTransformer.shouldTransform(f2, f)) {
                    float f3 = iTransformer.transformX(f2, f);
                    float f4 = iTransformer.transformY(f2, f);
                    if (n5 == 0) {
                        vertex8.x = (float)n + f3;
                        vertex8.z = (float)n3 + f4;
                    } else if (n5 == 1) {
                        vertex8.x = (float)n + f3;
                        vertex8.y = (float)n2 + f4;
                    } else {
                        vertex8.z = (float)n3 + f3;
                        vertex8.y = (float)n2 + f4;
                    }
                    if (fArray != null) {
                        float[] fArray2 = new float[8];
                        for (int j = 0; j < 8; ++j) {
                            fArray2[j] = fArray[0][j] + fArray[1][j] * f3 + fArray[2][j] * f4;
                        }
                        vertex8.reloadTex(fArray2);
                    }
                }
                vertex8Array[i] = vertex8;
            }
            return new Quad(vertex8Array);
        }

        public void draw() {
            for (Vertex8 vertex8 : this.verts) {
                vertex8.draw();
            }
        }

        public float[][] getUVTransform(Vertex8[] vertex8Array, int n, int n2, int n3, int n4) {
            int n5;
            Object object;
            float f;
            int n6 = n >> 1;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float[][] fArray = new float[3][8];
            for (Vertex8 vertex8 : vertex8Array) {
                float f8;
                f2 += 1.0f;
                if (n6 == 0) {
                    f = vertex8.x - (float)n2;
                    f8 = vertex8.z - (float)n4;
                } else if (n6 == 1) {
                    f = vertex8.x - (float)n2;
                    f8 = vertex8.y - (float)n3;
                } else {
                    f = vertex8.z - (float)n4;
                    f8 = vertex8.y - (float)n3;
                }
                f3 += f;
                f4 += f8;
                f5 += f * f8;
                f7 += f8 * f8;
                f6 += f * f;
                object = vertex8.buildTex();
                for (n5 = 0; n5 < ((float[])object).length; ++n5) {
                    float[] fArray2 = fArray[0];
                    int n7 = n5;
                    fArray2[n7] = fArray2[n7] + object[n5];
                    float[] fArray3 = fArray[1];
                    int n8 = n5;
                    fArray3[n8] = fArray3[n8] + object[n5] * f;
                    float[] fArray4 = fArray[2];
                    int n9 = n5;
                    fArray4[n9] = fArray4[n9] + object[n5] * f8;
                }
            }
            float f9 = f6 * f7 - f5 * f5;
            float f10 = f2 * f9 - (f6 * f4 * f4 + f7 * f3 * f3) + 2.0f * (f5 * f3 * f4);
            if (Math.abs(f10) <= 1.0E-4f) {
                return null;
            }
            f10 = 1.0f / f10;
            float f11 = (f5 * f4 - f7 * f3) * f10;
            float f12 = (f5 * f3 - f6 * f4) * f10;
            f = (f3 * f4 - f5 * f2) * f10;
            float[][] fArrayArray = new float[][]{{f9 * f10, f11, f12}, {f11, (f7 * f2 - f4 * f4) * f10, f}, {f12, f, (f6 * f2 - f3 * f3) * f10}};
            object = new float[3][8];
            for (n5 = 0; n5 < 3; ++n5) {
                for (int i = 0; i < 8; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        float f13 = object[n5];
                        int n10 = i;
                        f13[n10] = f13[n10] + fArrayArray[n5][j] * fArray[j][i];
                    }
                }
            }
            return object;
        }

        public String toString() {
            return String.format("Quad{%s}", Arrays.toString(this.verts));
        }
    }
}

