/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.Random;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.block.TileWaystone;
import net.blay09.mods.waystones.client.render.WaystoneBlockRenderer;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockWaystone
extends BlockContainer {
    public BlockWaystone() {
        super(Material.field_151576_e);
        this.func_149663_c("waystones:waystone");
        this.func_149711_c(5.0f);
        this.func_149752_b(2000.0f);
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public IIcon func_149691_a(int side, int metadata) {
        return Blocks.field_150348_b.func_149691_a(side, metadata);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return WaystoneBlockRenderer.RENDER_ID;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return metadata != ForgeDirection.UNKNOWN.ordinal() ? new TileWaystone() : null;
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        if (Waystones.getConfig().creativeModeOnly && !player.field_71075_bZ.field_75098_d) {
            return -1.0f;
        }
        return super.func_149737_a(player, world, x, y, z);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        Block blockBelow = world.func_147439_a(x, y - 1, z);
        if (blockBelow == this) {
            return false;
        }
        Block blockAbove = world.func_147439_a(x, y + 2, z);
        return blockAbove != this && super.func_149742_c(world, x, y, z) && world.func_147439_a(x, y + 1, z).isReplaceable((IBlockAccess)world, x, y + 1, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int orientation = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entityLiving);
        world.func_72921_c(x, y, z, orientation, 3);
        world.func_147465_d(x, y + 1, z, (Block)this, ForgeDirection.UNKNOWN.ordinal(), 3);
        if (world.field_72995_K && entityLiving instanceof EntityPlayer && (!Waystones.getConfig().creativeModeOnly || ((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d)) {
            Waystones.proxy.openWaystoneNameEdit((TileWaystone)world.func_147438_o(x, y, z));
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TileWaystone tileWaystone = this.getTileWaystone(world, x, y, z);
        if (tileWaystone != null) {
            WaystoneManager.removeServerWaystone(new WaystoneEntry(tileWaystone));
        }
        super.func_149749_a(world, x, y, z, block, metadata);
        if (world.func_147439_a(x, y + 1, z) == this) {
            world.func_147468_f(x, y + 1, z);
        } else if (world.func_147439_a(x, y - 1, z) == this) {
            world.func_147468_f(x, y - 1, z);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && (player.field_71075_bZ.field_75098_d || !Waystones.getConfig().creativeModeOnly)) {
            if (world.field_72995_K) {
                TileWaystone tileWaystone = this.getTileWaystone(world, x, y, z);
                if (tileWaystone == null) {
                    return true;
                }
                Waystones.proxy.openWaystoneNameEdit(tileWaystone);
            }
            return true;
        }
        if (!world.field_72995_K) {
            TileWaystone tileWaystone = this.getTileWaystone(world, x, y, z);
            if (tileWaystone == null) {
                return true;
            }
            ChatComponentText nameComponent = new ChatComponentText(tileWaystone.getWaystoneName());
            nameComponent.func_150256_b().func_150238_a(EnumChatFormatting.WHITE);
            ChatComponentTranslation chatComponent = new ChatComponentTranslation("waystones:activatedWaystone", new Object[]{nameComponent});
            chatComponent.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
            player.func_146105_b((IChatComponent)chatComponent);
            WaystoneManager.activateWaystone(player, tileWaystone);
            if (Waystones.getConfig().setSpawnPoint) {
                ForgeDirection facing = ForgeDirection.getOrientation((int)world.func_72805_g(tileWaystone.field_145851_c, tileWaystone.field_145848_d, tileWaystone.field_145849_e));
                player.func_71063_a(new ChunkCoordinates(tileWaystone.field_145851_c + facing.offsetX, tileWaystone.field_145848_d + facing.offsetY, tileWaystone.field_145849_e + facing.offsetZ), true);
            }
        } else {
            Waystones.proxy.playSound("random.levelup", 1.0f);
            for (int i = 0; i < 32; ++i) {
                world.func_72869_a("enchantmenttable", (double)x + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, (double)(y + 3), (double)z + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, 0.0, -5.0, 0.0);
                world.func_72869_a("enchantmenttable", (double)x + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, (double)(y + 4), (double)z + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, 0.0, -5.0, 0.0);
            }
        }
        return true;
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (!WaystoneConfig.disableParticles && random.nextFloat() < 0.75f) {
            TileWaystone tileWaystone = this.getTileWaystone(world, x, y, z);
            if (tileWaystone == null) {
                return;
            }
            if (WaystoneManager.getKnownWaystone(tileWaystone.getWaystoneName()) != null || WaystoneManager.getServerWaystone(tileWaystone.getWaystoneName()) != null) {
                world.func_72869_a("portal", (double)x + 0.5 + (random.nextDouble() - 0.5) * 1.5, (double)y + 0.5, (double)z + 0.5 + (random.nextDouble() - 0.5) * 1.5, 0.0, 0.0, 0.0);
                world.func_72869_a("enchantmenttable", (double)x + 0.5 + (random.nextDouble() - 0.5) * 1.5, (double)y + 0.5, (double)z + 0.5 + (random.nextDouble() - 0.5) * 1.5, 0.0, 0.0, 0.0);
            }
        }
    }

    public TileWaystone getTileWaystone(World world, int x, int y, int z) {
        TileWaystone tileWaystone = (TileWaystone)world.func_147438_o(x, y, z);
        if (tileWaystone == null) {
            TileEntity tileBelow = world.func_147438_o(x, y - 1, z);
            if (tileBelow instanceof TileWaystone) {
                return (TileWaystone)tileBelow;
            }
            return null;
        }
        return tileWaystone;
    }
}

