/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mca.enums.EnumMemorialType;
import mca.tile.TileMemorial;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import radixcore.packets.AbstractPacket;
import radixcore.util.BlockHelper;

public class PacketMemorialUpdateSet
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketMemorialUpdateSet, IMessage> {
    private int x;
    private int y;
    private int z;
    private int type;

    public PacketMemorialUpdateSet() {
    }

    public PacketMemorialUpdateSet(TileMemorial memorial) {
        this.x = memorial.field_145851_c;
        this.y = memorial.field_145848_d;
        this.z = memorial.field_145849_e;
        this.type = memorial.getType().getId();
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.x = byteBuf.readInt();
        this.y = byteBuf.readInt();
        this.z = byteBuf.readInt();
        this.type = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.x);
        byteBuf.writeInt(this.y);
        byteBuf.writeInt(this.z);
        byteBuf.writeInt(this.type);
    }

    public IMessage onMessage(PacketMemorialUpdateSet packet, MessageContext context) {
        EntityPlayer player = this.getPlayer(context);
        World world = player.field_70170_p;
        try {
            TileMemorial memorial = (TileMemorial)BlockHelper.getTileEntity((World)world, (int)packet.x, (int)packet.y, (int)packet.z);
            if (memorial != null) {
                memorial.setType(EnumMemorialType.fromId(packet.type));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }
}

