/*
 * Decompiled with CFR 0.152.
 */
package mca.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mca.core.MCA;
import mca.core.minecraft.ModItems;
import mca.enums.EnumReaperAttackState;
import mca.packets.PacketSpawnLightning;
import mca.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import radixcore.math.Point3D;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;

public class EntityGrimReaper
extends EntityMob
implements IBossDisplayData {
    private int healingCooldown;
    private int timesHealed;
    @SideOnly(value=Side.CLIENT)
    private float floatingTicks;

    public EntityGrimReaper(World world) {
        super(world);
        this.func_70105_a(1.0f, 2.6f);
        this.field_70728_aV = 100;
    }

    protected final void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(225.0);
    }

    public IChatComponent func_145748_c_() {
        return new ChatComponentText("Grim Reaper");
    }

    public boolean func_70650_aV() {
        return false;
    }

    protected void func_70628_a(boolean hitByPlayer, int lootingLvl) {
        this.func_145779_a(ModItems.staffOfLife, 1);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)0);
        this.field_70180_af.func_75682_a(14, (Object)0);
    }

    public void setAttackState(EnumReaperAttackState state) {
        if (this.field_70180_af.func_75679_c(13) != state.getId()) {
            this.field_70180_af.func_75692_b(13, (Object)state.getId());
            switch (state) {
                case PRE: {
                    this.func_85030_a("mca:reaper.scythe.out", 1.0f, 1.0f);
                    break;
                }
                case POST: {
                    this.func_85030_a("mca:reaper.scythe.swing", 1.0f, 1.0f);
                }
            }
        }
    }

    public EnumReaperAttackState getAttackState() {
        return EnumReaperAttackState.fromId(this.field_70180_af.func_75679_c(13));
    }

    public boolean hasEntitytoAttack() {
        return this.field_70789_a != null;
    }

    public void func_70077_a(EntityLightningBolt entity) {
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == DamageSource.field_76368_d || source == DamageSource.field_76370_b || source.func_94541_c() || source == DamageSource.field_76372_a) {
            if (source == DamageSource.field_76368_d) {
                this.teleportTo(this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v);
            }
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.getAttackState() == EnumReaperAttackState.BLOCK && source.func_76364_f() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76364_f();
            double deltaX = this.field_70165_t - player.field_70165_t;
            double deltaZ = this.field_70161_v - player.field_70161_v;
            this.func_85030_a("mca:reaper.block", 1.0f, 1.0f);
            this.teleportTo(player.field_70165_t - deltaX * 2.0, player.field_70163_u + 2.0, this.field_70161_v - deltaZ * 2.0);
            this.setStateTransitionCooldown(0);
            return false;
        }
        if (!this.field_70170_p.field_72995_K && source.func_76364_f() instanceof EntityPlayer && RadixLogic.getBooleanWithProbability((int)30)) {
            EntityPlayer player = (EntityPlayer)source.func_76364_f();
            double deltaX = this.field_70165_t - player.field_70165_t;
            double deltaZ = this.field_70161_v - player.field_70161_v;
            this.teleportTo(player.field_70165_t - deltaX * 2.0, player.field_70163_u + 2.0, this.field_70161_v - deltaZ * 2.0);
        } else {
            if (source.func_76364_f() instanceof EntityArrow) {
                EntityArrow arrow = (EntityArrow)source.func_76364_f();
                if (arrow.field_70250_c instanceof EntityPlayer && this.getAttackState() != EnumReaperAttackState.REST) {
                    EntityPlayer player = (EntityPlayer)arrow.field_70250_c;
                    double newX = player.field_70165_t + (double)(RadixLogic.getBooleanWithProbability((int)50) ? 2 : -2);
                    double newZ = player.field_70161_v + (double)(RadixLogic.getBooleanWithProbability((int)50) ? 2 : -2);
                    this.teleportTo(newX, player.field_70163_u, newZ);
                }
                arrow.func_70106_y();
                return false;
            }
            if (this.getAttackState() == EnumReaperAttackState.REST) {
                damage /= 3.0f;
            }
        }
        super.func_70097_a(source, damage);
        if (!this.field_70170_p.field_72995_K && (double)this.func_110143_aJ() <= this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() / 2.0 && this.healingCooldown == 0) {
            this.setAttackState(EnumReaperAttackState.REST);
            this.healingCooldown = 3000;
            this.teleportTo(this.field_70165_t, this.field_70163_u + 8.0, this.field_70161_v);
            this.setStateTransitionCooldown(1200);
        }
        return true;
    }

    protected void func_70785_a(Entity entity, float damage) {
        if (RadixMath.getDistanceToEntity((Entity)this.field_70789_a, (Entity)this) <= 1.8) {
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 13.5f);
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, this.field_70170_p.field_73013_u.func_151525_a() * 20, 1));
            }
            this.setAttackState(EnumReaperAttackState.POST);
            this.setStateTransitionCooldown(10);
        }
        if (this.getStateTransitionCooldown() == 0) {
            if (RadixMath.getDistanceToEntity((Entity)this.field_70789_a, (Entity)this) <= 3.5) {
                if (this.field_70789_a instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)this.field_70789_a;
                    if (player.func_70632_aY()) {
                        double dX = this.field_70165_t - player.field_70165_t;
                        double dZ = this.field_70161_v - player.field_70161_v;
                        this.teleportTo(player.field_70165_t - dX * 2.0, player.field_70163_u + 2.0, this.field_70161_v - dZ * 2.0);
                        if (!this.field_70170_p.field_72995_K && RadixLogic.getBooleanWithProbability((int)20)) {
                            ItemStack randomItemStack;
                            int currentItem = player.field_71071_by.field_70461_c;
                            int randomItem = this.field_70146_Z.nextInt(InventoryPlayer.func_70451_h());
                            ItemStack currentItemStack = player.field_71071_by.field_70462_a[currentItem];
                            player.field_71071_by.field_70462_a[currentItem] = randomItemStack = player.field_71071_by.field_70462_a[randomItem];
                            player.field_71071_by.field_70462_a[randomItem] = currentItemStack;
                            player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, this.field_70170_p.field_73013_u.func_151525_a() * 40, 1));
                        }
                    } else if (RadixLogic.getBooleanWithProbability((int)40) && this.getAttackState() != EnumReaperAttackState.PRE) {
                        this.setStateTransitionCooldown(20);
                        this.setAttackState(EnumReaperAttackState.BLOCK);
                    } else {
                        this.setAttackState(EnumReaperAttackState.PRE);
                    }
                }
            } else {
                this.setAttackState(EnumReaperAttackState.IDLE);
            }
        }
    }

    protected Entity func_70782_k() {
        return this.field_70170_p.func_72856_b((Entity)this, 48.0);
    }

    public int func_70627_aG() {
        return 300;
    }

    protected String func_70639_aQ() {
        return "mca:reaper.idle";
    }

    protected String func_70673_aS() {
        return "mca:reaper.death";
    }

    protected String func_70621_aR() {
        return "mob.wither.hurt";
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70066_B();
        if (this.field_70170_p.field_72995_K && this.getAttackState() == EnumReaperAttackState.REST) {
            this.floatingTicks += 0.1f;
            Utilities.spawnParticlesAroundEntityC("depthsuspend", (Entity)this, 1);
            Utilities.spawnParticlesAroundEntityC("magicCrit", (Entity)this, 1);
        }
        if (this.getAttackState() == EnumReaperAttackState.REST) {
            if (!this.field_70170_p.field_72995_K && this.getStateTransitionCooldown() == 1) {
                this.setAttackState(EnumReaperAttackState.IDLE);
                ++this.timesHealed;
            } else if (!this.field_70170_p.field_72995_K && this.getStateTransitionCooldown() % 100 == 0) {
                this.func_70606_j(this.func_110143_aJ() + MathHelper.func_76131_a((float)(10.5f - (float)this.timesHealed * 3.5f), (float)3.0f, (float)10.5f));
                int dX = this.field_70146_Z.nextInt(8) + 4 * (RadixLogic.getBooleanWithProbability((int)50) ? 1 : -1);
                int dZ = this.field_70146_Z.nextInt(8) + 4 * (RadixLogic.getBooleanWithProbability((int)50) ? 1 : -1);
                int y = RadixLogic.getSpawnSafeTopLevel((World)this.field_70170_p, (int)((int)this.field_70165_t + dX), (int)((int)this.field_70161_v + dZ));
                MCA.getPacketHandler().sendPacketToAllPlayers(new PacketSpawnLightning(new Point3D(this.field_70165_t + (double)dX, (double)y, this.field_70161_v + (double)dZ)));
                if (!this.field_70170_p.field_72995_K) {
                    EntityZombie mob = RadixLogic.getBooleanWithProbability((int)50) ? new EntityZombie(this.field_70170_p) : new EntitySkeleton(this.field_70170_p);
                    mob.func_70107_b(this.field_70165_t + (double)dX + 4.0, (double)y, this.field_70161_v + (double)dZ + 4.0);
                    if (mob instanceof EntitySkeleton) {
                        mob.func_70062_b(0, new ItemStack((Item)Items.field_151031_f));
                    }
                    this.field_70170_p.func_72838_d((Entity)mob);
                }
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            return;
        }
        if (this.getAttackState() == EnumReaperAttackState.REST) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        this.field_70143_R = 0.0f;
        if (this.field_70181_x > 0.0) {
            this.field_70181_x *= (double)1.04f;
        } else {
            double yMod = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            this.field_70181_x = this.field_70181_x * (double)0.6f + yMod * (double)0.3f;
        }
        if (this.getStateTransitionCooldown() > 0) {
            this.setStateTransitionCooldown(this.getStateTransitionCooldown() - 1);
        }
        if (this.healingCooldown > 0) {
            --this.healingCooldown;
        }
        if (this.field_70789_a != null && this.field_70789_a.field_70128_L) {
            this.field_70789_a = null;
            this.setAttackState(EnumReaperAttackState.IDLE);
        }
        if (this.field_70789_a != null && this.getAttackState() != EnumReaperAttackState.REST) {
            double sqDistanceTo = Math.sqrt(Math.pow(this.field_70789_a.field_70165_t - this.field_70165_t, 2.0) + Math.pow(this.field_70789_a.field_70161_v - this.field_70161_v, 2.0));
            float moveAmount = 0.0f;
            if (sqDistanceTo < 8.0) {
                moveAmount = (8.0f - (float)sqDistanceTo) / 8.0f * 4.0f;
            }
            if (this.field_70789_a.field_70163_u + (double)0.2f < this.field_70163_u) {
                this.field_70181_x -= (double)(0.05f * moveAmount);
            }
            if (this.field_70789_a.field_70163_u - 0.5 > this.field_70163_u) {
                this.field_70181_x += (double)(0.01f * moveAmount);
            }
            if (this.getAttackState() == EnumReaperAttackState.PRE) {
                this.field_70159_w *= (double)1.4f;
                this.field_70179_y *= (double)1.4f;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            List grassBlocks = RadixLogic.getNearbyBlocks((Entity)this, (Block)Blocks.field_150349_c, (int)1);
            for (Point3D point : grassBlocks) {
                BlockHelper.setBlock((World)this.field_70170_p, (Point3D)point, (Block)Blocks.field_150346_d);
                Block blockAbove = BlockHelper.getBlock((World)this.field_70170_p, (int)point.iPosX, (int)(point.iPosY + 1), (int)point.iPosZ);
                if (blockAbove.func_149688_o() != Material.field_151585_k && blockAbove.func_149688_o() != Material.field_151582_l) continue;
                BlockHelper.setBlock((World)this.field_70170_p, (int)point.iPosX, (int)(point.iPosY + 1), (int)point.iPosZ, (Block)Blocks.field_150350_a, (int)0);
            }
        }
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
    }

    public String func_70005_c_() {
        return "Grim Reaper";
    }

    protected boolean func_70692_ba() {
        return true;
    }

    public void setStateTransitionCooldown(int value) {
        this.field_70180_af.func_75692_b(14, (Object)value);
    }

    public int getStateTransitionCooldown() {
        return this.field_70180_af.func_75679_c(14);
    }

    @SideOnly(value=Side.CLIENT)
    public float getFloatingTicks() {
        return this.floatingTicks;
    }

    private void teleportTo(double x, double y, double z) {
        if (!this.field_70170_p.field_72995_K) {
            Utilities.spawnParticlesAroundEntityS("portal", (Entity)this, 16);
            this.func_85030_a("mob.endermen.portal", 2.0f, 1.0f);
            this.func_70107_b(x, y, z);
            this.func_85030_a("mob.endermen.portal", 2.0f, 1.0f);
            Utilities.spawnParticlesAroundEntityS("portal", (Entity)this, 16);
        }
    }
}

