/*
 * Decompiled with CFR 0.152.
 */
package mca.data;

import java.io.Serializable;
import java.util.UUID;
import mca.entity.EntityHuman;
import mca.enums.EnumBabyState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class VillagerSaveData
implements Serializable {
    public final UUID uuid;
    public final UUID ownerUUID;
    public final String name;
    public final String headTexture;
    public final String clothesTexture;
    public final int professionId;
    public final int personalityId;
    public final int permanentId;
    public final boolean isMale;
    public final boolean isEngaged;
    public final int spouseId;
    public final String spouseName;
    public final int babyState;
    public final boolean isChild;
    public final int age;
    public final String parentNames;
    public final String parentIDs;
    public final String parentsGenders;
    public final float scaleHeight;
    public final float scaleGirth;
    public final boolean isInfected;
    public final String playerSkinUsername;
    public final String displayTitle;

    public static VillagerSaveData fromVillager(EntityHuman human, EntityPlayer requestingPlayer, UUID ownerUUID) {
        return new VillagerSaveData(human, requestingPlayer, ownerUUID);
    }

    public static VillagerSaveData fromNBT(NBTTagCompound nbt) {
        return new VillagerSaveData(nbt);
    }

    public EntityHuman applyToHuman(EntityHuman human) {
        human.setName(this.name);
        human.setPersonality(this.personalityId);
        human.setPermanentId(this.permanentId);
        human.setIsMale(this.isMale);
        human.setIsEngaged(this.isEngaged);
        human.setSpouseId(this.spouseId);
        human.setSpouseName(this.spouseName);
        human.setBabyState(EnumBabyState.fromId(this.babyState));
        human.setIsChild(this.isChild);
        human.setAge(this.age);
        human.setParentNames(this.parentNames);
        human.setParentIDs(this.parentIDs);
        human.setParentsGenders(this.parentsGenders);
        human.setHeight(this.scaleHeight);
        human.setGirth(this.scaleGirth);
        human.setIsInfected(this.isInfected);
        human.setPlayerSkin(this.playerSkinUsername);
        human.setProfessionId(this.professionId);
        human.setClothesTexture(this.clothesTexture);
        human.setHeadTexture(this.headTexture);
        return human;
    }

    private VillagerSaveData(EntityHuman human, EntityPlayer requestingPlayer, UUID ownerUUID) {
        this.uuid = human.func_110124_au();
        this.ownerUUID = ownerUUID != null ? ownerUUID : new UUID(0L, 0L);
        this.name = human.getName();
        this.headTexture = human.getHeadTexture();
        this.clothesTexture = human.getClothesTexture();
        this.professionId = human.func_70946_n();
        this.personalityId = human.getPersonality().getId();
        this.permanentId = human.getPermanentId();
        this.isMale = human.getIsMale();
        this.isEngaged = human.getIsEngaged();
        this.spouseId = human.getSpouseId();
        this.spouseName = human.getSpouseName();
        this.babyState = human.getBabyState().getId();
        this.isChild = human.getIsChild();
        this.age = human.func_70654_ax();
        this.parentNames = human.getParentNames();
        this.parentIDs = human.getParentIds();
        this.parentsGenders = human.getParentsGenders();
        this.scaleHeight = human.getHeight();
        this.scaleGirth = human.getGirth();
        this.isInfected = human.getIsInfected();
        this.playerSkinUsername = human.getPlayerSkinUsername();
        this.displayTitle = requestingPlayer != null ? human.getTitle(requestingPlayer) : this.name;
    }

    private VillagerSaveData(NBTTagCompound nbt) {
        long msb = nbt.func_74763_f("uuid-msb");
        long lsb = nbt.func_74763_f("uuid-lsb");
        long ownerMSB = nbt.func_74763_f("owner-uuid-msb");
        long ownerLSB = nbt.func_74763_f("owner-uuid-lsb");
        this.uuid = new UUID(msb, lsb);
        this.ownerUUID = new UUID(ownerMSB, ownerLSB);
        this.name = nbt.func_74779_i("name");
        this.headTexture = nbt.func_74779_i("headTexture");
        this.clothesTexture = nbt.func_74779_i("clothesTexture");
        this.professionId = nbt.func_74762_e("professionId");
        this.personalityId = nbt.func_74762_e("personalityId");
        this.permanentId = nbt.func_74762_e("permanentId");
        this.isMale = nbt.func_74767_n("isMale");
        this.isEngaged = nbt.func_74767_n("isEngaged");
        this.spouseId = nbt.func_74762_e("spouseId");
        this.spouseName = nbt.func_74779_i("spouseName");
        this.babyState = nbt.func_74762_e("babyState");
        this.isChild = nbt.func_74767_n("isChild");
        this.age = nbt.func_74762_e("age");
        this.parentNames = nbt.func_74779_i("parentNames");
        this.parentIDs = nbt.func_74779_i("parentIDs");
        this.parentsGenders = nbt.func_74779_i("parentsGenders");
        this.scaleHeight = nbt.func_74760_g("scaleHeight");
        this.scaleGirth = nbt.func_74760_g("scaleGirth");
        this.isInfected = nbt.func_74767_n("isInfected");
        this.playerSkinUsername = nbt.func_74779_i("playerSkinUsername");
        this.displayTitle = nbt.func_74779_i("displayTitle");
    }

    public void writeDataToNBT(NBTTagCompound nbt) {
        nbt.func_74772_a("uuid-msb", this.uuid.getMostSignificantBits());
        nbt.func_74772_a("uuid-lsb", this.uuid.getLeastSignificantBits());
        nbt.func_74772_a("owner-uuid-msb", this.ownerUUID.getMostSignificantBits());
        nbt.func_74772_a("owner-uuid-lsb", this.ownerUUID.getLeastSignificantBits());
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("headTexture", this.headTexture);
        nbt.func_74778_a("clothesTexture", this.clothesTexture);
        nbt.func_74768_a("professionId", this.professionId);
        nbt.func_74768_a("personalityId", this.personalityId);
        nbt.func_74768_a("permanentId", this.permanentId);
        nbt.func_74757_a("isMale", this.isMale);
        nbt.func_74757_a("isEngaged", this.isEngaged);
        nbt.func_74768_a("spouseId", this.spouseId);
        nbt.func_74778_a("spouseName", this.spouseName);
        nbt.func_74768_a("babyState", this.babyState);
        nbt.func_74757_a("isChild", this.isChild);
        nbt.func_74768_a("age", this.age);
        nbt.func_74778_a("parentNames", this.parentNames);
        nbt.func_74778_a("parentIDs", this.parentIDs);
        nbt.func_74778_a("parentsGenders", this.parentsGenders);
        nbt.func_74776_a("scaleHeight", this.scaleHeight);
        nbt.func_74776_a("scaleGirth", this.scaleGirth);
        nbt.func_74757_a("isInfected", this.isInfected);
        nbt.func_74778_a("playerSkinUsername", this.playerSkinUsername);
        nbt.func_74778_a("displayTitle", this.displayTitle);
    }
}

