/*
 * Decompiled with CFR 0.152.
 */
package mca.data;

import cpw.mods.fml.common.ModMetadata;
import mca.core.MCA;
import mca.entity.EntityHuman;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import radixcore.data.AbstractPlayerData;
import radixcore.data.WatchedBoolean;
import radixcore.data.WatchedInt;
import radixcore.data.WatchedString;
import radixcore.util.RadixLogic;

public class PlayerData
extends AbstractPlayerData {
    public static final long serialVersionUID = 1L;
    protected WatchedInt permanentId;
    protected WatchedInt spousePermanentId;
    protected WatchedInt heirPermanentId;
    protected WatchedInt genderPreference;
    protected WatchedBoolean isMale;
    protected WatchedBoolean shouldHaveBaby;
    protected WatchedBoolean isEngaged;
    protected WatchedBoolean isInLiteMode;
    protected WatchedBoolean isMonarch;
    protected WatchedBoolean hasChosenDestiny;
    protected WatchedString mcaName;
    protected WatchedString spouseName;
    protected WatchedBoolean isSuperUser;

    public PlayerData(String playerUUID, World world) {
        super(playerUUID, "MCA", world);
    }

    public PlayerData(EntityPlayer player) {
        super(player, "MCA");
    }

    public ModMetadata getModMetadata() {
        return MCA.getMetadata();
    }

    public void instantiateData() {
        this.permanentId = new WatchedInt(0, 1, this.dataWatcher);
        this.spousePermanentId = new WatchedInt(0, 2, this.dataWatcher);
        this.heirPermanentId = new WatchedInt(0, 3, this.dataWatcher);
        this.genderPreference = new WatchedInt(1, 12, this.dataWatcher);
        this.isMale = new WatchedBoolean(true, 4, this.dataWatcher);
        this.shouldHaveBaby = new WatchedBoolean(false, 5, this.dataWatcher);
        this.isEngaged = new WatchedBoolean(false, 6, this.dataWatcher);
        this.isInLiteMode = new WatchedBoolean(false, 7, this.dataWatcher);
        this.isMonarch = new WatchedBoolean(false, 8, this.dataWatcher);
        this.mcaName = new WatchedString(this.owner != null ? this.owner.func_70005_c_() : "none", 9, this.dataWatcher);
        this.hasChosenDestiny = new WatchedBoolean(false, 11, this.dataWatcher);
        this.isSuperUser = new WatchedBoolean(false, 13, this.dataWatcher);
        this.spouseName = new WatchedString("none", 14, this.dataWatcher);
    }

    public void initializeNewData(EntityPlayer player) {
        this.permanentId.setValue((Object)RadixLogic.generatePermanentEntityId((Entity)player));
    }

    public void dumpToConsole() {
        MCA.getLog().info("--------PLAYER DATA DUMP--------");
        MCA.getLog().info("Owner: " + this.owner);
        MCA.getLog().info("Owner's Identity: " + this.ownerIdentifier);
        MCA.getLog().info("Permanent ID: " + this.getPermanentId());
        MCA.getLog().info("Spouse Permanent ID: " + this.getSpousePermanentId());
        MCA.getLog().info("Heir Permanent ID: " + this.getHeirPermanentId());
        MCA.getLog().info("Is Male: " + this.isMale.getBoolean());
        MCA.getLog().info("Should Have Baby: " + this.getShouldHaveBaby());
        MCA.getLog().info("Is Engaged: " + this.getIsEngaged());
        MCA.getLog().info("Is In Lite Mode: " + this.isInLiteMode.getBoolean());
        MCA.getLog().info("Is Monarch: " + this.isMonarch.getBoolean());
        MCA.getLog().info("MCA Name: " + this.mcaName.getString());
    }

    public int getPermanentId() {
        return this.permanentId.getInt();
    }

    public int getSpousePermanentId() {
        return this.spousePermanentId.getInt();
    }

    public int getHeirPermanentId() {
        return this.heirPermanentId.getInt();
    }

    public void setHeir(EntityHuman heirInstance) {
        this.heirPermanentId.setValue((Object)heirInstance.getPermanentId());
    }

    public int getGenderPreference() {
        return this.genderPreference.getInt();
    }

    public void setGenderPreference(int value) {
        this.genderPreference.setValue((Object)value);
    }

    public boolean getIsMale() {
        return this.isMale.getBoolean();
    }

    public void setIsMale(boolean value) {
        this.isMale.setValue((Object)value);
    }

    public boolean getShouldHaveBaby() {
        return this.shouldHaveBaby.getBoolean();
    }

    public void setShouldHaveBaby(boolean value) {
        this.shouldHaveBaby.setValue((Object)value);
    }

    public void setSpousePermanentId(int value) {
        this.spousePermanentId.setValue((Object)value);
    }

    public boolean getIsEngaged() {
        return this.isEngaged.getBoolean();
    }

    public boolean getIsInLiteMode() {
        return this.isInLiteMode.getBoolean();
    }

    public void setIsInLiteMode(boolean value) {
        this.isInLiteMode.setValue((Object)value);
    }

    public boolean getIsMonarch() {
        return this.isMonarch.getBoolean();
    }

    public void setIsMonarch(boolean value) {
        this.isMonarch.setValue((Object)value);
    }

    public boolean getHasChosenDestiny() {
        return this.hasChosenDestiny.getBoolean();
    }

    public void setHasChosenDestiny(boolean value) {
        this.hasChosenDestiny.setValue((Object)value);
    }

    public String getMcaName() {
        return this.mcaName.getString();
    }

    public void setMcaName(String value) {
        this.mcaName.setValue((Object)value);
    }

    public String getSpouseName() {
        return this.spouseName.getString();
    }

    public void setSpouseName(String value) {
        this.spouseName.setValue((Object)value);
    }

    public boolean getIsSuperUser() {
        return this.isSuperUser.getBoolean();
    }

    public void setIsSuperUser(boolean value) {
        this.isSuperUser.setValue((Object)value);
    }

    public boolean getIsMarried() {
        return this.spousePermanentId.getInt() != 0 && !this.getIsEngaged();
    }

    public void setIsEngaged(boolean value) {
        this.isEngaged.setValue((Object)value);
    }
}

