/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import drzhark.mocreatures.MoCPetData;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.IMoCTameable;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MoCMessageUpdatePetName
implements IMessage,
IMessageHandler<MoCMessageUpdatePetName, IMessage> {
    String name;
    int entityId;

    public MoCMessageUpdatePetName() {
    }

    public MoCMessageUpdatePetName(int entityId) {
        this.entityId = entityId;
    }

    public MoCMessageUpdatePetName(int entityId, String name) {
        this.entityId = entityId;
        this.name = name;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(MoCMessageUpdatePetName.findByteLengthOfString(this.name));
        buffer.writeBytes(StandardCharsets.UTF_8.encode(this.name));
        buffer.writeInt(this.entityId);
    }

    public static int findByteLengthOfString(String string) {
        char[] characterArray;
        int byteLength = 0;
        for (char character : characterArray = string.toCharArray()) {
            Character.UnicodeScript scriptThatCharacterIsWrittenIn = Character.UnicodeScript.of(character);
            if (scriptThatCharacterIsWrittenIn == Character.UnicodeScript.LATIN) {
                ++byteLength;
            }
            if (Character.UnicodeBlock.of(character) == Character.UnicodeBlock.LATIN_1_SUPPLEMENT) {
                byteLength += Character.charCount(Character.getNumericValue(character));
            }
            if (scriptThatCharacterIsWrittenIn == Character.UnicodeScript.GREEK || scriptThatCharacterIsWrittenIn == Character.UnicodeScript.CYRILLIC || scriptThatCharacterIsWrittenIn == Character.UnicodeScript.ARABIC || scriptThatCharacterIsWrittenIn == Character.UnicodeScript.HEBREW) {
                byteLength += 2;
            }
            if (scriptThatCharacterIsWrittenIn != Character.UnicodeScript.HAN && scriptThatCharacterIsWrittenIn != Character.UnicodeScript.HIRAGANA && scriptThatCharacterIsWrittenIn != Character.UnicodeScript.KATAKANA && scriptThatCharacterIsWrittenIn != Character.UnicodeScript.HANGUL && scriptThatCharacterIsWrittenIn != Character.UnicodeScript.THAI && scriptThatCharacterIsWrittenIn != Character.UnicodeScript.DEVANAGARI && Character.UnicodeBlock.of(character) != Character.UnicodeBlock.CJK_COMPATIBILITY && Character.UnicodeBlock.of(character) != Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS && Character.UnicodeBlock.of(character) != Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS && Character.UnicodeBlock.of(character) != Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT && Character.UnicodeBlock.of(character) != Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT && Character.UnicodeBlock.of(character) != Character.UnicodeBlock.CJK_STROKES && Character.UnicodeBlock.of(character) != Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION && Character.UnicodeBlock.of(character) != Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS && Character.UnicodeBlock.of(character) != Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A && Character.UnicodeBlock.of(character) != Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B && Character.UnicodeBlock.of(character) != Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C && Character.UnicodeBlock.of(character) != Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D && Character.UnicodeBlock.of(character) != Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS) continue;
            byteLength += 3;
        }
        return byteLength;
    }

    public void fromBytes(ByteBuf buffer) {
        int nameLength = buffer.readInt();
        this.name = new String(buffer.readBytes(nameLength).array(), StandardCharsets.UTF_8);
        this.entityId = buffer.readInt();
    }

    public IMessage onMessage(MoCMessageUpdatePetName message, MessageContext context) {
        MoCPetData petData;
        Entity pet = null;
        List entityList = context.getServerHandler().field_147369_b.field_70170_p.field_72996_f;
        String ownerName = "";
        for (Entity entity : entityList) {
            if (entity.func_145782_y() != message.entityId || !(entity instanceof IMoCTameable)) continue;
            ((IMoCEntity)entity).setName(message.name);
            ownerName = ((IMoCEntity)entity).getOwnerName();
            pet = entity;
            break;
        }
        if ((petData = MoCreatures.instance.mapData.getPetData(ownerName)) != null && pet != null && ((IMoCTameable)pet).getOwnerPetId() != -1) {
            int id = ((IMoCTameable)pet).getOwnerPetId();
            NBTTagList tag = petData.getOwnerRootNBT().func_150295_c("TamedList", 10);
            for (int index = 0; index < tag.func_74745_c(); ++index) {
                NBTTagCompound nbt = tag.func_150305_b(index);
                if (nbt.func_74762_e("PetId") != id) continue;
                nbt.func_74778_a("Name", message.name);
                ((IMoCTameable)pet).setName(message.name);
            }
        }
        return null;
    }

    public String toString() {
        return String.format("MoCMessageUpdatePetName - entityId:%s, name:%s", this.entityId, this.name);
    }
}

