/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import drzhark.mocreatures.MoCPetData;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.animal.MoCEntityHorse;
import drzhark.mocreatures.item.MoCItem;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAppear;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class MoCItemHorseAmulet
extends MoCItem {
    private int ageCounter;
    private String name;
    private float maxHealth;
    private float health;
    private int age;
    private int creatureType;
    private int spawnClass;
    private boolean isRideable;
    private byte armor;
    private boolean isAdult;
    private String ownerName;
    private int petId;

    public MoCItemHorseAmulet(String name) {
        super(name);
        this.field_77777_bU = 1;
        this.func_77627_a(true);
        this.ageCounter = 0;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World worldObj, EntityPlayer entityPlayer) {
        if (this.ownerName.length() > 0 && !this.ownerName.equals(entityPlayer.func_70005_c_()) && MoCreatures.instance.mapData != null) {
            return itemStack;
        }
        if (++this.ageCounter < 2) {
            return itemStack;
        }
        int amuletDurability = itemStack.func_77960_j();
        if (MoCreatures.isServer()) {
            this.initAndReadNBT(itemStack);
        }
        if (this.spawnClass == 21 || this.spawnClass == 0) {
            this.spawnClass = 22;
            if (this.spawnClass == 0 || this.creatureType == 0) {
                this.creatureType = amuletDurability;
                this.spawnClass = 22;
                this.age = 100;
                this.maxHealth = 20.0f;
                this.health = 20.0f;
                this.armor = 0;
                this.name = "";
                this.ownerName = "";
                this.isRideable = false;
                this.isAdult = true;
            }
        }
        if (amuletDurability != 0) {
            double dist = 3.0;
            double newPosY = entityPlayer.field_70163_u;
            double newPosX = entityPlayer.field_70165_t - dist * Math.cos(MoCTools.realAngle(entityPlayer.field_70177_z - 90.0f) / 57.29578f);
            double newPosZ = entityPlayer.field_70161_v - dist * Math.sin(MoCTools.realAngle(entityPlayer.field_70177_z - 90.0f) / 57.29578f);
            if (MoCreatures.isServer()) {
                try {
                    MoCEntityHorse storedCreature = new MoCEntityHorse(worldObj);
                    storedCreature.func_70107_b(newPosX, newPosY, newPosZ);
                    storedCreature.setType(this.creatureType);
                    storedCreature.setTamed(true);
                    ((MoCEntityAnimal)storedCreature).setRideable(this.isRideable);
                    storedCreature.setMoCAge(this.age);
                    storedCreature.setName(this.name);
                    ((MoCEntityAnimal)storedCreature).setArmorType(this.armor);
                    storedCreature.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.maxHealth);
                    storedCreature.func_70606_j(this.health);
                    storedCreature.setAdult(this.isAdult);
                    storedCreature.setOwnerPetId(this.petId);
                    storedCreature.setOwner(entityPlayer.func_70005_c_());
                    if (entityPlayer.field_70170_p.func_72838_d((Entity)storedCreature)) {
                        MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAppear(storedCreature.func_145782_y()), new NetworkRegistry.TargetPoint(entityPlayer.field_70170_p.field_73011_w.field_76574_g, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, 64.0));
                        MoCTools.playCustomSound((Entity)storedCreature, "appearmagic", worldObj);
                        if (this.creatureType == 26 || this.creatureType == 27 || this.creatureType == 28) {
                            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(MoCreatures.amuletBone, 1, 0));
                        } else if (this.creatureType == 21 || this.creatureType == 22) {
                            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(MoCreatures.amuletGhost, 1, 0));
                        } else if (this.creatureType > 47 && this.creatureType < 60) {
                            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(MoCreatures.amuletFairy, 1, 0));
                        } else if (this.creatureType == 39 || this.creatureType == 40) {
                            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(MoCreatures.amuletPegasus, 1, 0));
                        }
                        MoCPetData petData = MoCreatures.instance.mapData.getPetData(storedCreature.getOwnerName());
                        if (petData != null) {
                            petData.setInAmulet(storedCreature.getOwnerPetId(), false);
                        }
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error spawning creature from amulet " + ex);
                }
            }
            this.ageCounter = 0;
        }
        return itemStack;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.petId = nbt.func_74762_e("PetId");
        this.creatureType = nbt.func_74762_e("CreatureType");
        this.maxHealth = nbt.func_74760_g("MaxHealth");
        this.health = nbt.func_74760_g("Health");
        this.age = nbt.func_74762_e("Age");
        this.name = nbt.func_74779_i("Name");
        this.spawnClass = nbt.func_74762_e("SpawnClass");
        this.isRideable = nbt.func_74767_n("Rideable");
        this.armor = nbt.func_74771_c("Armor");
        this.isAdult = nbt.func_74767_n("Adult");
        this.ownerName = nbt.func_74779_i("OwnerName");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("PetID", this.petId);
        nbt.func_74768_a("CreatureType", this.creatureType);
        nbt.func_74776_a("MaxHealth", this.maxHealth);
        nbt.func_74776_a("Health", this.health);
        nbt.func_74768_a("Age", this.age);
        nbt.func_74778_a("Name", this.name);
        nbt.func_74768_a("SpawnClass", this.spawnClass);
        nbt.func_74757_a("Rideable", this.isRideable);
        nbt.func_74774_a("Armor", this.armor);
        nbt.func_74757_a("Adult", this.isAdult);
        nbt.func_74778_a("OwnerName", this.ownerName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        this.initAndReadNBT(itemStack);
        if (this.name.length() > 0) {
            par3List.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"entity.MoCreatures.Horse.name"));
        }
        if (this.name.length() > 0) {
            par3List.add(EnumChatFormatting.BLUE + this.name);
        }
        if (this.ownerName.length() > 0) {
            par3List.add(EnumChatFormatting.DARK_BLUE + new ChatComponentTranslation("amulet_and_fishnet_desc.MoCreatures.ownedBy", new Object[]{this.ownerName}).func_150261_e());
        }
    }

    private void initAndReadNBT(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbtcompound = itemStack.field_77990_d;
        this.readFromNBT(nbtcompound);
    }
}

