/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.monster;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityAmbient;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.animal.MoCEntityBear;
import drzhark.mocreatures.entity.animal.MoCEntityBigCat;
import drzhark.mocreatures.entity.animal.MoCEntityHorse;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.entity.item.MoCEntityKittyBed;
import drzhark.mocreatures.entity.item.MoCEntityLitterBox;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityWWolf
extends MoCEntityMob {
    public int mouthCounter;
    public int tailCounter;
    private int attackDamage;

    public MoCEntityWWolf(World world) {
        super(world);
        this.attackDamage = this.field_70170_p.field_73013_u.func_151525_a() + 1;
        this.func_70105_a(0.9f, 1.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.attackDamage);
    }

    @Override
    public boolean isPredator() {
        return true;
    }

    @Override
    protected double getAttackStrength() {
        return 3.0;
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            this.setType(this.field_70146_Z.nextInt(5) + 1);
        }
    }

    @Override
    public boolean checkSpawningBiome() {
        int zCoordinate;
        int yCoordinate;
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        BiomeGenBase biome = MoCTools.biomekind(this.field_70170_p, xCoordinate, yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v));
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            this.setType(3);
        }
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("wolfblack.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("wolfwild.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("wolftimber.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("wolfbrown.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("wolfdark.png");
            }
            case 6: {
                return MoCreatures.proxy.getTexture("wolfbright.png");
            }
        }
        return MoCreatures.proxy.getTexture("wolfwild.png");
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (this.field_70724_aR <= 0 && (double)distanceToEntity < 2.5 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            if (MoCreatures.isWitcheryLoaded && entity instanceof EntityPlayer && (MoCTools.isPlayerInWolfForm((EntityPlayer)entity) || MoCTools.isPlayerInWerewolfForm((EntityPlayer)entity))) {
                this.field_70789_a = null;
                return;
            }
            this.openMouth();
            this.field_70724_aR = 20;
            this.func_70652_k(entity);
        }
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.moveTail();
        }
        if (this.mouthCounter > 0 && ++this.mouthCounter > 15) {
            this.mouthCounter = 0;
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
    }

    @Override
    protected Entity func_70782_k() {
        EntityLivingBase entityLiving;
        EntityPlayer entityPlayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        if (entityPlayer != null) {
            if (MoCTools.isPlayerInWolfForm(entityPlayer) || MoCTools.isPlayerInWerewolfForm(entityPlayer)) {
                EntityLivingBase entityThatAttackedMaxLevelWerewolfPlayer;
                if ((MoCTools.isPlayerInWerewolfForm(entityPlayer) && entityPlayer.func_110138_aP() == 60.0f || MoCTools.isPlayerInWolfForm(entityPlayer) && entityPlayer.func_110138_aP() == 32.0f) && (entityThatAttackedMaxLevelWerewolfPlayer = entityPlayer.func_70643_av()) != null) {
                    return entityThatAttackedMaxLevelWerewolfPlayer;
                }
                return null;
            }
            return entityPlayer;
        }
        if (this.field_70146_Z.nextInt(80) == 0 && (entityLiving = MoCTools.getClosestEntityLivingThatCanBeTargetted((Entity)this, 10.0)) != null && !(entityLiving instanceof EntityPlayer) && this.func_70685_l((Entity)entityLiving)) {
            return entityLiving;
        }
        return null;
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return !(entity instanceof EntityLiving) || entity instanceof EntityMob || entity instanceof MoCEntityEgg || entity instanceof EntityPlayer || entity instanceof MoCEntityKittyBed || entity instanceof MoCEntityLitterBox || entity instanceof MoCEntityAnimal && ((MoCEntityAnimal)entity).getIsTamed() || entity instanceof EntityWolf && !MoCreatures.proxy.attackWolves || entity instanceof MoCEntityHorse && !MoCreatures.proxy.attackHorses || entity instanceof MoCEntityAnimal || entity instanceof MoCEntityAmbient || entity instanceof MoCEntityBigCat || entity instanceof MoCEntityBear;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
        if (entityThatAttackedThisCreature != null && entityThatAttackedThisCreature instanceof EntityPlayer && (MoCTools.isPlayerInWerewolfForm((EntityPlayer)entityThatAttackedThisCreature) || MoCTools.isPlayerInWolfForm((EntityPlayer)entityThatAttackedThisCreature))) {
            damageSource = DamageSource.field_76377_j;
        }
        return super.func_70097_a(damageSource, damageTaken);
    }

    @Override
    public boolean func_70601_bi() {
        return this.checkSpawningBiome() && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) && super.func_70601_bi();
    }

    protected String func_70673_aS() {
        return "mocreatures:wolfdeath";
    }

    protected Item func_146068_u() {
        return MoCreatures.fur;
    }

    protected String func_70621_aR() {
        this.openMouth();
        return "mocreatures:wolfhurt";
    }

    protected String func_70639_aQ() {
        this.openMouth();
        return "mocreatures:wolfgrunt";
    }

    @Override
    public boolean entitiesThatAreScary(Entity entityNearby) {
        return false;
    }
}

