/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.monster;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.animal.MoCEntityPetScorpion;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityScorpion
extends MoCEntityMob {
    private boolean isPoisoning;
    private int poisontimer;
    public int mouthCounter;
    public int armCounter;
    private int hideCounter;
    private int attackDamage;

    public MoCEntityScorpion(World world) {
        super(world);
        this.attackDamage = this.field_70170_p.field_73013_u.func_151525_a();
        this.func_70105_a(1.4f, 0.9f);
        this.poisontimer = 0;
        this.setAdult(true);
        this.setMoCAge(20);
        if (MoCreatures.isServer()) {
            if (this.field_70146_Z.nextInt(4) == 0) {
                this.setHasBabies(true);
            } else {
                this.setHasBabies(false);
            }
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.checkSpawningBiome() && this.getType() == 0) {
            this.setType(1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("scorpiondirt.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("scorpioncave.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("scorpionnether.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("scorpionfrost.png");
            }
        }
        return MoCreatures.proxy.getTexture("scorpiondirt.png");
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    public boolean getHasBabies() {
        return this.getIsAdult() && this.field_70180_af.func_75683_a(23) == 1;
    }

    public boolean getIsPicked() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    public boolean getIsPoisoning() {
        return this.isPoisoning;
    }

    public void setHasBabies(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(23, (Object)input);
    }

    public void setPicked(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    public void setPoisoning(boolean flag) {
        if (flag && MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.isPoisoning = flag;
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.setPoisoning(true);
        } else if (animationType == 1) {
            this.armCounter = 1;
        } else if (animationType == 3) {
            this.mouthCounter = 1;
        }
    }

    @Override
    public float getMoveSpeed() {
        return 0.8f;
    }

    @Override
    public boolean func_70617_f_() {
        return this.field_70123_F;
    }

    public boolean climbing() {
        return !this.field_70122_E && this.func_70617_f_();
    }

    protected void findSunLightShelter() {
        Vec3 vectorThreeDimensionalToPossibleShelter = this.findPossibleShelter();
        if (vectorThreeDimensionalToPossibleShelter == null) {
            ++this.hideCounter;
            if (this.hideCounter > 200) {
                this.hideCounter = 0;
            }
            this.func_70779_j();
            return;
        }
        this.func_70661_as().func_75492_a(vectorThreeDimensionalToPossibleShelter.field_72450_a, vectorThreeDimensionalToPossibleShelter.field_72448_b, vectorThreeDimensionalToPossibleShelter.field_72449_c, (double)(this.getMoveSpeed() / 2.0f));
    }

    private boolean wantsToHide() {
        return this.field_70170_p.func_72935_r();
    }

    @Override
    public void func_70636_d() {
        if (MoCreatures.isServer() && this.wantsToHide()) {
            this.findSunLightShelter();
        }
        if (!this.field_70122_E && this.field_70154_o != null) {
            this.field_70177_z = this.field_70154_o.field_70177_z;
        }
        if (this.getIsAdult() && this.field_70788_c > 0) {
            this.field_70788_c = 0;
        }
        if (this.mouthCounter != 0 && this.mouthCounter++ > 50) {
            this.mouthCounter = 0;
        }
        if (MoCreatures.isServer() && (this.armCounter == 10 || this.armCounter == 40)) {
            this.func_85030_a("mocreatures:scorpionclaw", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
        if (this.armCounter != 0 && this.armCounter++ > 24) {
            this.armCounter = 0;
        }
        if (this.getIsPoisoning()) {
            ++this.poisontimer;
            if (this.poisontimer == 1) {
                this.func_85030_a("mocreatures:scorpionsting", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            }
            if (this.poisontimer > 50) {
                this.poisontimer = 0;
                this.setPoisoning(false);
            }
        }
        if (MoCreatures.isServer() && !this.getIsAdult() && this.field_70146_Z.nextInt(200) == 0) {
            this.setMoCAge(this.getMoCAge() + 1);
            if (this.getMoCAge() >= 120) {
                this.setAdult(true);
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (super.func_70097_a(damageSource, damageTaken)) {
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (entityThatAttackedThisCreature != null && entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u.func_151525_a() > 0 && this.getIsAdult()) {
                this.field_70789_a = entityThatAttackedThisCreature;
            }
            return true;
        }
        return false;
    }

    @Override
    protected Entity func_70782_k() {
        if (this.field_70170_p.field_73013_u.func_151525_a() > 0 && !this.field_70170_p.func_72935_r() && this.getIsAdult()) {
            EntityLivingBase entityLiving;
            EntityPlayer entityPlayer = this.field_70170_p.func_72856_b((Entity)this, 12.0);
            if (entityPlayer != null) {
                return entityPlayer;
            }
            if (this.field_70146_Z.nextInt(80) == 0 && (entityLiving = MoCTools.getClosestEntityLivingThatCanBeTargetted((Entity)this, 10.0)) != null && !(entityLiving instanceof EntityPlayer) && this.func_70685_l((Entity)entityLiving)) {
                return entityLiving;
            }
        }
        return null;
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return super.shouldEntityBeIgnored(entity) || this.getIsTamed() && entity instanceof MoCEntityScorpion && ((MoCEntityScorpion)entity).getIsTamed();
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (distanceToEntity > 2.0f && distanceToEntity < 6.0f && this.field_70146_Z.nextInt(50) == 0) {
            if (this.field_70122_E) {
                double xDistance = entity.field_70165_t - this.field_70165_t;
                double zDistance = entity.field_70161_v - this.field_70161_v;
                float overallHorizontalDistanceSquared = MathHelper.func_76133_a((double)(xDistance * xDistance + zDistance * zDistance));
                this.field_70159_w = xDistance / (double)overallHorizontalDistanceSquared * 0.5 * 0.8 + this.field_70159_w * 0.2;
                this.field_70179_y = zDistance / (double)overallHorizontalDistanceSquared * 0.5 * 0.8 + this.field_70179_y * 0.2;
                this.field_70181_x = 0.4;
            }
        } else if (this.field_70724_aR <= 0 && (double)distanceToEntity < 3.0 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            if (!this.getIsPoisoning() && this.field_70146_Z.nextInt(5) == 0 && entity instanceof EntityLivingBase) {
                this.stingAndApplyEffectOnEntity(entity);
            } else {
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.attackDamage);
                this.swingArm();
            }
        }
    }

    private void stingAndApplyEffectOnEntity(Entity entity) {
        int potionTime = 70;
        this.setPoisoning(true);
        if (this.getType() <= 1) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, potionTime, 0));
        } else if (this.getType() == 2) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, potionTime, 0));
        } else if (this.getType() == 4) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, potionTime, 0));
        } else if (this.getType() == 3 && entity instanceof EntityPlayer && MoCreatures.isServer() && !this.field_70170_p.field_73011_w.field_76575_d) {
            ((EntityLivingBase)entity).func_70015_d(15);
        }
    }

    public void swingArm() {
        if (MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 1), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getType() == 3 && !this.field_70178_ae) {
            this.field_70178_ae = true;
        }
    }

    public boolean swingingTail() {
        return this.getIsPoisoning() && this.poisontimer < 15;
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (MoCreatures.isServer() && this.getIsAdult() && this.getHasBabies()) {
            int k = this.field_70146_Z.nextInt(5);
            for (int i = 0; i < k; ++i) {
                MoCEntityPetScorpion entityBabyScorpion = new MoCEntityPetScorpion(this.field_70170_p);
                entityBabyScorpion.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                entityBabyScorpion.setAdult(false);
                entityBabyScorpion.setType(this.getType());
                this.field_70170_p.func_72838_d((Entity)entityBabyScorpion);
            }
        }
    }

    protected String func_70673_aS() {
        return "mocreatures:scorpiondying";
    }

    protected String func_70621_aR() {
        return "mocreatures:scorpionhurt";
    }

    protected String func_70639_aQ() {
        if (MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 3), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        return "mocreatures:scorpiongrunt";
    }

    protected Item func_146068_u() {
        if (!this.getIsAdult()) {
            return null;
        }
        boolean flag = this.field_70146_Z.nextInt(100) < MoCreatures.proxy.rareItemDropChance;
        switch (this.getType()) {
            case 1: {
                if (flag) {
                    return MoCreatures.scorpStingDirt;
                }
                return MoCreatures.chitin;
            }
            case 2: {
                if (flag) {
                    return MoCreatures.scorpStingCave;
                }
                return MoCreatures.chitinCave;
            }
            case 3: {
                if (flag) {
                    return MoCreatures.scorpStingNether;
                }
                return MoCreatures.chitinNether;
            }
            case 4: {
                if (flag) {
                    return MoCreatures.scorpStingFrost;
                }
                return MoCreatures.chitinFrost;
            }
        }
        return null;
    }

    protected void func_70628_a(boolean flag, int x) {
        if (!flag) {
            return;
        }
        Item item = this.func_146068_u();
        if (item != null && this.field_70146_Z.nextInt(3) == 0) {
            this.func_145779_a(item, 1);
        }
    }

    @Override
    public boolean func_70601_bi() {
        return this.func_70814_o() && MoCreatures.entityMap.get(this.getClass()).getFrequency() > 0 && this.checkSpawningBiome() && this.getCanSpawnHereLiving() && this.getCanSpawnHereCreature();
    }

    @Override
    public boolean checkSpawningBiome() {
        if (this.getType() == 0) {
            int zCoordinate;
            int yCoordinate;
            if (this.field_70170_p.field_73011_w.field_76575_d) {
                this.setType(3);
                this.field_70178_ae = true;
                return true;
            }
            int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
            BiomeGenBase currentBiome = MoCTools.biomekind(this.field_70170_p, xCoordinate, yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v));
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                this.setType(4);
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                return false;
            }
            if (!this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) && this.field_70163_u < 50.0) {
                this.setType(2);
                return true;
            }
        }
        return true;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setHasBabies(nbtTagCompound.func_74767_n("Babies"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("Babies", this.getHasBabies());
    }

    public boolean func_70650_aV() {
        return this.wantsToHide() && this.field_70789_a == null && this.hideCounter < 50;
    }

    public int func_70627_aG() {
        return 300;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public float getAdjustedYOffset() {
        return 30.0f;
    }

    @Override
    public boolean entitiesThatAreScary(Entity entityNearby) {
        return false;
    }
}

